/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.managers.style.Bounds;
import com.alee.managers.style.BoundsType;
import com.alee.painter.decoration.AbstractDecoration;
import com.alee.painter.decoration.content.IContent;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public abstract class ContentDecoration<C extends JComponent, I extends ContentDecoration<C, I>>
extends AbstractDecoration<C, I> {
    @XStreamImplicit
    protected List<IContent> contents = new ArrayList<IContent>(1);

    @Override
    public void activate(C c) {
        super.activate(c);
        for (IContent content : this.getContent()) {
            content.activate((JComponent)c, this);
        }
    }

    @Override
    public void deactivate(C c) {
        super.deactivate(c);
        for (IContent content : this.getContent()) {
            content.deactivate((JComponent)c, this);
        }
    }

    @Override
    public boolean hasContent() {
        return CollectionUtils.notEmpty(this.contents);
    }

    public List<IContent> getContent() {
        return this.hasContent() ? this.contents : Collections.emptyList();
    }

    @Override
    public int getBaseline(C c, Bounds bounds) {
        Bounds borderBounds = new Bounds(bounds, BoundsType.border, (JComponent)c, this);
        Bounds paddingBounds = new Bounds(borderBounds, BoundsType.padding, (JComponent)c, this);
        for (IContent content : this.getContent()) {
            if (!content.hasBaseline(c, this)) continue;
            Rectangle b = paddingBounds.get(content.getBoundsType());
            return content.getBaseline(c, this, b);
        }
        return super.getBaseline(c, bounds);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(C c) {
        for (IContent content : this.getContent()) {
            if (!content.hasBaseline(c, this)) continue;
            return content.getBaselineResizeBehavior(c, this);
        }
        return super.getBaselineResizeBehavior(c);
    }

    protected void paintContent(Graphics2D g2d, Bounds bounds, C c) {
        Bounds borderBounds = new Bounds(bounds, BoundsType.border, (JComponent)c, this);
        Bounds paddingBounds = new Bounds(borderBounds, BoundsType.padding, (JComponent)c, this);
        for (IContent content : this.getContent()) {
            Rectangle b = paddingBounds.get(content.getBoundsType());
            if (b.width <= 0 || b.height <= 0) continue;
            content.paint(g2d, c, this, b);
        }
    }

    @Override
    public Dimension getPreferredSize(C c) {
        if (this.size != null) {
            return this.size;
        }
        Dimension ps = null;
        for (IContent content : this.getContent()) {
            BoundsType bt = content.getBoundsType();
            Insets bi = this.isSection() ? bt.border((JComponent)c, this) : bt.border((JComponent)c);
            Dimension available = this.isSection() ? new Dimension(Short.MAX_VALUE, Short.MAX_VALUE) : bt.bounds((Component)c).getSize();
            Dimension cps = content.getPreferredSize(c, this, available);
            cps.width += bi.left + bi.right;
            cps.height += bi.top + bi.bottom;
            ps = SwingUtils.max(cps, ps);
        }
        return ps;
    }
}

