/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.Stateful;
import com.alee.painter.decoration.background.GradientColor;
import com.alee.painter.decoration.background.GradientType;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public final class DecorationUtils {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static Paint getPaint(@NotNull GradientType type, @NotNull List<GradientColor> colors, int x1, int y1, int x2, int y2) {
        void var6_12;
        if (colors.size() == 1) {
            Color color = colors.get(0).getColor();
            return var6_12;
        } else {
            boolean fits;
            if (colors.size() <= 1) throw new DecorationException("At least one GradientColor must be provided");
            float[] f = new float[colors.size()];
            Color[] c = new Color[colors.size()];
            boolean even = colors.get(0).getFraction() == null;
            for (int i = 0; i < colors.size(); ++i) {
                GradientColor color = colors.get(i);
                if (even) {
                    f[i] = (float)i * 1.0f / (float)(colors.size() - 1);
                } else if (color.getFraction().floatValue() > 1.0f) {
                    int length = MathUtils.sqrtToInt((double)(MathUtils.sqr((int)(x2 - x1)) + MathUtils.sqr((int)(y2 - y1))));
                    f[i] = MathUtils.limit((float)0.0f, (float)color.getFraction().floatValue(), (float)length) / (float)length;
                } else {
                    f[i] = color.getFraction().floatValue();
                }
                c[i] = color.getColor();
            }
            boolean bl = fits = x1 != x2 || y1 != y2;
            if (type == GradientType.linear) {
                if (fits) {
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(x1, y1, x2, y2, f, c);
                    return var6_12;
                } else {
                    Color color = colors.get(0).getColor();
                }
                return var6_12;
            } else {
                if (type != GradientType.radial) throw new DecorationException("Unknown GradientType provided");
                if (fits) {
                    float r = (float)Point.distance(x1, y1, x2, y2);
                    RadialGradientPaint radialGradientPaint = new RadialGradientPaint(x1, (float)y1, r, f, c);
                    return var6_12;
                } else {
                    Color color = colors.get(0).getColor();
                }
            }
        }
        return var6_12;
    }

    @NotNull
    public static String toString(boolean top, boolean left, boolean bottom, boolean right) {
        return (top ? 1 : 0) + "," + (left ? 1 : 0) + "," + (bottom ? 1 : 0) + "," + (right ? 1 : 0);
    }

    @NotNull
    public static List<String> getExtraStates(@Nullable Object object) {
        List<String> extra;
        List<String> states = object instanceof Stateful ? (CollectionUtils.notEmpty(extra = ((Stateful)object).getStates()) ? extra : Collections.emptyList()) : Collections.emptyList();
        return states;
    }

    public static void fireStatesChanged(@Nullable Component component) {
        if (component instanceof JComponent) {
            SwingUtils.firePropertyChanged(component, "decorationStates", null, null);
        }
    }

    public static void fireBorderChanged(@Nullable Component component) {
        if (component instanceof JComponent) {
            SwingUtils.firePropertyChanged(component, "decorationBorder", null, null);
        }
    }
}

