/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.utils.GraphicsUtils;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import javax.swing.JComponent;

public abstract class AbstractTextureBackground<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractTextureBackground<C, D, I>>
extends AbstractBackground<C, D, I> {
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient TexturePaint paint = null;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient Rectangle bounds = null;

    public void clearCache() {
        this.paint = null;
        this.bounds = null;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        float opacity = this.getOpacity(c, d);
        if (opacity > 0.0f) {
            Rectangle shapeBounds = shape.getBounds();
            if (this.paint == null || Objects.notEquals((Object)this.bounds, (Object)shapeBounds)) {
                this.paint = this.createTexturePaint(shapeBounds, c, d);
                this.bounds = shapeBounds;
            }
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
            Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)this.paint);
            g2d.setPaint(this.paint);
            g2d.fill(shape);
            GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        }
    }

    @NotNull
    protected abstract TexturePaint createTexturePaint(@NotNull Rectangle var1, @NotNull C var2, @NotNull D var3);
}

