/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

@XStreamAlias(value="ColorBackground")
public class ColorBackground<C extends JComponent, D extends IDecoration<C, D>, I extends ColorBackground<C, D, I>>
extends AbstractBackground<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Color color;

    @Nullable
    protected Color getColor(@NotNull C c, @NotNull D d) {
        return this.color;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        Color color;
        float opacity = this.getOpacity(c, d);
        if (opacity > 0.0f && (color = this.getColor(c, d)) != null) {
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
            Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)color);
            g2d.fill(shape);
            GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        }
    }
}

