/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.border;

import com.alee.api.annotations.NotNull;
import com.alee.painter.decoration.border.BorderWidth;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.StringTokenizer;

public final class BorderWidthConverter
extends AbstractSingleValueConverter {
    public static final String separator = ",";

    public boolean canConvert(@NotNull Class type) {
        return BorderWidth.class.isAssignableFrom(type);
    }

    @NotNull
    public String toString(@NotNull Object object) {
        return BorderWidthConverter.borderWidthToString((BorderWidth)object);
    }

    @NotNull
    public Object fromString(@NotNull String borderWidth) {
        return BorderWidthConverter.borderWidthFromString(borderWidth);
    }

    @NotNull
    public static String borderWidthToString(@NotNull BorderWidth borderWidth) {
        String string = borderWidth.top == borderWidth.right && borderWidth.right == borderWidth.bottom && borderWidth.bottom == borderWidth.left ? Integer.toString(borderWidth.top) : (borderWidth.top == borderWidth.bottom && borderWidth.right == borderWidth.left ? borderWidth.top + separator + borderWidth.right : (borderWidth.right == borderWidth.left ? borderWidth.top + separator + borderWidth.right + separator + borderWidth.bottom : borderWidth.top + separator + borderWidth.right + separator + borderWidth.bottom + separator + borderWidth.left));
        return string;
    }

    @NotNull
    public static BorderWidth borderWidthFromString(@NotNull String string) {
        BorderWidth borderWidth;
        try {
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            if (tokenizer.hasMoreTokens()) {
                int top = Integer.parseInt(tokenizer.nextToken().trim());
                if (tokenizer.hasMoreTokens()) {
                    int right = Integer.parseInt(tokenizer.nextToken().trim());
                    if (tokenizer.hasMoreTokens()) {
                        int bottom = Integer.parseInt(tokenizer.nextToken().trim());
                        if (tokenizer.hasMoreTokens()) {
                            int left = Integer.parseInt(tokenizer.nextToken().trim());
                            borderWidth = new BorderWidth(top, right, bottom, left);
                        } else {
                            borderWidth = new BorderWidth(top, right, bottom, right);
                        }
                    } else {
                        borderWidth = new BorderWidth(top, right, top, right);
                    }
                } else {
                    borderWidth = new BorderWidth(top, top, top, top);
                }
            } else {
                borderWidth = new BorderWidth();
            }
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse BorderWidth: " + string, (Throwable)e);
        }
        return borderWidth;
    }
}

