/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.content;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.Rotation;
import com.alee.managers.style.BoundsType;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.IContent;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public abstract class AbstractContent<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractContent<C, D, I>>
implements IContent<C, D, I> {
    @XStreamAsAttribute
    protected String id;
    @XStreamAsAttribute
    protected Boolean overwrite;
    @XStreamAsAttribute
    protected BoundsType bounds;
    @XStreamAsAttribute
    @Nullable
    protected String constraints;
    @XStreamAsAttribute
    protected Insets padding;
    @XStreamAsAttribute
    protected Dimension size;
    @XStreamAsAttribute
    protected Rotation rotation;
    @XStreamAsAttribute
    protected Float opacity;

    @NotNull
    public String getId() {
        return this.id != null ? this.id : "content";
    }

    public boolean isOverwrite() {
        return this.overwrite != null && this.overwrite != false;
    }

    @Override
    public void activate(@NotNull C c, @NotNull D d) {
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
    }

    @Override
    @NotNull
    public BoundsType getBoundsType() {
        return this.bounds != null ? this.bounds : BoundsType.padding;
    }

    @Override
    @Nullable
    public String getConstraints() {
        return this.constraints;
    }

    @Nullable
    protected Insets getPadding(@NotNull C c, @NotNull D d) {
        Insets padding;
        if (this.padding != null) {
            boolean ltr = this.isLeftToRight(c, d);
            padding = new Insets(this.padding.top, ltr ? this.padding.left : this.padding.right, this.padding.bottom, ltr ? this.padding.right : this.padding.left);
        } else {
            padding = null;
        }
        return padding;
    }

    @Nullable
    protected Dimension getSize(@NotNull C c, @NotNull D d) {
        return this.size;
    }

    @NotNull
    protected Rotation getRotation(@NotNull C c, @NotNull D d) {
        return this.rotation != null ? this.rotation : Rotation.none;
    }

    public float getOpacity(@NotNull C c, @NotNull D d) {
        return this.opacity != null ? this.opacity.floatValue() : 1.0f;
    }

    @Override
    public boolean hasBaseline(@NotNull C c, @NotNull D d) {
        Rotation rotation = this.getActualRotation(c, d);
        return (rotation == Rotation.none || rotation == Rotation.upsideDown) && this.hasContentBaseline(c, d);
    }

    protected boolean hasContentBaseline(@NotNull C c, @NotNull D d) {
        return false;
    }

    @Override
    public int getBaseline(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        int baseline;
        Rotation rotation = this.getActualRotation(c, d);
        if (rotation == Rotation.none || rotation == Rotation.upsideDown) {
            Rectangle rotated = rotation.transpose(bounds);
            Rectangle shrunk = SwingUtils.shrink(rotated, this.getPadding(c, d));
            baseline = rotation == Rotation.none ? this.getContentBaseline(c, d, shrunk) : bounds.y + bounds.height - (this.getContentBaseline(c, d, shrunk) - rotated.y);
        } else {
            baseline = -1;
        }
        return baseline;
    }

    protected int getContentBaseline(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        return -1;
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull C c, @NotNull D d) {
        Component.BaselineResizeBehavior baselineResizeBehavior;
        Rotation rotation = this.getActualRotation(c, d);
        if (rotation == Rotation.none || rotation == Rotation.upsideDown) {
            Component.BaselineResizeBehavior behavior = this.getContentBaselineResizeBehavior(c, d);
            baselineResizeBehavior = rotation == Rotation.none ? behavior : rotation.adjust(behavior);
        } else {
            baselineResizeBehavior = Component.BaselineResizeBehavior.OTHER;
        }
        return baselineResizeBehavior;
    }

    @NotNull
    public Component.BaselineResizeBehavior getContentBaselineResizeBehavior(@NotNull C c, @NotNull D d) {
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        if (bounds.width > 0 && bounds.height > 0 && !this.isEmpty(c, d)) {
            float opacity = this.getOpacity(c, d);
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
            AffineTransform transform = g2d.getTransform();
            Rotation rotation = this.getActualRotation(c, d);
            if (rotation != Rotation.none) {
                double angle = 0.0;
                double rX = 0.0;
                double rY = 0.0;
                switch (rotation) {
                    case clockwise: {
                        angle = 1.5707963267948966;
                        rX = bounds.width;
                        rY = bounds.width;
                        break;
                    }
                    case upsideDown: {
                        angle = Math.PI;
                        rX = bounds.width;
                        rY = bounds.height;
                        break;
                    }
                    case counterClockwise: {
                        angle = -1.5707963267948966;
                        rX = bounds.height;
                        rY = bounds.height;
                    }
                }
                g2d.rotate(angle, (double)bounds.x + rX / 2.0, (double)bounds.y + rY / 2.0);
            }
            Rectangle rotated = rotation.transpose(bounds);
            Rectangle shrunk = SwingUtils.shrink(rotated, this.getPadding(c, d));
            Shape os = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)shrunk);
            this.paintContent(g2d, c, d, shrunk);
            GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)os);
            g2d.setTransform(transform);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc);
        }
    }

    protected abstract void paintContent(@NotNull Graphics2D var1, @NotNull C var2, @NotNull D var3, @NotNull Rectangle var4);

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Insets padding = this.getPadding(c, d);
        Rotation rotation = this.getActualRotation(c, d);
        Dimension shrunk = SwingUtils.shrink(available, padding);
        Dimension transposed = rotation.transpose(shrunk);
        Dimension hardcoded = this.getSize(c, d);
        Dimension ps = hardcoded != null ? rotation.transpose(hardcoded) : this.getContentPreferredSize(c, d, transposed);
        Dimension stretched = SwingUtils.stretch(ps, padding);
        return rotation.transpose(stretched);
    }

    @NotNull
    protected abstract Dimension getContentPreferredSize(@NotNull C var1, @NotNull D var2, @NotNull Dimension var3);

    @NotNull
    protected Rotation getActualRotation(@NotNull C c, @NotNull D d) {
        Rotation tr = this.getRotation(c, d);
        return this.isLeftToRight(c, d) ? tr : tr.rightToLeft();
    }

    protected boolean isLeftToRight(@NotNull C c, @NotNull D d) {
        return ((Component)c).getComponentOrientation().isLeftToRight();
    }
}

