/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.content;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;

@XStreamAlias(value="DashFocus")
public class DashFocus<C extends JComponent, D extends IDecoration<C, D>, I extends DashFocus<C, D, I>>
extends AbstractContent<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Integer round;
    @XStreamAsAttribute
    @Nullable
    protected Stroke stroke;
    @XStreamAsAttribute
    @Nullable
    protected Color color;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "dash-focus";
    }

    protected int getRound(@NotNull C c, @NotNull D d) {
        return this.round != null ? this.round : 0;
    }

    @Nullable
    public Stroke getStroke(@NotNull C c, @NotNull D d) {
        return this.stroke;
    }

    @NotNull
    protected Color getColor(@NotNull C c, @NotNull D d) {
        if (this.color == null) {
            throw new DecorationException("Focus color must be specified");
        }
        return this.color;
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        return false;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        Stroke stroke;
        Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)stroke, ((stroke = this.getStroke(c, d)) != null ? 1 : 0) != 0);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)this.getColor(c, d));
        int round = this.getRound(c, d);
        g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, round, round);
        GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os, (stroke != null ? 1 : 0) != 0);
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        return new Dimension(0, 0);
    }
}

