/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shadow;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.shadow.AbstractShadow;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.utils.ImageUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

@XStreamAlias(value="ExpandingShadow")
public class ExpandingShadow<C extends JComponent, D extends IDecoration<C, D>, I extends ExpandingShadow<C, D, I>>
extends AbstractShadow<C, D, I> {
    protected static final transient Map<String, WeakReference<NinePatchIcon>> shadowCache = new HashMap<String, WeakReference<NinePatchIcon>>(4);
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient String shadowKey;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient NinePatchIcon shadowIcon;

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        int width = this.getWidth();
        float opacity = this.getOpacity();
        if (width > 0 && opacity > 0.0f) {
            ShadowType type = this.getType();
            if (type == ShadowType.outer) {
                Rectangle b = shape.getBounds();
                Rectangle sb = new Rectangle(b.x - width, b.y - width, b.width + width * 2, b.height + width * 2);
                this.getShadow(width, opacity).paintIcon(g2d, sb.x, sb.y, sb.width, sb.height);
            } else {
                throw new DecorationException("Inner shadow type is not supported by this shadow");
            }
        }
    }

    @NotNull
    protected NinePatchIcon getShadow(int width, float opacity) {
        String key = this.getShadowKey(width, opacity);
        if (this.shadowIcon == null || Objects.notEquals((Object)key, (Object)this.shadowKey)) {
            this.shadowKey = key;
            WeakReference<NinePatchIcon> reference = shadowCache.get(key);
            NinePatchIcon ninePatchIcon = this.shadowIcon = reference != null ? (NinePatchIcon)reference.get() : null;
            if (this.shadowIcon == null) {
                this.shadowIcon = this.createShadowIcon(new Rectangle(width * 6, width * 6), width, opacity);
                shadowCache.put(key, new WeakReference<NinePatchIcon>(this.shadowIcon));
            }
        }
        return this.shadowIcon;
    }

    @NotNull
    protected NinePatchIcon createShadowIcon(@NotNull Rectangle bounds, int width, float opacity) {
        GeneralPath gp = new GeneralPath(0);
        gp.moveTo((double)bounds.x + (double)width * 1.2, (double)bounds.y + (double)width * 1.2);
        gp.lineTo((double)(bounds.x + bounds.width) - (double)width * 1.2, (double)bounds.y + (double)width * 1.2);
        gp.lineTo((double)(bounds.x + bounds.width - width), (double)(bounds.y + bounds.height) - (double)width * 0.5);
        gp.quadTo((double)(bounds.x + bounds.width / 2), (double)(bounds.y + bounds.height) - (double)width * 1.9, (double)(bounds.x + width), (double)(bounds.y + bounds.height) - (double)width * 0.5);
        gp.closePath();
        BufferedImage shadowImage = ImageUtils.createShadowImage((int)bounds.width, (int)bounds.height, (Shape)gp, (int)width, (float)opacity, (boolean)false);
        int w = shadowImage.getWidth();
        int inner = width / 2;
        NinePatchIcon ninePatchIcon = new NinePatchIcon(shadowImage, false);
        ninePatchIcon.addHorizontalStretch(0, width + inner, true);
        ninePatchIcon.addHorizontalStretch(width + inner + 1, w - width - inner - 1, false);
        ninePatchIcon.addHorizontalStretch(w - width - inner, w, true);
        ninePatchIcon.addVerticalStretch(0, width + inner, true);
        ninePatchIcon.addVerticalStretch(width + inner + 1, w - width - inner - 1, false);
        ninePatchIcon.addVerticalStretch(w - width - inner, w, true);
        ninePatchIcon.setMargin(width);
        return ninePatchIcon;
    }

    @NotNull
    protected String getShadowKey(int width, float opacity) {
        return width + "," + opacity;
    }
}

