/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.UtilityException;
import com.alee.utils.font.DerivedFontAttributes;
import com.alee.utils.map.SoftHashMap;
import java.awt.Component;
import java.awt.Font;
import java.util.Map;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public final class FontUtils {
    @NotNull
    private static final Map<DerivedFontAttributes, Font> derivedFontsCache = new SoftHashMap();
    public static final int MIN_LAYOUT_CHARCODE = 768;
    public static final int MAX_LAYOUT_CHARCODE = 8303;
    public static final int HI_SURROGATE_START = 55296;
    public static final int LO_SURROGATE_END = 57343;

    private FontUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static void clearDerivedFontsCache() {
        derivedFontsCache.clear();
    }

    @NotNull
    public static Font getCachedDerivedFont(@NotNull Font font, int style, int size) {
        DerivedFontAttributes attribute = FontUtils.getFontAttribute(font, style, size);
        Font derivedFont = derivedFontsCache.get(attribute);
        if (derivedFont == null) {
            derivedFont = font.deriveFont(style, size);
            derivedFontsCache.put(attribute, derivedFont);
        }
        return derivedFont;
    }

    @NotNull
    protected static DerivedFontAttributes getFontAttribute(@NotNull Font font, int style, int size) {
        return new DerivedFontAttributes(font, style, size);
    }

    public static boolean isComplexLayout(@NotNull char[] characters, int start, int limit) {
        return FontUtils.isComplexText(characters, start, limit);
    }

    public static boolean isComplexText(@NotNull char[] characters, int start, int limit) {
        boolean complex = false;
        for (int i = start; i < limit; ++i) {
            if (characters[i] < '\u0300' || !FontUtils.isNonSimpleChar(characters[i])) continue;
            complex = true;
            break;
        }
        return complex;
    }

    private static boolean isNonSimpleChar(char character) {
        return FontUtils.isComplexCharCode(character) || character >= '\ud800' && character <= '\udfff';
    }

    private static boolean isComplexCharCode(int code) {
        boolean complex = code < 768 || code > 8303 ? false : (code <= 879 ? true : (code < 1424 ? false : (code <= 1791 ? true : (code < 2304 ? false : (code <= 3711 ? true : (code < 6016 ? false : (code <= 6143 ? true : (code < 8204 ? false : (code <= 8205 ? true : (code >= 8234 && code <= 8238 ? true : code >= 8298))))))))));
        return complex;
    }

    @Nullable
    public static FontUIResource getFontUIResource(@Nullable Font font) {
        FontUIResource fontUIResource = font != null ? (font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font)) : null;
        return fontUIResource;
    }

    public static void replaceFontUIResource(@NotNull Component component, @Nullable Font font) {
        Font oldFont = component.getFont();
        if (oldFont == null || oldFont instanceof UIResource) {
            component.setFont(font);
        }
    }
}

