/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Function;
import com.alee.laf.LookAndFeelException;
import com.alee.laf.WebUI;
import com.alee.utils.LafUtils;
import com.alee.utils.UtilityException;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public final class LafLookup {
    private LafLookup() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @Nullable
    public static InputMap getInputMap(final @NotNull JComponent component, int condition) {
        InputMap inputMap;
        Object ui = LafUtils.getUI(component);
        if (ui instanceof WebUI) {
            WebUI webUI = (WebUI)ui;
            inputMap = condition == 2 ? LafLookup.getCompleteInputMap(component, ui, webUI, condition, new Function<Object, InputMap>(){

                @Nullable
                public InputMap apply(Object property) {
                    Object[] bindings = (Object[])property;
                    return bindings != null ? LookAndFeel.makeComponentInputMap(component, bindings) : null;
                }
            }) : LafLookup.getCompleteInputMap(component, ui, webUI, condition, new Function<Object, InputMap>(){

                @Nullable
                public InputMap apply(Object property) {
                    return (InputMap)property;
                }
            });
        } else {
            throw new LookAndFeelException("Component UI is not a WebUI implementation: " + ui);
        }
        return inputMap;
    }

    @Nullable
    private static InputMap getCompleteInputMap(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull WebUI webUI, int condition, @NotNull Function<Object, InputMap> propertyToInputMap) {
        InputMap rtlInputMap;
        String key = LafLookup.getInputMapPropertyKey(webUI, condition);
        InputMap inputMap = (InputMap)propertyToInputMap.apply(LafLookup.get(component, ui, key));
        if (inputMap != null && !component.getComponentOrientation().isLeftToRight() && (rtlInputMap = (InputMap)propertyToInputMap.apply(LafLookup.get(component, ui, key + ".RightToLeft"))) != null) {
            rtlInputMap.setParent(inputMap);
            inputMap = rtlInputMap;
        }
        return inputMap;
    }

    @NotNull
    private static String getInputMapPropertyKey(@NotNull WebUI webUI, int condition) {
        String key;
        if (condition == 2) {
            key = webUI.getPropertyPrefix() + "windowBindings";
        } else if (condition == 0) {
            key = webUI.getPropertyPrefix() + "focusInputMap";
        } else if (condition == 1) {
            key = webUI.getPropertyPrefix() + "ancestorInputMap";
        } else {
            throw new LookAndFeelException("Unsupported InputMap condition: " + condition);
        }
        return key;
    }

    public static int getInt(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getInt(component, ui, key, -1);
    }

    public static int getInt(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key, int defaultValue) {
        Object iValue = LafLookup.get(component, ui, key);
        int result = iValue instanceof Number ? ((Number)iValue).intValue() : defaultValue;
        return result;
    }

    @Nullable
    public static Insets getInsets(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getInsets(component, ui, key, null);
    }

    @Nullable
    public static Insets getInsets(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key, @Nullable Insets defaultValue) {
        Object iValue = LafLookup.get(component, ui, key);
        Insets result = iValue instanceof Insets ? (Insets)iValue : defaultValue;
        return result;
    }

    public static boolean getBoolean(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getBoolean(component, ui, key, false);
    }

    public static boolean getBoolean(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key, boolean defaultValue) {
        Object iValue = LafLookup.get(component, ui, key);
        boolean result = iValue instanceof Boolean ? (Boolean)iValue : defaultValue;
        return result;
    }

    @Nullable
    public static Color getColor(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getColor(component, ui, key, null);
    }

    @Nullable
    public static Color getColor(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key, @Nullable Color defaultValue) {
        Object iValue = LafLookup.get(component, ui, key);
        Color result = iValue instanceof Color ? (Color)iValue : defaultValue;
        return result;
    }

    @Nullable
    public static Icon getIcon(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getIcon(component, ui, key, null);
    }

    @Nullable
    public static Icon getIcon(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key, @Nullable Icon defaultValue) {
        Object iValue = LafLookup.get(component, ui, key);
        Icon result = iValue instanceof Icon ? (Icon)iValue : defaultValue;
        return result;
    }

    @Nullable
    public static Border getBorder(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key) {
        return LafLookup.getBorder(component, ui, key, null);
    }

    @Nullable
    public static Border getBorder(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key, @Nullable Border defaultValue) {
        Object iValue = LafLookup.get(component, ui, key);
        Border result = iValue instanceof Border ? (Border)iValue : defaultValue;
        return result;
    }

    @Nullable
    public static Object get(@NotNull JComponent component, @NotNull ComponentUI ui, @NotNull String key) {
        return UIManager.get(key, component.getLocale());
    }
}

