/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.LookAndFeelException;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.UtilityException;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;

public final class LafUtils {
    private LafUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isInDecoratedWindow(@Nullable Component component) {
        RootPaneUI ui;
        boolean result = false;
        JRootPane rootPane = CoreSwingUtils.getRootPane((Component)component);
        if (rootPane != null && (ui = rootPane.getUI()) instanceof WRootPaneUI) {
            result = ((WRootPaneUI)ui).isDecorated();
        }
        return result;
    }

    public static boolean hasUI(@NotNull JComponent component) {
        return ReflectUtils.hasMethod((Object)component, (String)"getUI", (Object[])new Object[0]);
    }

    @Nullable
    public static <U extends ComponentUI> U getUI(@NotNull JComponent component) {
        try {
            return (U)((ComponentUI)ReflectUtils.callMethod((Object)component, (String)"getUI", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new StyleException("Unable to retrieve component UI: " + component, e);
        }
    }

    public static void setUI(@NotNull JComponent component, @Nullable ComponentUI ui) {
        try {
            ReflectUtils.callMethod((Object)component, (String)"setUI", (Object[])new Object[]{ui});
        }
        catch (Exception e) {
            throw new StyleException("Unable to setup component UI: " + component, e);
        }
    }

    public static boolean hasWebLafUI(@NotNull JComponent component) {
        boolean webUI;
        if (StyleManager.isSupported(component)) {
            Object ui = LafUtils.getUI(component);
            ComponentDescriptor descriptor = StyleManager.getDescriptor(component);
            webUI = ui != null && descriptor.getBaseUIClass().isAssignableFrom(ui.getClass());
        } else {
            webUI = false;
        }
        return webUI;
    }

    @NotNull
    public static Point getTextCenterShift(@NotNull FontMetrics metrics, @NotNull String text) {
        return new Point(LafUtils.getTextCenterShiftX(metrics, text), LafUtils.getTextCenterShiftY(metrics));
    }

    public static int getTextCenterShiftX(@NotNull FontMetrics metrics, @NotNull String text) {
        return -metrics.stringWidth(text) / 2;
    }

    public static int getTextCenterShiftY(@NotNull FontMetrics metrics) {
        return (metrics.getAscent() - metrics.getLeading() - metrics.getDescent()) / 2;
    }

    public static void setupLookAndFeel(@NotNull Class<? extends LookAndFeel> clazz) throws LookAndFeelException {
        LafUtils.setupLookAndFeel(clazz.getCanonicalName());
    }

    public static void setupLookAndFeel(@NotNull String className) throws LookAndFeelException {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize LaF for class name: " + className, e);
        }
    }

    public static void installDefaults(@NotNull JComponent component, @NotNull String prefix) {
        if (SwingUtils.isUIResource(component.getFont())) {
            component.setFont(UIManager.getFont(prefix + "font"));
        }
        if (SwingUtils.isUIResource(component.getBackground())) {
            component.setBackground(UIManager.getColor(prefix + "background"));
        }
        if (SwingUtils.isUIResource(component.getForeground())) {
            component.setForeground(UIManager.getColor(prefix + "foreground"));
        }
    }

    public static void uninstallDefaults(@NotNull JComponent component) {
        if (SwingUtils.isUIResource(component.getForeground())) {
            component.setForeground(null);
        }
        if (SwingUtils.isUIResource(component.getBackground())) {
            component.setBackground(null);
        }
        if (SwingUtils.isUIResource(component.getFont())) {
            component.setFont(null);
        }
        LookAndFeel.uninstallBorder(component);
    }
}

