/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.ColorUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.reflection.ReflectionException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.slf4j.LoggerFactory;

public final class ProprietaryUtils {
    private static boolean windowTransparencyAllowed = true;
    private static boolean windowShapeAllowed = true;
    private static boolean allowLinuxTransparency = false;

    private ProprietaryUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isAllowLinuxTransparency() {
        return allowLinuxTransparency;
    }

    public static void setAllowLinuxTransparency(boolean allow) {
        allowLinuxTransparency = allow;
    }

    public static void installAWTEventListener() {
        try {
            LookAndFeel laf = UIManager.getLookAndFeel();
            if (laf instanceof BasicLookAndFeel) {
                ReflectUtils.callMethod((Object)laf, (String)"installAWTEventListener", (Object[])new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
        }
    }

    public static void setupAATextInfo(@NotNull UIDefaults table) {
        if (SystemUtils.isJava9orAbove()) {
            try {
                Class su2 = ReflectUtils.getClass((String)"sun.swing.SwingUtilities2");
                ReflectUtils.callStaticMethod((Class)su2, (String)"putAATextInfo", (Object[])new Object[]{true, table});
            }
            catch (NoSuchMethodException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
        } else {
            try {
                Class su2 = ReflectUtils.getClass((String)"sun.swing.SwingUtilities2");
                Object aaProperty = ReflectUtils.getStaticFieldValue((Class)su2, (String)"AA_TEXT_PROPERTY_KEY");
                Class aaTextInfo = ReflectUtils.getInnerClass((Class)su2, (String)"AATextInfo");
                Object aaValue = ReflectUtils.callStaticMethod((Class)aaTextInfo, (String)"getAATextInfo", (Object[])new Object[]{true});
                table.put(aaProperty, aaValue);
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
        }
    }

    public static void setupPerformanceParameters() {
        if (SystemUtils.isJava8orAbove()) {
            System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        }
    }

    public static boolean isWindowTransparencyAllowed() {
        boolean allowed;
        try {
            if (windowTransparencyAllowed) {
                Class au = ReflectUtils.getClass((String)"com.sun.awt.AWTUtilities");
                Class t = ReflectUtils.getInnerClass((Class)au, (String)"Translucency");
                Object ppt = ReflectUtils.getStaticFieldValue((Class)t, (String)"PERPIXEL_TRANSPARENT");
                Boolean wts = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isWindowTranslucencySupported", (Object[])new Object[0]);
                Boolean tc = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isTranslucencyCapable", (Object[])new Object[]{SystemUtils.getGraphicsConfiguration()});
                Boolean ppts = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isTranslucencySupported", (Object[])new Object[]{ppt});
                allowed = wts != false && tc != false && ppts != false && (SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris() || SystemUtils.isUnix() && allowLinuxTransparency);
            } else {
                allowed = false;
            }
        }
        catch (Exception e) {
            allowed = SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris() || SystemUtils.isUnix() && allowLinuxTransparency;
        }
        return allowed;
    }

    public static void setWindowTransparencyAllowed(boolean allowed) {
        windowTransparencyAllowed = allowed;
    }

    public static boolean isWindowShapeAllowed() {
        boolean allowed;
        try {
            if (windowShapeAllowed) {
                Class au = ReflectUtils.getClass((String)"com.sun.awt.AWTUtilities");
                Class t = ReflectUtils.getInnerClass((Class)au, (String)"Translucency");
                Object ppt = ReflectUtils.getStaticFieldValue((Class)t, (String)"PERPIXEL_TRANSPARENT");
                Boolean wts = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isWindowShapingSupported", (Object[])new Object[0]);
                Boolean ppts = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isTranslucencySupported", (Object[])new Object[]{ppt});
                allowed = wts != false && ppts != false;
            } else {
                allowed = false;
            }
        }
        catch (Exception e) {
            allowed = windowShapeAllowed;
        }
        return allowed;
    }

    public static void setWindowShapeAllowed(boolean allowed) {
        windowShapeAllowed = allowed;
    }

    public static void setWindowOpaque(@Nullable Window window, boolean opaque) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ProprietaryUtils.setupOpacityBackgroundColor(window, opaque);
                } else {
                    ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setWindowOpaque", (Object[])new Object[]{window, opaque});
                }
                JRootPane rootPane = CoreSwingUtils.getRootPane((Component)window);
                if (rootPane != null) {
                    ProprietaryUtils.setupOpacityBackgroundColor(rootPane, opaque);
                    rootPane.setOpaque(opaque);
                    Container container = rootPane.getContentPane();
                    if (container != null) {
                        ProprietaryUtils.setupOpacityBackgroundColor(container, opaque);
                        if (container instanceof JComponent) {
                            ((JComponent)container).setOpaque(opaque);
                        }
                    }
                    rootPane.repaint();
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
        }
    }

    private static void setupOpacityBackgroundColor(@NotNull Component component, boolean opaque) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ReflectUtils.callMethod((Object)component, (String)"setBackground", (Object[])new Object[]{opaque ? Color.WHITE : ColorUtils.transparent()});
    }

    public static void enableMixingCutoutShape(Component component) {
        try {
            if (SystemUtils.isJava9orAbove()) {
                ReflectUtils.callMethod((Object)component, (String)"setMixingCutoutShape", (Object[])new Object[]{new Rectangle()});
            } else {
                Object componentAccessor = ReflectUtils.callStaticMethod((String)"sun.awt.AWTAccessor", (String)"getComponentAccessor", (Object[])new Object[0]);
                ReflectUtils.callMethod((Object)componentAccessor, (String)"setMixingCutoutShape", (Object[])new Object[]{component, new Rectangle()});
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
        }
    }

    public static boolean isWindowOpaque(@Nullable Window window) {
        boolean opaque = true;
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Color bg;
                Boolean isOpaque = SystemUtils.isJava7orAbove() ? Boolean.valueOf((bg = (Color)ReflectUtils.callMethod((Object)window, (String)"getBackground", (Object[])new Object[0])) == null || bg.getAlpha() == 255) : (Boolean)ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"isWindowOpaque", (Object[])new Object[]{window});
                opaque = isOpaque != null ? isOpaque : true;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
        }
        return opaque;
    }

    public static void setWindowOpacity(@Nullable Window window, float opacity) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ReflectUtils.callMethod((Object)window, (String)"setOpacity", (Object[])new Object[]{Float.valueOf(opacity)});
                } else {
                    ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setWindowOpacity", (Object[])new Object[]{window, Float.valueOf(opacity)});
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
        }
    }

    public static float getWindowOpacity(@Nullable Window window) {
        float opacity = 1.0f;
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Float retrieved = SystemUtils.isJava7orAbove() ? (Float)ReflectUtils.callMethod((Object)window, (String)"getOpacity", (Object[])new Object[0]) : (Float)ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"getWindowOpacity", (Object[])new Object[]{window});
                opacity = retrieved != null ? retrieved.floatValue() : 1.0f;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
        }
        return opacity;
    }

    public static void setWindowShape(@Nullable Window window, @Nullable Shape shape) {
        if (window != null && ProprietaryUtils.isWindowShapeAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ReflectUtils.callMethod((Object)window, (String)"setShape", (Object[])new Object[]{shape});
                } else {
                    ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setWindowShape", (Object[])new Object[]{window, shape});
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
        }
    }

    @Nullable
    public static Shape getWindowShape(@Nullable Window window) {
        Shape shape = null;
        if (window != null && ProprietaryUtils.isWindowShapeAllowed()) {
            try {
                shape = SystemUtils.isJava7orAbove() ? (Shape)ReflectUtils.callMethod((Object)window, (String)"getShape", (Object[])new Object[0]) : (Shape)ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"getWindowShape", (Object[])new Object[]{window});
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ProprietaryUtils.class).error(e.toString(), (Throwable)e);
            }
        }
        return shape;
    }

    public static void checkAndSetPolicy(@NotNull Window window) {
        block5: {
            String toolkitClass = "sun.awt.SunToolkit";
            try {
                Class toolkit = ReflectUtils.getClass((String)"sun.awt.SunToolkit");
                try {
                    if (SystemUtils.isJava7orAbove()) {
                        ReflectUtils.callStaticMethod((Class)toolkit, (String)"checkAndSetPolicy", (Object[])new Object[]{window});
                        break block5;
                    }
                    ReflectUtils.callStaticMethod((Class)toolkit, (String)"checkAndSetPolicy", (Object[])new Object[]{window, true});
                }
                catch (Exception e) {
                    String msg = "Unable to check and set window policy";
                    LoggerFactory.getLogger(ProprietaryUtils.class).error("Unable to check and set window policy", (Throwable)e);
                }
            }
            catch (Exception e) {
                String msg = "Unable to find toolkit: %s";
                LoggerFactory.getLogger(ProprietaryUtils.class).error(String.format("Unable to find toolkit: %s", "sun.awt.SunToolkit"), (Throwable)e);
            }
        }
    }

    @Nullable
    public static Frame getSharedOwnerFrame() {
        Frame sharedOwner = null;
        try {
            sharedOwner = (Frame)ReflectUtils.callStaticMethod(SwingUtilities.class, (String)"getSharedOwnerFrame", (Object[])new Object[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Unable to retrieve SharedOwnerFrame, it seems your JDK version doesn't support it";
            LoggerFactory.getLogger(ProprietaryUtils.class).error("Unable to retrieve SharedOwnerFrame, it seems your JDK version doesn't support it", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = "Exception occurred while retrieving SharedOwnerFrame";
            LoggerFactory.getLogger(ProprietaryUtils.class).error("Exception occurred while retrieving SharedOwnerFrame", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String msg = "Unable to access SharedOwnerFrame";
            LoggerFactory.getLogger(ProprietaryUtils.class).error("Unable to access SharedOwnerFrame", (Throwable)e);
        }
        return sharedOwner;
    }

    @Nullable
    public static WindowListener getSharedOwnerFrameShutdownListener() {
        WindowListener listener = null;
        try {
            listener = (WindowListener)ReflectUtils.callStaticMethod(SwingUtilities.class, (String)"getSharedOwnerFrameShutdownListener", (Object[])new Object[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Unable to retrieve SharedOwnerFrame shutdown listener, it seems your JDK version doesn't support it";
            LoggerFactory.getLogger(ProprietaryUtils.class).error("Unable to retrieve SharedOwnerFrame shutdown listener, it seems your JDK version doesn't support it", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = "Exception occurred while retrieving SharedOwnerFrame shutdown listener";
            LoggerFactory.getLogger(ProprietaryUtils.class).error("Exception occurred while retrieving SharedOwnerFrame shutdown listener", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String msg = "Unable to access SharedOwnerFrame shutdown listener";
            LoggerFactory.getLogger(ProprietaryUtils.class).error("Unable to access SharedOwnerFrame shutdown listener", (Throwable)e);
        }
        return listener;
    }

    @Nullable
    public static Window getWindowAncestorForDialog(Component component) {
        Window window = CoreSwingUtils.getWindowAncestor((Component)component);
        return window instanceof Dialog || window instanceof Frame ? window : ProprietaryUtils.getSharedOwnerFrame();
    }

    public static void setPopupWindowType(@NotNull Window window) {
        ProprietaryUtils.setWindowType(window, "POPUP");
    }

    public static void setUtilityWindowType(@NotNull Window window) {
        ProprietaryUtils.setWindowType(window, "UTILITY");
    }

    private static void setWindowType(@NotNull Window window, @NotNull String typeName) {
        if (SystemUtils.isJava7orAbove()) {
            try {
                Class type = ReflectUtils.getInnerClass(Window.class, (String)"Type");
                Object popup = ReflectUtils.getStaticFieldValue((Class)type, (String)typeName);
                ReflectUtils.callMethod((Object)window, (String)"setType", (Object[])new Object[]{popup});
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to setup Window type: " + window);
            }
        }
    }
}

