/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.merge.Overwriting;
import com.alee.api.resource.Resource;
import com.alee.utils.ImageUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.ninepatch.NinePatchIconConverter;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.ninepatch.NinePatchIntervalType;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

@XStreamConverter(value=NinePatchIconConverter.class)
public class NinePatchIcon
implements Icon,
Overwriting {
    @NotNull
    protected BufferedImage rawImage;
    @NotNull
    protected List<NinePatchInterval> horizontalStretch;
    @NotNull
    protected List<NinePatchInterval> verticalStretch;
    @NotNull
    protected Insets margin;
    @Nullable
    protected Integer cachedWidth0;
    @Nullable
    protected Integer cachedWidth1;
    @Nullable
    protected Integer cachedHeight0;
    @Nullable
    protected Integer cachedHeight1;
    @Nullable
    protected transient WeakReference<JComponent> component;

    public NinePatchIcon(@NotNull Resource resource) {
        this(resource, true);
    }

    public NinePatchIcon(@NotNull Resource resource, boolean parsePatches) {
        this(ImageUtils.loadBufferedImage((Resource)resource), parsePatches);
    }

    public NinePatchIcon(@NotNull Icon icon) {
        this(icon, true);
    }

    public NinePatchIcon(@NotNull Icon icon, boolean parsePatches) {
        this(ImageUtils.toNonNullBufferedImage((Icon)icon), parsePatches);
    }

    public NinePatchIcon(@NotNull Image image) {
        this(image, true);
    }

    public NinePatchIcon(@NotNull Image image, boolean parsePatches) {
        this(ImageUtils.toNonNullBufferedImage((Image)image), parsePatches);
    }

    public NinePatchIcon(@NotNull BufferedImage image) {
        this(image, true);
    }

    public NinePatchIcon(@NotNull BufferedImage image, boolean parsePatches) {
        if (parsePatches) {
            if (image.getWidth() < 3 || image.getHeight() < 3) {
                throw new IllegalArgumentException("Buffered image must be atleast 3x3 pixels size");
            }
            int w = image.getWidth() - 2;
            int h = image.getHeight() - 2;
            this.rawImage = ImageUtils.createCompatibleImage((int)w, (int)h, (int)image.getTransparency());
            Graphics2D g2d = this.rawImage.createGraphics();
            g2d.drawImage(image, 0, 0, w, h, 1, 1, image.getWidth() - 1, image.getHeight() - 1, null);
            g2d.dispose();
            this.horizontalStretch = NinePatchUtils.parseIntervals(image, NinePatchIntervalType.horizontalStretch);
            this.verticalStretch = NinePatchUtils.parseIntervals(image, NinePatchIntervalType.verticalStretch);
            if (this.horizontalStretch.size() <= 1 && (this.horizontalStretch.size() != 1 || this.horizontalStretch.get(0).isPixel()) || this.verticalStretch.size() <= 1 && (this.verticalStretch.size() != 1 || this.verticalStretch.get(0).isPixel())) {
                throw new IllegalArgumentException("There must be stretch constraints specified on image");
            }
            List<NinePatchInterval> vc = NinePatchUtils.parseIntervals(image, NinePatchIntervalType.verticalContent);
            List<NinePatchInterval> hc = NinePatchUtils.parseIntervals(image, NinePatchIntervalType.horizontalContent);
            int top = vc.size() == 0 ? 0 : vc.get(0).getStart();
            int bottom = vc.size() == 0 ? 0 : this.rawImage.getHeight() - vc.get(0).getEnd() - 1;
            int left = hc.size() == 0 ? 0 : hc.get(0).getStart();
            int right = hc.size() == 0 ? 0 : this.rawImage.getWidth() - hc.get(0).getEnd() - 1;
            this.margin = new Insets(top, left, bottom, right);
            this.getFixedPixelsWidth(true);
            this.getFixedPixelsWidth(false);
            this.getFixedPixelsHeight(true);
            this.getFixedPixelsHeight(false);
        } else {
            this.rawImage = image;
            this.horizontalStretch = new ArrayList<NinePatchInterval>();
            this.verticalStretch = new ArrayList<NinePatchInterval>();
            this.margin = new Insets(0, 0, 0, 0);
        }
    }

    public boolean isOverwrite() {
        return true;
    }

    @NotNull
    public BufferedImage getRawImage() {
        return this.rawImage;
    }

    @Nullable
    public JComponent getComponent() {
        return this.component != null ? (JComponent)this.component.get() : null;
    }

    public void setComponent(@Nullable JComponent component) {
        this.component = component != null ? new WeakReference<JComponent>(component) : null;
    }

    @NotNull
    public List<NinePatchInterval> getHorizontalStretch() {
        return this.horizontalStretch;
    }

    public void setHorizontalStretch(@NotNull List<NinePatchInterval> horizontalStretch) {
        this.horizontalStretch = horizontalStretch;
        this.updateCachedWidthData();
    }

    public void addHorizontalStretch(@NotNull NinePatchInterval interval) {
        this.horizontalStretch.add(interval);
        this.updateCachedWidthData();
    }

    public void addHorizontalStretch(int start, int end, boolean pixel) {
        this.addHorizontalStretch(new NinePatchInterval(start, end, pixel));
    }

    @NotNull
    public List<NinePatchInterval> getVerticalStretch() {
        return this.verticalStretch;
    }

    public void setVerticalStretch(@NotNull List<NinePatchInterval> verticalStretch) {
        this.verticalStretch = verticalStretch;
        this.updateCachedHeightData();
    }

    public void addVerticalStretch(@NotNull NinePatchInterval interval) {
        this.verticalStretch.add(interval);
        this.updateCachedHeightData();
    }

    public void addVerticalStretch(int start, int end, boolean pixel) {
        this.addVerticalStretch(new NinePatchInterval(start, end, pixel));
    }

    @NotNull
    public Insets getMargin() {
        return (Insets)this.margin.clone();
    }

    @NotNull
    public Insets getStretchMargin() {
        NinePatchInterval top = this.verticalStretch.get(0);
        NinePatchInterval left = this.horizontalStretch.get(0);
        NinePatchInterval bottom = this.verticalStretch.get(this.verticalStretch.size() - 1);
        NinePatchInterval right = this.horizontalStretch.get(this.horizontalStretch.size() - 1);
        return new Insets(top.getLength(), left.getLength(), bottom.getLength(), right.getLength());
    }

    public void setMargin(@NotNull Insets margin) {
        this.margin = margin;
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int spacing) {
        this.setMargin(spacing, spacing, spacing, spacing);
    }

    public void paintIcon(@NotNull JComponent c, @NotNull Graphics g) {
        this.paintIcon((Graphics2D)g, 0, 0, this.getIconWidth(c), this.getIconHeight(c));
    }

    @Override
    public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
        this.paintIcon((Graphics2D)g, x, y, this.getFixedPixelsWidth(true), this.getFixedPixelsHeight(true));
    }

    public void paintIcon(@NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        this.paintIcon(g2d, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void paintIcon(@NotNull Graphics2D g2d, int x, int y, int width, int height) {
        int availableWidth = Math.max(width, this.getFixedPixelsWidth(true));
        int availableHeight = Math.max(height, this.getFixedPixelsHeight(true));
        int fixedPixelsX = this.getFixedPixelsWidth(false);
        int unfixedX = availableWidth - fixedPixelsX;
        int fixedPixelsY = this.getFixedPixelsHeight(false);
        int unfixedY = availableHeight - fixedPixelsY;
        int currentY = y;
        for (NinePatchInterval intervalY : this.verticalStretch) {
            int finalHeight;
            int intervalHeight = intervalY.getEnd() - intervalY.getStart() + 1;
            if (intervalY.isPixel()) {
                finalHeight = intervalHeight;
            } else {
                float percents = (float)intervalHeight / (float)(this.rawImage.getHeight() - fixedPixelsY);
                finalHeight = Math.round(percents * (float)unfixedY);
            }
            int currentX = x;
            for (NinePatchInterval intervalX : this.horizontalStretch) {
                int finalWidth;
                int intervalWidth = intervalX.getEnd() - intervalX.getStart() + 1;
                if (intervalX.isPixel()) {
                    finalWidth = intervalWidth;
                } else {
                    float percents = (float)intervalWidth / (float)(this.rawImage.getWidth() - fixedPixelsX);
                    finalWidth = Math.round(percents * (float)unfixedX);
                }
                g2d.drawImage(this.rawImage, currentX, currentY, currentX + finalWidth, currentY + finalHeight, intervalX.getStart(), intervalY.getStart(), intervalX.getStart() + intervalWidth, intervalY.getStart() + intervalHeight, null);
                currentX += finalWidth;
            }
            currentY += finalHeight;
        }
    }

    public int getFixedPixelsWidth(boolean addUnfixedSpaces) {
        int width;
        if (addUnfixedSpaces) {
            if (this.cachedWidth0 == null) {
                this.cachedWidth0 = this.calculateFixedPixelsWidth(true);
            }
            width = this.cachedWidth0;
        } else {
            if (this.cachedWidth1 == null) {
                this.cachedWidth1 = this.calculateFixedPixelsWidth(false);
            }
            width = this.cachedWidth1;
        }
        return width;
    }

    protected int calculateFixedPixelsWidth(boolean addUnfixedSpaces) {
        int fixedPixelsX = this.rawImage.getWidth();
        for (NinePatchInterval interval : this.horizontalStretch) {
            if (interval.isPixel()) continue;
            fixedPixelsX -= interval.getEnd() - interval.getStart() + 1;
            if (!addUnfixedSpaces) continue;
            ++fixedPixelsX;
        }
        return fixedPixelsX;
    }

    protected void updateCachedWidthData() {
        this.cachedWidth0 = null;
        this.cachedWidth1 = null;
        this.getFixedPixelsWidth(true);
        this.getFixedPixelsWidth(false);
    }

    public int getFixedPixelsHeight(boolean addUnfixedSpaces) {
        int height;
        if (addUnfixedSpaces) {
            if (this.cachedHeight0 == null) {
                this.cachedHeight0 = this.calculateFixedPixelsHeight(true);
            }
            height = this.cachedHeight0;
        } else {
            if (this.cachedHeight1 == null) {
                this.cachedHeight1 = this.calculateFixedPixelsHeight(false);
            }
            height = this.cachedHeight1;
        }
        return height;
    }

    protected int calculateFixedPixelsHeight(boolean addUnfixedSpaces) {
        int fixedPixelsY = this.rawImage.getHeight();
        for (NinePatchInterval interval : this.verticalStretch) {
            if (interval.isPixel()) continue;
            fixedPixelsY -= interval.getEnd() - interval.getStart() + 1;
            if (!addUnfixedSpaces) continue;
            ++fixedPixelsY;
        }
        return fixedPixelsY;
    }

    protected void updateCachedHeightData() {
        this.cachedHeight0 = null;
        this.cachedHeight1 = null;
        this.getFixedPixelsHeight(true);
        this.getFixedPixelsHeight(false);
    }

    @Override
    public int getIconWidth() {
        return this.getIconWidth(this.getComponent());
    }

    public int getIconWidth(@Nullable JComponent component) {
        return Math.max(component != null ? component.getWidth() : 0, this.getFixedPixelsWidth(true));
    }

    @Override
    public int getIconHeight() {
        return this.getIconHeight(this.getComponent());
    }

    public int getIconHeight(@Nullable JComponent component) {
        return Math.max(component != null ? component.getHeight() : 0, this.getFixedPixelsHeight(true));
    }

    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(this.getFixedPixelsWidth(true), this.getFixedPixelsHeight(true));
    }

    @NotNull
    public Dimension getRealImageSize() {
        return new Dimension(this.getRawImage().getWidth(), this.getRawImage().getHeight());
    }
}

