/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.Clone;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Rectangle;
import java.io.Serializable;

@XStreamAlias(value="NinePatchInterval")
public final class NinePatchInterval
implements Identifiable,
Cloneable,
Serializable {
    private final transient String id = TextUtils.generateId((String)"NPINT");
    @XStreamAsAttribute
    private boolean pixel;
    @XStreamAsAttribute
    private int start;
    @XStreamAsAttribute
    private int end;

    public NinePatchInterval() {
        this(0, 0, true);
    }

    public NinePatchInterval(int start) {
        this(start, start, true);
    }

    public NinePatchInterval(int start, boolean pixel) {
        this(start, start, pixel);
    }

    public NinePatchInterval(int start, int end) {
        this(start, end, true);
    }

    public NinePatchInterval(int start, int end, boolean pixel) {
        this.start = start;
        this.end = end;
        this.pixel = pixel;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public boolean isPixel() {
        return this.pixel;
    }

    public void setPixel(boolean pixel) {
        this.pixel = pixel;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public boolean intersects(NinePatchInterval npi) {
        return new Rectangle(this.getStart(), 0, this.getEnd() - this.getStart(), 1).intersects(new Rectangle(npi.getStart(), 0, npi.getEnd() - npi.getStart(), 1));
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    @NotNull
    public NinePatchInterval clone() {
        return (NinePatchInterval)Clone.deep().nonNullClone((Object)this);
    }

    public boolean equals(Object object) {
        boolean equals;
        if (object instanceof NinePatchInterval) {
            NinePatchInterval npi = (NinePatchInterval)object;
            equals = this.isPixel() == npi.isPixel() && this.getStart() == npi.getStart() && this.getEnd() == npi.getEnd();
        } else {
            equals = false;
        }
        return equals;
    }
}

