/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.UtilityException;
import java.io.Serializable;
import javax.swing.JComponent;

public final class ClientProperty<V extends Serializable>
implements Serializable {
    @NotNull
    private final String key;
    @Nullable
    private final V defaultValue;

    public ClientProperty(@NotNull String key, @Nullable V defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @NotNull
    public String key() {
        return this.key;
    }

    @Nullable
    public V defaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public V get(@NotNull JComponent component) {
        Object value = component.getClientProperty(this.key);
        if (value != null || this.defaultValue != null) {
            return (V)(value != null ? (Serializable)value : this.defaultValue);
        }
        throw new UtilityException("Value and default value are both null for client property: " + this.key);
    }

    @Nullable
    public V set(@NotNull JComponent component, @Nullable V value) {
        Object old = component.getClientProperty(this.key);
        if (value != null || this.defaultValue != null) {
            component.putClientProperty(this.key, value);
            return (V)(old != null ? (Serializable)old : this.defaultValue);
        }
        throw new UtilityException("Provided value and default value are both null for client property: " + this.key);
    }

    @Nullable
    public V reset(@NotNull JComponent component) {
        if (this.defaultValue != null) {
            return this.set(component, null);
        }
        throw new UtilityException("Value cannot be reset because default value is null for client property: " + this.key);
    }
}

