/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.menu.WebMenu;
import com.alee.managers.style.StyleId;
import com.alee.utils.swing.menu.AbstractMenuGenerator;
import javax.swing.Action;
import javax.swing.Icon;

public class MenuGenerator
extends AbstractMenuGenerator<WebMenu> {
    public MenuGenerator() {
        this(StyleId.auto);
    }

    public MenuGenerator(@Nullable Icon icon) {
        this(StyleId.auto, icon);
    }

    public MenuGenerator(@Nullable String text) {
        this(StyleId.auto, text);
    }

    public MenuGenerator(@Nullable String text, @Nullable Icon icon) {
        this(StyleId.auto, text, icon);
    }

    public MenuGenerator(@NotNull Action action) {
        this(StyleId.auto, action);
    }

    public MenuGenerator(@NotNull StyleId id) {
        this(id, null, null);
    }

    public MenuGenerator(@NotNull StyleId id, @Nullable Icon icon) {
        this(id, null, icon);
    }

    public MenuGenerator(@NotNull StyleId id, @Nullable String text) {
        this(id, text, null);
    }

    public MenuGenerator(@NotNull StyleId id, @Nullable String text, @Nullable Icon icon) {
        this(new WebMenu(id, text, icon));
    }

    public MenuGenerator(@NotNull StyleId id, @NotNull Action action) {
        this(new WebMenu(id, action));
    }

    public MenuGenerator(@NotNull WebMenu menu) {
        super(menu);
    }

    @Override
    public void setLanguagePrefix(@Nullable String prefix) {
        super.setLanguagePrefix(prefix);
        WebMenu menu = (WebMenu)this.getMenu();
        String text = menu.getLanguage();
        String languageKey = this.getLanguageKey(text);
        if (languageKey != null) {
            menu.setLanguage(languageKey, new Object[0]);
        } else {
            menu.removeLanguage();
            menu.setText(text);
        }
    }
}

