/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.accordion;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.api.jdk.Objects;
import com.alee.extended.WebContainer;
import com.alee.extended.accordion.AccordionLayout;
import com.alee.extended.accordion.AccordionListener;
import com.alee.extended.accordion.AccordionModel;
import com.alee.extended.accordion.AccordionPane;
import com.alee.extended.accordion.AccordionState;
import com.alee.extended.accordion.WAccordionUI;
import com.alee.extended.accordion.WebAccordionModel;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class WebAccordion
extends WebContainer<WebAccordion, WAccordionUI> {
    public static final String MODEL_PROPERTY = "model";
    public static final String HEADER_POSITION_PROPERTY = "headerPosition";
    public static final String MINIMUM_EXPANDED_PANE_COUNT_PROPERTY = "minimumExpandedPaneCount";
    public static final String MAXIMUM_EXPANDED_PANE_COUNT_PROPERTY = "maximumExpandedPaneCount";
    public static final String MINIMUM_PANE_CONTENT_SIZE_PROPERTY = "minimumPaneContentSize";
    public static final String ANIMATED_PROPERTY = "animated";
    public static final String PANES_PROPERTY = "panes";
    @Nullable
    protected BoxOrientation headerPosition;
    @Nullable
    protected Integer minimumExpandedPaneCount;
    @Nullable
    protected Integer maximumExpandedPaneCount;
    @Nullable
    protected Integer minimumPaneContentSize;
    @Nullable
    protected Boolean animated;
    @Nullable
    protected AccordionModel model;

    public WebAccordion() {
        this(StyleId.auto, BoxOrientation.top, 1, 1);
    }

    public WebAccordion(int minimumExpandedPaneCount, int maximumExpandedPaneCount) {
        this(StyleId.auto, BoxOrientation.top, minimumExpandedPaneCount, maximumExpandedPaneCount);
    }

    public WebAccordion(@NotNull BoxOrientation headerPosition) {
        this(StyleId.auto, headerPosition, 1, 1);
    }

    public WebAccordion(@NotNull BoxOrientation headerPosition, int minimumExpandedPaneCount, int maximumExpandedPaneCount) {
        this(StyleId.auto, headerPosition, minimumExpandedPaneCount, maximumExpandedPaneCount);
    }

    public WebAccordion(@NotNull StyleId id) {
        this(id, BoxOrientation.top, 1, 1);
    }

    public WebAccordion(@NotNull StyleId id, int minimumExpandedPaneCount, int maximumExpandedPaneCount) {
        this(id, BoxOrientation.top, minimumExpandedPaneCount, maximumExpandedPaneCount);
    }

    public WebAccordion(@NotNull StyleId id, @NotNull BoxOrientation headerPosition) {
        this(id, headerPosition, 1, 1);
    }

    public WebAccordion(@NotNull StyleId id, @NotNull BoxOrientation headerPosition, int minimumExpandedPaneCount, int maximumExpandedPaneCount) {
        this.setHeaderPosition(headerPosition);
        this.setMinimumExpandedPaneCount(minimumExpandedPaneCount);
        this.setMaximumExpandedPaneCount(maximumExpandedPaneCount);
        this.setMinimumPaneContentSize(100);
        this.setModel(this.createModel());
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.accordion;
    }

    @Nullable
    public AccordionModel getModel() {
        return this.model;
    }

    @NotNull
    public WebAccordion setModel(@NotNull AccordionModel model) {
        if (this.model != model) {
            AccordionModel old = this.model;
            if (this.model != null) {
                this.model.uninstall(this);
            }
            this.model = model;
            model.install(this);
            this.firePropertyChange(ANIMATED_PROPERTY, old, model);
        }
        return this;
    }

    @NotNull
    protected AccordionModel createModel() {
        return new WebAccordionModel();
    }

    @Override
    @Nullable
    public AccordionLayout getLayout() {
        return (AccordionLayout)super.getLayout();
    }

    @Override
    public void setLayout(@NotNull LayoutManager layout) {
        if (layout instanceof AccordionLayout && this.getLayout() != layout) {
            AccordionLayout old = this.getLayout();
            if (old != null) {
                old.uninstall(this);
            }
        } else {
            throw new IllegalArgumentException("Only AccordionModel instances are supported");
        }
        AccordionLayout newLayout = (AccordionLayout)layout;
        super.setLayout(newLayout);
        newLayout.install(this);
    }

    @NotNull
    public AccordionState getAccordionState() {
        return this.getModel() != null ? this.getModel().getAccordionState() : new AccordionState();
    }

    @NotNull
    public WebAccordion setAccordionState(@NotNull AccordionState state) {
        if (this.getModel() != null) {
            this.getModel().setAccordionState(state);
        }
        return this;
    }

    @NotNull
    public BoxOrientation getHeaderPosition() {
        return this.headerPosition != null ? this.headerPosition : BoxOrientation.top;
    }

    @NotNull
    public WebAccordion setHeaderPosition(@NotNull BoxOrientation position) {
        BoxOrientation headerPosition = this.getHeaderPosition();
        if (headerPosition != position) {
            this.headerPosition = position;
            this.firePropertyChange(HEADER_POSITION_PROPERTY, headerPosition, position);
        }
        return this;
    }

    public int getMinimumExpandedPaneCount() {
        return this.minimumExpandedPaneCount != null ? this.minimumExpandedPaneCount : 1;
    }

    @NotNull
    public WebAccordion setMinimumExpandedPaneCount(int minimum) {
        if (minimum >= 0) {
            int minimumExpanded;
            if (minimum > this.getMaximumExpandedPaneCount()) {
                this.setMaximumExpandedPaneCount(minimum);
            }
            if (Objects.notEquals((Object)(minimumExpanded = this.getMinimumExpandedPaneCount()), (Object)minimum)) {
                this.minimumExpandedPaneCount = minimum;
                this.firePropertyChange(MINIMUM_EXPANDED_PANE_COUNT_PROPERTY, minimumExpanded, minimum);
            }
        } else {
            throw new IllegalArgumentException("Minimum expanded AccordionPane amount cannot be less than zero");
        }
        return this;
    }

    public int getMaximumExpandedPaneCount() {
        return this.maximumExpandedPaneCount != null ? this.maximumExpandedPaneCount : 1;
    }

    @NotNull
    public WebAccordion setMaximumExpandedPaneCount(int maximum) {
        if (maximum >= 1) {
            int maximumExpanded;
            if (maximum < this.getMinimumExpandedPaneCount()) {
                this.setMinimumExpandedPaneCount(maximum);
            }
            if (Objects.notEquals((Object)(maximumExpanded = this.getMaximumExpandedPaneCount()), (Object)maximum)) {
                this.maximumExpandedPaneCount = maximum;
                this.firePropertyChange(MAXIMUM_EXPANDED_PANE_COUNT_PROPERTY, maximumExpanded, maximum);
            }
        } else {
            throw new IllegalArgumentException("Maximum expanded AccordionPane amount cannot be less than one");
        }
        return this;
    }

    @NotNull
    public WebAccordion setExpandedPaneLimit(int minimum, int maximum) {
        this.setMinimumExpandedPaneCount(minimum);
        this.setMaximumExpandedPaneCount(maximum);
        return this;
    }

    public int getMinimumPaneContentSize() {
        return this.minimumPaneContentSize != null ? this.minimumPaneContentSize : 0;
    }

    @NotNull
    public WebAccordion setMinimumPaneContentSize(@Nullable Integer minimum) {
        Integer minimumPaneContentSize = this.minimumPaneContentSize;
        if (Objects.notEquals((Object)minimumPaneContentSize, (Object)minimum)) {
            this.minimumPaneContentSize = minimum;
            this.firePropertyChange(MINIMUM_PANE_CONTENT_SIZE_PROPERTY, minimumPaneContentSize, minimum);
        }
        return this;
    }

    public boolean isAnimated() {
        return this.animated == null || this.animated != false;
    }

    public WebAccordion setAnimated(boolean animated) {
        Boolean wasAnimated = this.animated;
        if (Objects.notEquals((Object)animated, (Object)wasAnimated)) {
            this.animated = animated;
            this.firePropertyChange(ANIMATED_PROPERTY, wasAnimated, (Object)animated);
        }
        return this;
    }

    public int getPaneCount() {
        return this.getComponentCount();
    }

    public boolean containsPane(@NotNull String id) {
        boolean contains = false;
        for (int i = 0; i < this.getPaneCount(); ++i) {
            AccordionPane pane = this.getPane(i);
            if (!pane.getId().equals(id)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    @NotNull
    public List<AccordionPane> getPanes() {
        ArrayList<AccordionPane> panes = new ArrayList<AccordionPane>(this.getPaneCount());
        for (int i = 0; i < this.getPaneCount(); ++i) {
            panes.add(this.getPane(i));
        }
        return panes;
    }

    @NotNull
    public AccordionPane getPane(@NotNull String id) {
        for (int i = 0; i < this.getPaneCount(); ++i) {
            AccordionPane pane = this.getPane(i);
            if (!pane.getId().equals(id)) continue;
            return pane;
        }
        throw new RuntimeException("Cannot find AccordionPane with identifier: " + id);
    }

    @Nullable
    public AccordionPane findPane(@NotNull String id) {
        AccordionPane result = null;
        for (int i = 0; i < this.getPaneCount(); ++i) {
            AccordionPane pane = this.getPane(i);
            if (!pane.getId().equals(id)) continue;
            result = pane;
        }
        return result;
    }

    public int getPaneIndex(@NotNull String id) {
        for (int i = 0; i < this.getPaneCount(); ++i) {
            AccordionPane pane = this.getPane(i);
            if (!pane.getId().equals(id)) continue;
            return i;
        }
        throw new RuntimeException("Cannot find AccordionPane with identifier: " + id);
    }

    public int getPaneIndex(@Nullable AccordionPane pane) {
        return this.getComponentZOrder(pane);
    }

    @NotNull
    public AccordionPane getPane(int index) {
        return (AccordionPane)this.getComponent(index);
    }

    @NotNull
    public AccordionPane addPane(@Nullable String title, @NotNull Component content) {
        return this.addPane(this.createAccordionPaneId(), this.getPaneCount(), null, title, content);
    }

    @NotNull
    public AccordionPane addPane(int index, @Nullable String title, @NotNull Component content) {
        return this.addPane(this.createAccordionPaneId(), index, null, title, content);
    }

    @NotNull
    public AccordionPane addPane(@Nullable Icon icon, @Nullable String title, @NotNull Component content) {
        return this.addPane(this.createAccordionPaneId(), this.getPaneCount(), icon, title, content);
    }

    @NotNull
    public AccordionPane addPane(int index, @Nullable Icon icon, @Nullable String title, @NotNull Component content) {
        return this.addPane(this.createAccordionPaneId(), index, icon, title, content);
    }

    @NotNull
    public AccordionPane addPane(@NotNull String id, @Nullable String title, @NotNull Component content) {
        return this.addPane(id, this.getPaneCount(), null, title, content);
    }

    @NotNull
    public AccordionPane addPane(@NotNull String id, int index, @Nullable String title, @NotNull Component content) {
        return this.addPane(id, index, null, title, content);
    }

    @NotNull
    public AccordionPane addPane(@NotNull String id, @Nullable Icon icon, @Nullable String title, @NotNull Component content) {
        return this.addPane(id, this.getPaneCount(), icon, title, content);
    }

    @NotNull
    public AccordionPane addPane(@NotNull String id, int index, @Nullable Icon icon, @Nullable String title, @NotNull Component content) {
        AccordionPane accordionPane = this.createAccordionPane(id, icon, title, content);
        return this.addPane(index, accordionPane);
    }

    @NotNull
    protected String createAccordionPaneId() {
        return TextUtils.generateId((String)"AP");
    }

    @NotNull
    protected AccordionPane createAccordionPane(@NotNull String id, @Nullable Icon icon, @Nullable String title, @NotNull Component content) {
        return new AccordionPane(this, id, icon, title, content);
    }

    @NotNull
    public AccordionPane addPane(@NotNull AccordionPane pane) {
        return this.addPane(this.getPaneCount(), pane);
    }

    @NotNull
    public AccordionPane addPane(int index, @NotNull AccordionPane pane) {
        this.add((Component)pane, index);
        SwingUtils.update(this);
        return pane;
    }

    @Override
    protected void addImpl(@NotNull Component comp, @Nullable Object constraints, int index) {
        AccordionPane pane;
        if (comp instanceof AccordionPane) {
            pane = (AccordionPane)comp;
            if (this.findPane(pane.getId()) != null) {
                throw new RuntimeException("AccordionPane with identifier already exists: " + pane.getId());
            }
        } else {
            throw new RuntimeException("Only AccordionPane instances can be added to accordion: " + comp);
        }
        List<AccordionPane> oldPanes = this.getPanes();
        super.addImpl(pane, constraints, index);
        this.firePropertyChange(PANES_PROPERTY, oldPanes, this.getPanes());
    }

    @NotNull
    public AccordionPane removePane(int index) {
        AccordionPane removed = this.getPane(index);
        this.remove(index);
        SwingUtils.update(this);
        return removed;
    }

    @Nullable
    public AccordionPane removePane(@NotNull String id) {
        AccordionPane pane = this.findPane(id);
        return pane != null ? this.removePane(pane) : null;
    }

    @Nullable
    public AccordionPane removePane(@NotNull AccordionPane pane) {
        AccordionPane removed;
        int zOrder = this.getComponentZOrder(pane);
        if (zOrder != -1) {
            this.remove(zOrder);
            SwingUtils.update(this);
            removed = pane;
        } else {
            removed = null;
        }
        return removed;
    }

    @NotNull
    public List<AccordionPane> removeAllPanes() {
        List<AccordionPane> removed = this.getPanes();
        this.removeAll();
        SwingUtils.update(this);
        return removed;
    }

    @Override
    public void remove(int index) {
        List<AccordionPane> oldPanes = this.getPanes();
        super.remove(index);
        this.firePropertyChange(PANES_PROPERTY, oldPanes, this.getPanes());
    }

    @Nullable
    public AccordionPane getFirstExpandedPane() {
        return this.getModel() != null ? this.getModel().getFirstExpandedPane() : null;
    }

    public int getFirstExpandedPaneIndex() {
        return this.getModel() != null ? this.getPaneIndex(this.getModel().getFirstExpandedPane()) : -1;
    }

    @Nullable
    public AccordionPane getLastExpandedPane() {
        return this.getModel() != null ? this.getModel().getLastExpandedPane() : null;
    }

    public int getLastExpandedPaneIndex() {
        return this.getModel() != null ? this.getPaneIndex(this.getModel().getLastExpandedPane()) : -1;
    }

    @NotNull
    public List<AccordionPane> getExpandedPanes() {
        return this.getModel() != null ? this.getModel().getExpandedPanes() : new ArrayList();
    }

    @NotNull
    public List<String> getExpandedPaneIds() {
        return this.getModel() != null ? this.getModel().getExpandedPaneIds() : new ArrayList();
    }

    public void setExpandedPaneIds(@NotNull List<String> ids) {
        if (this.getModel() != null) {
            this.getModel().setExpandedPaneIds(ids);
        }
    }

    @NotNull
    public int[] getExpandedPaneIndices() {
        return this.getModel() != null ? this.getModel().getExpandedPaneIndices() : new int[]{};
    }

    public void setExpandedPaneIndices(@NotNull int[] indices) {
        if (this.getModel() != null) {
            this.getModel().setExpandedPaneIndices(indices);
        }
    }

    public boolean isPaneExpanded(@NotNull String id) {
        return this.getModel() != null && this.getModel().isPaneExpanded(id);
    }

    public boolean setPaneExpanded(@NotNull String id, boolean expanded) {
        return expanded ? this.expandPane(id) : this.collapsePane(id);
    }

    public boolean expandPane(@NotNull String id) {
        return this.getModel() != null && this.getModel().expandPane(id);
    }

    public void expandPanes(String ... ids) {
        if (this.getModel() != null) {
            for (String id : ids) {
                this.getModel().expandPane(id);
            }
        }
    }

    public void expandPanes(@NotNull List<String> ids) {
        if (this.getModel() != null) {
            for (String id : ids) {
                this.getModel().expandPane(id);
            }
        }
    }

    public void expandPanes(@NotNull int[] indices) {
        if (this.getModel() != null) {
            for (int index : indices) {
                AccordionPane pane = this.getPane(index);
                this.getModel().expandPane(pane.getId());
            }
        }
    }

    @NotNull
    public List<AccordionPane> getCollapsedPanes() {
        return this.getModel() != null ? this.getModel().getCollapsedPanes() : new ArrayList();
    }

    @NotNull
    public List<String> getCollapsedPaneIds() {
        return this.getModel() != null ? this.getModel().getCollapsedPaneIds() : new ArrayList();
    }

    @NotNull
    public int[] getCollapsedPaneIndices() {
        return this.getModel() != null ? this.getModel().getCollapsedPaneIndices() : new int[]{};
    }

    public boolean isPaneCollapsed(@NotNull String id) {
        return this.getModel() != null && this.getModel().isPaneCollapsed(id);
    }

    public boolean setPaneCollapsed(@NotNull String id, boolean collapsed) {
        return collapsed ? this.collapsePane(id) : this.expandPane(id);
    }

    public boolean collapsePane(@NotNull String id) {
        return this.getModel() != null && this.getModel().collapsePane(id);
    }

    public void collapsePanes(String ... ids) {
        if (this.getModel() != null) {
            for (String id : ids) {
                this.getModel().collapsePane(id);
            }
        }
    }

    public void collapsePanes(@NotNull List<String> ids) {
        if (this.getModel() != null) {
            for (String id : ids) {
                this.getModel().collapsePane(id);
            }
        }
    }

    public void collapsePanes(@NotNull int[] indices) {
        if (this.getModel() != null) {
            for (int index : indices) {
                AccordionPane pane = this.getPane(index);
                this.getModel().collapsePane(pane.getId());
            }
        }
    }

    public boolean isPaneInTransition(@NotNull String id) {
        return this.getLayout() != null && this.getLayout().isPaneInTransition(id);
    }

    public void addAccordionListener(@NotNull AccordionListener listener) {
        this.listenerList.add(AccordionListener.class, listener);
    }

    public void removeAccordionListener(@NotNull AccordionListener listener) {
        this.listenerList.remove(AccordionListener.class, listener);
    }

    public void fireExpanding(@NotNull AccordionPane pane) {
        for (AccordionListener listener : (AccordionListener[])this.listenerList.getListeners(AccordionListener.class)) {
            listener.expanding(this, pane);
        }
    }

    public void fireExpanded(@NotNull AccordionPane pane) {
        for (AccordionListener listener : (AccordionListener[])this.listenerList.getListeners(AccordionListener.class)) {
            listener.expanded(this, pane);
        }
    }

    public void fireCollapsing(@NotNull AccordionPane pane) {
        for (AccordionListener listener : (AccordionListener[])this.listenerList.getListeners(AccordionListener.class)) {
            listener.collapsing(this, pane);
        }
    }

    public void fireCollapsed(@NotNull AccordionPane pane) {
        for (AccordionListener listener : (AccordionListener[])this.listenerList.getListeners(AccordionListener.class)) {
            listener.collapsed(this, pane);
        }
    }

    @Override
    @Nullable
    public WAccordionUI getUI() {
        return (WAccordionUI)this.ui;
    }

    public void setUI(@Nullable WAccordionUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

