/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.Behavior;
import com.alee.managers.style.BoundsType;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class ComponentMoveBehavior
extends MouseAdapter
implements Behavior {
    protected final Component gripper;
    protected final Component target;
    protected boolean enabled;
    protected boolean dragging;
    protected Component dragged;
    protected Point initialPoint;
    protected Rectangle initialBounds;

    public ComponentMoveBehavior(Component gripper) {
        this(gripper, null);
    }

    public ComponentMoveBehavior(Component gripper, Component target) {
        this.gripper = gripper;
        this.target = target;
        this.enabled = true;
        this.dragging = false;
        this.dragged = null;
        this.initialPoint = null;
        this.initialBounds = null;
    }

    public void install() {
        this.gripper.addMouseListener(this);
        this.gripper.addMouseMotionListener(this);
    }

    public void uninstall() {
        this.gripper.removeMouseMotionListener(this);
        this.gripper.removeMouseListener(this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && e.getSource() == this.gripper && this.isEnabled() && this.gripper.isEnabled()) {
            this.dragged = this.getDraggedComponent(e);
            if (this.dragged != null) {
                Rectangle dragStartBounds = this.getDragStartBounds(e);
                if (dragStartBounds != null && dragStartBounds.contains(e.getPoint())) {
                    this.dragging = true;
                    this.initialPoint = CoreSwingUtils.getMouseLocation();
                    this.initialBounds = this.dragged.getBounds();
                    this.componentMoveStarted(this.initialPoint, this.initialBounds.getLocation());
                    e.consume();
                } else {
                    this.dragged = null;
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && this.dragging) {
            Point mouse = CoreSwingUtils.getMouseLocation();
            int x = this.initialBounds.x + mouse.x - this.initialPoint.x;
            int y = this.initialBounds.y + mouse.y - this.initialPoint.y;
            Point location = new Point(x, y);
            this.dragged.setLocation(location);
            this.componentMoved(mouse, location);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && this.dragging) {
            Point mouse = CoreSwingUtils.getMouseLocation();
            Point location = this.dragged.getLocation();
            this.dragging = false;
            this.dragged = null;
            this.initialPoint = null;
            this.initialBounds = null;
            this.componentMoveEnded(mouse, location);
            e.consume();
        }
    }

    protected void componentMoveStarted(Point mouse, Point location) {
    }

    protected void componentMoved(Point mouse, Point location) {
    }

    protected void componentMoveEnded(Point mouse, Point location) {
    }

    @Nullable
    protected Component getDraggedComponent(@NotNull MouseEvent e) {
        return this.target != null ? this.target : CoreSwingUtils.getWindowAncestor((Component)this.gripper);
    }

    @Nullable
    protected Rectangle getDragStartBounds(@NotNull MouseEvent e) {
        return BoundsType.margin.bounds(this.gripper);
    }
}

