/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.extended.behavior.AbstractComponentBehavior;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;

public abstract class VisibilityBehavior<C extends Component>
extends AbstractComponentBehavior<C>
implements HierarchyListener {
    protected final boolean initTriggers;
    protected boolean visible;

    public VisibilityBehavior(@NotNull C component) {
        this(component, false);
    }

    public VisibilityBehavior(@NotNull C component, boolean initTriggers) {
        super(component);
        this.initTriggers = initTriggers;
        this.visible = false;
    }

    public void install() {
        Object component = this.getComponent();
        this.visible = ((Component)component).isShowing();
        ((Component)component).addHierarchyListener(this);
        if (this.initTriggers && this.visible) {
            this.displayed(component);
        }
    }

    public void uninstall() {
        Object component = this.getComponent();
        if (this.initTriggers && this.visible) {
            this.hidden(component);
        }
        ((Component)component).removeHierarchyListener(this);
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void hierarchyChanged(@NotNull HierarchyEvent e) {
        if (e.getID() == 1400) {
            this.checkVisibility();
        }
    }

    protected void checkVisibility() {
        boolean nowVisible = ((Component)this.getComponent()).isShowing();
        if (this.visible != nowVisible) {
            if (nowVisible) {
                this.visible = true;
                this.displayed(this.getComponent());
            } else {
                this.visible = false;
                this.hidden(this.getComponent());
            }
        }
    }

    protected void displayed(@NotNull C component) {
    }

    protected void hidden(@NotNull C component) {
    }
}

