/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Supplier;
import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.graphics.shapes.RelativeGeneralPath;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.painter.decoration.shape.AbstractShape;
import com.alee.painter.decoration.shape.IPartialShape;
import com.alee.painter.decoration.shape.Round;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.painter.decoration.shape.Sides;
import com.alee.utils.ShapeUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

@XStreamAlias(value="BreadcrumbElementShape")
public class BreadcrumbElementShape<C extends JComponent, D extends WebDecoration<C, D>, I extends BreadcrumbElementShape<C, D, I>>
extends AbstractShape<C, D, I>
implements IPartialShape<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Sides sides;
    @XStreamAsAttribute
    @Nullable
    protected Sides corners;
    @XStreamAsAttribute
    @Nullable
    protected Integer cornerWidth;
    @XStreamAsAttribute
    @Nullable
    protected Round round;

    @NotNull
    public Sides sides() {
        if (this.sides == null) {
            throw new DecorationException("Element sides must be specified");
        }
        return this.sides;
    }

    @NotNull
    public Sides corners() {
        if (this.corners == null) {
            throw new DecorationException("Element corners must be specified");
        }
        return this.corners;
    }

    public int cornerWidth() {
        if (this.cornerWidth == null) {
            throw new DecorationException("Corner width must be specified");
        }
        return this.cornerWidth;
    }

    @NotNull
    public Round round() {
        return this.round != null ? this.round : new Round();
    }

    @Override
    public boolean isPaintTop(@NotNull C c, @NotNull D d) {
        return this.sides().top;
    }

    @Override
    public boolean isPaintLeft(@NotNull C c, @NotNull D d) {
        return this.sides().left;
    }

    @Override
    public boolean isPaintBottom(@NotNull C c, @NotNull D d) {
        return this.sides().bottom;
    }

    @Override
    public boolean isPaintRight(@NotNull C c, @NotNull D d) {
        return this.sides().right;
    }

    @Override
    public boolean isPaintTopLine(@NotNull C c, @NotNull D d) {
        return false;
    }

    @Override
    public boolean isPaintLeftLine(@NotNull C c, @NotNull D d) {
        return false;
    }

    @Override
    public boolean isPaintBottomLine(@NotNull C c, @NotNull D d) {
        return false;
    }

    @Override
    public boolean isPaintRightLine(@NotNull C c, @NotNull D d) {
        return false;
    }

    @Override
    public boolean isVisible(@NotNull ShapeType type, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        boolean visible;
        Container parent = ((Component)c).getParent();
        if (parent != null && parent instanceof WebBreadcrumb) {
            switch (type) {
                case border: 
                case outerShadow: {
                    visible = this.sides().isAny();
                    break;
                }
                default: {
                    visible = true;
                    break;
                }
            }
        } else {
            visible = false;
        }
        return visible;
    }

    @Override
    @NotNull
    public Shape getShape(final @NotNull ShapeType type, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        WebBreadcrumb breadcrumb = (WebBreadcrumb)((Component)c).getParent();
        int sw = ((WebDecoration)d).getShadowWidth(ShadowType.outer);
        final Sides sides = this.sides();
        final Sides corners = this.corners();
        final Round round = this.round();
        final int cornerWidth = this.cornerWidth();
        int overlap = breadcrumb.getLayout().overlap();
        final boolean ltr = breadcrumb.getComponentOrientation().isLeftToRight();
        int bgShear = type.isBorder() ? -1 : 0;
        final Rectangle b = new Rectangle(bounds.x + ((ltr ? sides.left : sides.right) ? sw : 0), bounds.y + (sides.top ? sw : 0), bounds.width - (sides.left ? sw : 0) - (sides.right ? sw : 0) + bgShear, bounds.height - (sides.top ? sw : 0) - (sides.bottom ? sw : 0) + bgShear);
        return ShapeUtils.getShape(breadcrumb, "BreadcrumbElementShape." + (Object)((Object)type), new Supplier<Shape>(){

            public Shape get() {
                int yCenter = b.y + b.height / 2;
                RelativeGeneralPath shape = new RelativeGeneralPath(b, ltr);
                if (sides.right || !type.isBorder()) {
                    if (corners.right) {
                        shape.moveTo((float)(b.width - cornerWidth), 0.0f);
                        shape.lineTo((float)b.width, (float)yCenter);
                        shape.lineTo((float)(b.width - cornerWidth), (float)b.height);
                    } else {
                        if (round.topRight > 0) {
                            shape.moveTo((float)(b.width - round.topRight), 0.0f);
                            shape.quadTo((float)b.width, 0.0f, (float)b.width, (float)round.topRight);
                        } else {
                            shape.moveTo((float)b.width, 0.0f);
                        }
                        if (round.bottomRight > 0) {
                            shape.lineTo((float)b.width, (float)(b.height - round.bottomRight));
                            shape.quadTo((float)b.width, (float)b.height, (float)(b.width - round.bottomRight), (float)b.height);
                        } else {
                            shape.lineTo((float)b.width, (float)b.height);
                        }
                    }
                } else if (corners.right) {
                    shape.moveTo((float)(b.width - cornerWidth), (float)b.height);
                } else {
                    shape.moveTo((float)b.width, (float)b.height);
                }
                if (sides.bottom || !type.isBorder()) {
                    shape.lineTo(0.0f, (float)b.height);
                } else if (corners.left) {
                    shape.moveTo(0.0f, (float)b.height);
                } else {
                    shape.moveTo((float)round.bottomLeft, (float)b.height);
                }
                if (sides.left || !type.isBorder()) {
                    if (corners.left) {
                        shape.lineTo((float)cornerWidth, (float)yCenter);
                        shape.lineTo(0.0f, 0.0f);
                    } else {
                        if (round.bottomLeft > 0) {
                            shape.quadTo(0.0f, (float)b.height, 0.0f, (float)(b.height - round.bottomLeft));
                        } else {
                            shape.lineTo(0.0f, (float)b.height);
                        }
                        if (round.topLeft > 0) {
                            shape.lineTo(0.0f, (float)round.topLeft);
                            shape.quadTo(0.0f, 0.0f, (float)round.topLeft, 0.0f);
                        } else {
                            shape.lineTo(0.0f, 0.0f);
                        }
                    }
                } else {
                    shape.moveTo(0.0f, 0.0f);
                }
                if (sides.top || !type.isBorder()) {
                    shape.closePath();
                }
                return shape;
            }
        }, bounds, sw, sides, corners, round, cornerWidth, overlap, ltr);
    }

    @Override
    @NotNull
    public Object[] getShapeSettings(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        WebBreadcrumb breadcrumb = (WebBreadcrumb)((Component)c).getParent();
        Sides sides = this.sides();
        Sides corners = this.corners();
        Round round = this.round();
        int cornerWidth = this.cornerWidth();
        int overlap = breadcrumb.getLayout().overlap();
        boolean ltr = breadcrumb.getComponentOrientation().isLeftToRight();
        return new Object[]{sides, corners, round, cornerWidth, overlap, ltr};
    }
}

