/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb.element;

import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.extended.breadcrumb.element.BreadcrumbElementData;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;

public final class BreadcrumbElementUtils {
    public static void addBreadcrumbElementStates(JComponent component, List<String> states) {
        Container parent = component.getParent();
        if (parent instanceof WebBreadcrumb) {
            WebBreadcrumb breadcrumb = (WebBreadcrumb)parent;
            boolean first = breadcrumb.isFirst(component);
            boolean last = breadcrumb.isLast(component);
            if (first && !last) {
                states.add("first");
            } else if (!first && !last) {
                states.add("middle");
            } else if (!first) {
                states.add("last");
            } else {
                states.add("single");
            }
            BreadcrumbElementData.ProgressType progressType = breadcrumb.getProgressType(component);
            if (progressType == BreadcrumbElementData.ProgressType.progress) {
                boolean max;
                states.add("progress");
                double value = breadcrumb.getProgress(component);
                boolean min = value == 0.0;
                boolean bl = max = value == 1.0;
                if (min) {
                    states.add("minimum");
                }
                if (max) {
                    states.add("maximum");
                }
                if (!min && !max) {
                    states.add("intermediate");
                }
            } else if (progressType == BreadcrumbElementData.ProgressType.indeterminate) {
                states.add("indeterminate");
            }
        }
    }
}

