/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.button.ISplitButtonPainter;
import com.alee.extended.button.WSplitButtonUI;
import com.alee.extended.button.WebSplitButton;
import com.alee.laf.button.AbstractButtonPainter;
import com.alee.managers.icon.Icons;
import com.alee.painter.decoration.IDecoration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class SplitButtonPainter<C extends WebSplitButton, U extends WSplitButtonUI<C>, D extends IDecoration<C, D>>
extends AbstractButtonPainter<C, U, D>
implements ISplitButtonPainter<C, U> {
    protected Color splitLineColor;
    protected Color splitLineDisabledColor;
    protected int menuIconGap;
    protected int contentGap;
    protected transient MouseAdapter menuButtonTracker;
    protected transient PropertyChangeListener popupMenuPropertyChangeListener;
    protected transient boolean onMenu;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installMenuButtonListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallMenuButtonListeners();
        super.uninstallPropertiesAndListeners();
    }

    protected void installMenuButtonListeners() {
        this.onMenu = false;
        this.menuButtonTracker = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean wasOnMenu = SplitButtonPainter.this.onMenu;
                SplitButtonPainter.this.onMenu = SplitButtonPainter.this.getMenuButtonHitbox((WebSplitButton)SplitButtonPainter.this.component).contains(e.getPoint());
                if (wasOnMenu != SplitButtonPainter.this.onMenu) {
                    SplitButtonPainter.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                boolean wasOnMenu = SplitButtonPainter.this.onMenu;
                SplitButtonPainter.this.onMenu = false;
                if (wasOnMenu != SplitButtonPainter.this.onMenu) {
                    SplitButtonPainter.this.repaint();
                }
            }
        };
        ((WebSplitButton)this.component).addMouseListener(this.menuButtonTracker);
        ((WebSplitButton)this.component).addMouseMotionListener(this.menuButtonTracker);
        this.popupMenuPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (Objects.equals((Object)event.getPropertyName(), (Object)"visible")) {
                    SplitButtonPainter.this.updateDecorationState();
                }
            }
        };
        this.installPopupMenuPropertyChangeListener(((WebSplitButton)this.component).getPopupMenu());
    }

    protected void uninstallMenuButtonListeners() {
        this.uninstallPopupMenuPropertyChangeListener(((WebSplitButton)this.component).getPopupMenu());
        this.popupMenuPropertyChangeListener = null;
        ((WebSplitButton)this.component).removeMouseMotionListener(this.menuButtonTracker);
        ((WebSplitButton)this.component).removeMouseListener(this.menuButtonTracker);
        this.menuButtonTracker = null;
        this.onMenu = false;
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"menuIcon")) {
            this.updateBorder();
        }
        if (Objects.equals((Object)property, (Object)"popupMenu")) {
            this.uninstallPopupMenuPropertyChangeListener((JPopupMenu)oldValue);
            this.installPopupMenuPropertyChangeListener((JPopupMenu)newValue);
        }
    }

    protected void installPopupMenuPropertyChangeListener(JPopupMenu popupMenu) {
        if (popupMenu != null) {
            popupMenu.addPropertyChangeListener(this.popupMenuPropertyChangeListener);
        }
    }

    protected void uninstallPopupMenuPropertyChangeListener(JPopupMenu popupMenu) {
        if (popupMenu != null) {
            popupMenu.removePropertyChangeListener(this.popupMenuPropertyChangeListener);
        }
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        states.add(((WebSplitButton)this.component).isPopupMenuVisible() ? "popup-visible" : "popup-hidden");
        return states;
    }

    public int getMenuIconGap() {
        return this.menuIconGap;
    }

    public void setMenuIconGap(int menuIconGap) {
        this.menuIconGap = menuIconGap;
    }

    public int getContentGap() {
        return this.contentGap;
    }

    public void setContentGap(int contentGap) {
        this.contentGap = contentGap;
    }

    @Override
    public boolean isOnMenu() {
        return this.onMenu;
    }

    @Override
    @NotNull
    protected Insets getBorder() {
        Insets border = super.getBorder();
        Icon menuIcon = this.getMenuIcon();
        int extra = this.contentGap + 1 + this.menuIconGap + menuIcon.getIconWidth() + this.menuIconGap;
        Insets result = border != null ? new Insets(border.top, border.left, border.bottom, border.right + extra) : new Insets(0, 0, 0, extra);
        return result;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        this.paintMenuButton(g2d, bounds, c);
    }

    protected void paintMenuButton(Graphics2D g2d, Rectangle bounds, C c) {
        Icon menuIcon = this.getMenuIcon();
        Rectangle br = this.getMenuButtonBounds(bounds, c);
        int ix = br.x + br.width / 2 - menuIcon.getIconWidth() / 2;
        int iy = br.y + br.height / 2 - menuIcon.getIconHeight() / 2;
        menuIcon.paintIcon(this.component, g2d, ix, iy);
        Rectangle lr = this.getMenuButtonLineBounds(bounds, c);
        g2d.setPaint(((Component)c).isEnabled() ? this.splitLineColor : this.splitLineDisabledColor);
        g2d.drawLine(lr.x, lr.y, lr.x, lr.y + lr.height);
    }

    protected Rectangle getMenuButtonBounds(Rectangle b, C c) {
        Insets i = ((JComponent)c).getInsets();
        int iconWidth = this.getMenuIcon().getIconWidth();
        int x = b.x + (this.ltr ? b.width - i.right + this.contentGap + 1 + this.menuIconGap : i.left - this.contentGap - 1 - this.menuIconGap - iconWidth);
        return new Rectangle(x, b.y + i.top, iconWidth, b.height - i.top - i.bottom);
    }

    protected Rectangle getMenuButtonLineBounds(Rectangle b, C c) {
        Insets i = ((JComponent)c).getInsets();
        int x = b.x + (this.ltr ? b.width - i.right + this.contentGap : i.left - this.contentGap);
        return new Rectangle(x, b.y + i.top, 1, b.height - i.top - i.bottom - 1);
    }

    protected Rectangle getMenuButtonHitbox(C c) {
        Insets i = ((JComponent)c).getInsets();
        return new Rectangle(this.ltr ? ((JComponent)c).getWidth() - i.right : 0, 0, this.ltr ? i.right : i.left, ((JComponent)c).getHeight());
    }

    protected Icon getMenuIcon() {
        Icon customIcon = ((WebSplitButton)this.component).getMenuIcon();
        return customIcon != null ? customIcon : Icons.downSmall;
    }
}

