/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.button.WebSwitchLayout;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.StyleId;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.WebTimer;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

public class WebSwitch
extends WebPanel
implements ItemSelectable {
    protected boolean animate = true;
    protected final WebPanel gripper;
    protected JComponent selectedComponent;
    protected JComponent deselectedComponent;
    protected boolean selected = false;
    protected boolean animating = false;
    protected WebTimer animator;
    protected float gripperLocation = 0.0f;

    public WebSwitch() {
        this(StyleId.wswitch, false);
    }

    public WebSwitch(boolean selected) {
        this(StyleId.wswitch, selected);
    }

    public WebSwitch(StyleId id) {
        this(id, false);
    }

    public WebSwitch(StyleId id, boolean selected) {
        super(id, new WebSwitchLayout(), new Component[0]);
        this.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.gripper = new WebPanel(StyleId.wswitchGripper.at(this));
        this.add((Component)this.gripper, (Object)"GRIPPER");
        this.setSwitchComponents("weblaf.ex.switch.selected", "weblaf.ex.switch.deselected");
        this.createAnimator();
        final Runnable manualSelection = new Runnable(){

            @Override
            public void run() {
                if (WebSwitch.this.isEnabled()) {
                    WebSwitch.this.requestFocusInWindow();
                    WebSwitch.this.setSelected(!WebSwitch.this.isSelected());
                    WebSwitch.this.fireActionPerformed();
                }
            }
        };
        KeyEventRunnable keyEventRunnable = new KeyEventRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                manualSelection.run();
            }
        };
        MouseEventRunnable mouseEventRunnable = new MouseEventRunnable(){

            @Override
            public void run(@NotNull MouseEvent e) {
                manualSelection.run();
            }
        };
        this.onKeyPress(Hotkey.ENTER, keyEventRunnable);
        this.onKeyPress(Hotkey.SPACE, keyEventRunnable);
        this.onMousePress(MouseButton.left, mouseEventRunnable);
        this.setSelected(selected, false);
    }

    protected void createAnimator() {
        this.animator = new WebTimer("WebSwitch.animator", SwingUtils.frameRateDelay(60), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSwitch.this.gripperLocation = WebSwitch.this.gripperLocation + (WebSwitch.this.selected ? 0.1f : -0.1f);
                if (WebSwitch.this.selected && WebSwitch.this.gripperLocation >= 1.0f || !WebSwitch.this.selected && WebSwitch.this.gripperLocation <= 0.0f) {
                    WebSwitch.this.gripperLocation = WebSwitch.this.selected ? 1.0f : 0.0f;
                    WebSwitch.this.revalidate();
                    WebSwitch.this.animating = false;
                    WebSwitch.this.animator.stop();
                } else {
                    WebSwitch.this.revalidate();
                }
            }
        });
    }

    protected void startAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.animator.start();
        }
    }

    public WebPanel getGripper() {
        return this.gripper;
    }

    public float getGripperLocation() {
        return this.gripperLocation;
    }

    public JComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setSelectedComponent(JComponent component) {
        this.setSelectedComponentImpl(component);
        this.revalidate();
    }

    protected void setSelectedComponentImpl(JComponent component) {
        if (this.selectedComponent != null) {
            this.remove((Component)this.selectedComponent);
        }
        this.selectedComponent = component;
        this.add((Component)component, (Object)"LEFT");
    }

    public JComponent getDeselectedComponent() {
        return this.deselectedComponent;
    }

    public void setDeselectedComponent(JComponent component) {
        this.setDeselectedComponentImpl(component);
        this.revalidate();
    }

    protected void setDeselectedComponentImpl(JComponent component) {
        if (this.deselectedComponent != null) {
            this.remove((Component)this.deselectedComponent);
        }
        this.deselectedComponent = component;
        this.add((Component)component, (Object)"RIGHT");
    }

    public void setSwitchComponents(JComponent selected, JComponent deselected) {
        this.setSelectedComponentImpl(selected);
        this.setDeselectedComponentImpl(deselected);
        SwingUtils.equalizeComponentsWidth(this.selectedComponent, this.deselectedComponent);
        this.revalidate();
    }

    public void setSwitchComponents(Icon selected, Icon deselected) {
        WebLabel sl = new WebLabel(StyleId.wswitchSelectedIconLabel.at(this), selected, 0);
        WebLabel dl = new WebLabel(StyleId.wswitchDeselectedIconLabel.at(this), deselected, 0);
        this.setSwitchComponents(sl, dl);
    }

    public void setSwitchComponents(String selected, String deselected) {
        WebLabel sl = new WebLabel(StyleId.wswitchSelectedLabel.at(this), selected, 0, new Object[0]).setBoldFont();
        WebLabel dl = new WebLabel(StyleId.wswitchDeselectedLabel.at(this), deselected, 0, new Object[0]).setBoldFont();
        this.setSwitchComponents(sl, dl);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.gripper.setEnabled(enabled);
        this.selectedComponent.setEnabled(enabled);
        this.deselectedComponent.setEnabled(enabled);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.setSelected(selected, this.animate);
    }

    public void setSelected(boolean selected, boolean animate) {
        this.selected = selected;
        if (animate) {
            this.startAnimation();
        } else {
            this.gripperLocation = selected ? 1.0f : 0.0f;
            this.revalidate();
        }
        this.fireItemStateChanged();
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public void addActionListener(@NotNull ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(@NotNull ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Selection changed");
        for (ActionListener listener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            listener.actionPerformed(actionEvent);
        }
    }

    @Override
    @Nullable
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        if (this.isSelected()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Override
    public void addItemListener(@NotNull ItemListener listener) {
        this.listenerList.add(ItemListener.class, listener);
    }

    @Override
    public void removeItemListener(@NotNull ItemListener listener) {
        this.listenerList.remove(ItemListener.class, listener);
    }

    public void fireItemStateChanged() {
        ItemEvent itemEvent = new ItemEvent(this, 0, this.getSelectedObjects(), this.isSelected() ? 1 : 2);
        for (ItemListener listener : (ItemListener[])this.listenerList.getListeners(ItemListener.class)) {
            listener.itemStateChanged(itemEvent);
        }
    }
}

