/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.canvas;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.WebComponent;
import com.alee.extended.canvas.WCanvasUI;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.ArrayUtils;
import com.alee.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WebCanvas
extends WebComponent<WebCanvas, WCanvasUI>
implements Stateful {
    @NotNull
    protected List<String> states = new ArrayList<String>(1);

    public WebCanvas() {
        this(StyleId.auto, new String[0]);
    }

    public WebCanvas(String ... states) {
        this(StyleId.auto, states);
    }

    public WebCanvas(@NotNull StyleId id, String ... states) {
        this.addStates(states);
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.canvas;
    }

    @Override
    @NotNull
    public List<String> getStates() {
        return new ArrayList<String>(this.states);
    }

    public boolean hasState(@NotNull String state) {
        return this.states.contains(state);
    }

    public void setStates(List<String> states) {
        if (!CollectionUtils.equals(this.states, states, (boolean)false)) {
            ArrayList old = CollectionUtils.copy(this.states);
            this.states = states;
            this.fireStatesChanged(old, this.states);
        }
    }

    public void addStates(String ... states) {
        if (ArrayUtils.notEmpty((Object[])states)) {
            ArrayList old = CollectionUtils.copy(this.states);
            CollectionUtils.addUniqueNonNull(this.states, (Object[])states);
            this.fireStatesChanged(old, this.states);
        }
    }

    public void addStates(@Nullable Collection<String> states) {
        if (states != null && ArrayUtils.notEmpty((Object[])new Collection[]{states})) {
            ArrayList old = CollectionUtils.copy(this.states);
            CollectionUtils.addUniqueNonNull(this.states, states);
            this.fireStatesChanged(old, this.states);
        }
    }

    public void removeStates(String ... states) {
        if (ArrayUtils.notEmpty((Object[])states)) {
            ArrayList old = CollectionUtils.copy(this.states);
            CollectionUtils.removeAll(this.states, (Object[])states);
            this.fireStatesChanged(old, this.states);
        }
    }

    public void removeStates(@Nullable Collection<String> states) {
        if (states != null && ArrayUtils.notEmpty((Object[])new Collection[]{states})) {
            ArrayList old = CollectionUtils.copy(this.states);
            CollectionUtils.removeAll(this.states, states);
            this.fireStatesChanged(old, this.states);
        }
    }

    public void fireStatesChanged(@NotNull List<String> oldStates, @NotNull List<String> newStates) {
        this.firePropertyChange("decorationStates", oldStates, newStates);
    }

    @Override
    public WCanvasUI getUI() {
        return (WCanvasUI)this.ui;
    }

    public void setUI(WCanvasUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

