/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.extended.collapsible.CollapsiblePaneListener;
import com.alee.extended.collapsible.ICollapsiblePanePainter;
import com.alee.extended.collapsible.WCollapsiblePaneUI;
import com.alee.extended.collapsible.WebCollapsiblePane;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.IDecoration;
import java.util.List;

public class CollapsiblePanePainter<C extends WebCollapsiblePane, U extends WCollapsiblePaneUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements ICollapsiblePanePainter<C, U> {
    protected transient CollapsiblePaneListener collapsiblePaneListener;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installCollapsiblePaneListener();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallCollapsiblePaneListener();
        super.uninstallPropertiesAndListeners();
    }

    protected void installCollapsiblePaneListener() {
        this.collapsiblePaneListener = new CollapsiblePaneListener(){

            @Override
            public void expanding(@NotNull WebCollapsiblePane pane) {
                DecorationUtils.fireStatesChanged(pane);
            }

            @Override
            public void expanded(@NotNull WebCollapsiblePane pane) {
                DecorationUtils.fireStatesChanged(pane);
            }

            @Override
            public void collapsing(@NotNull WebCollapsiblePane pane) {
                DecorationUtils.fireStatesChanged(pane);
            }

            @Override
            public void collapsed(@NotNull WebCollapsiblePane pane) {
                DecorationUtils.fireStatesChanged(pane);
            }
        };
        ((WebCollapsiblePane)this.component).addCollapsiblePaneListener(this.collapsiblePaneListener);
    }

    protected void uninstallCollapsiblePaneListener() {
        ((WebCollapsiblePane)this.component).removeCollapsiblePaneListener(this.collapsiblePaneListener);
        this.collapsiblePaneListener = null;
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        states.add(((WebCollapsiblePane)this.component).getHeaderPosition().name());
        states.add(((WebCollapsiblePane)this.component).isExpanded() || ((WebCollapsiblePane)this.component).isInTransition() ? "expanded" : "collapsed");
        if (((WebCollapsiblePane)this.component).isInTransition()) {
            states.add(((WebCollapsiblePane)this.component).isExpanded() ? "expanding" : "collapsing");
        }
        return states;
    }
}

