/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.collapsible.AbstractHeaderPanel;
import com.alee.extended.collapsible.CollapsiblePaneListener;
import com.alee.extended.collapsible.WCollapsiblePaneUI;
import com.alee.extended.collapsible.WebCollapsiblePane;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebCollapsiblePaneUI<C extends WebCollapsiblePane>
extends WCollapsiblePaneUI<C>
implements PropertyChangeListener,
CollapsiblePaneListener {
    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebCollapsiblePaneUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.pane);
        this.installComponents();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallComponents();
        StyleManager.uninstallSkin(this.pane);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        this.pane.addPropertyChangeListener(this);
        this.pane.addCollapsiblePaneListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.pane.removeCollapsiblePaneListener(this);
        this.pane.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if (Objects.equals((Object)property, (Object)"headerPosition")) {
            this.updateDecorationStates();
        } else if (Objects.equals((Object)property, (Object)"headerComponent")) {
            Component newHeader;
            Component oldHeader = (Component)event.getOldValue();
            if (oldHeader != null) {
                this.pane.remove(oldHeader);
            }
            if ((newHeader = (Component)event.getNewValue()) != null) {
                this.pane.add(newHeader);
            }
            SwingUtils.update(this.pane);
        } else if (Objects.equals((Object)property, (Object)"title")) {
            SwingUtils.update(this.pane.getHeaderComponent());
        } else if (Objects.equals((Object)property, (Object)"titleComponent")) {
            Component headerComponent = this.pane.getHeaderComponent();
            if (headerComponent instanceof AbstractHeaderPanel) {
                Component newTitle;
                AbstractHeaderPanel headerPanel = (AbstractHeaderPanel)headerComponent;
                Component oldTitle = (Component)event.getOldValue();
                if (oldTitle != null) {
                    headerPanel.remove(oldTitle);
                }
                if ((newTitle = (Component)event.getNewValue()) != null) {
                    headerPanel.add(newTitle, (Object)"title");
                }
                SwingUtils.update(headerPanel);
            }
        } else if (Objects.equals((Object)property, (Object)"controlComponent")) {
            Component headerComponent = this.pane.getHeaderComponent();
            if (headerComponent instanceof AbstractHeaderPanel) {
                Component newControl;
                AbstractHeaderPanel headerPanel = (AbstractHeaderPanel)headerComponent;
                Component oldControl = (Component)event.getOldValue();
                if (oldControl != null) {
                    headerPanel.remove(oldControl);
                }
                if ((newControl = (Component)event.getNewValue()) != null) {
                    headerPanel.add(newControl, (Object)"control");
                }
                SwingUtils.update(headerPanel);
            }
        } else if (Objects.equals((Object)property, (Object)"content")) {
            Component newContent;
            Component oldContent = (Component)event.getOldValue();
            if (oldContent != null) {
                this.pane.remove(oldContent);
            }
            if ((newContent = (Component)event.getNewValue()) != null) {
                this.pane.add(newContent);
            }
            SwingUtils.update(this.pane);
        }
    }

    @Override
    public void expanding(@NotNull WebCollapsiblePane pane) {
        this.updateDecorationStates();
    }

    @Override
    public void expanded(@NotNull WebCollapsiblePane pane) {
        this.updateDecorationStates();
    }

    @Override
    public void collapsing(@NotNull WebCollapsiblePane pane) {
        this.updateDecorationStates();
    }

    @Override
    public void collapsed(@NotNull WebCollapsiblePane pane) {
        this.updateDecorationStates();
    }

    protected void updateDecorationStates() {
        if (this.pane.getHeaderComponent() instanceof AbstractHeaderPanel) {
            DecorationUtils.fireStatesChanged(this.pane.getTitleComponent());
            DecorationUtils.fireStatesChanged(this.pane.getControlComponent());
        }
        DecorationUtils.fireStatesChanged(this.pane.getHeaderComponent());
    }

    protected void installComponents() {
        Component headerComponent = this.pane.getHeaderComponent();
        if (headerComponent instanceof AbstractHeaderPanel) {
            this.pane.getTitleComponent();
            this.pane.getControlComponent();
        }
    }

    protected void uninstallComponents() {
        Component headerComponent = this.pane.getHeaderComponent();
        if (headerComponent instanceof AbstractHeaderPanel) {
            Component controlComponent;
            AbstractHeaderPanel headerPanel = (AbstractHeaderPanel)headerComponent;
            Component titleComponent = this.pane.getTitleComponent();
            if (titleComponent != null) {
                headerPanel.remove(titleComponent);
            }
            if ((controlComponent = this.pane.getControlComponent()) != null) {
                headerPanel.remove(controlComponent);
            }
        }
        this.pane.removeAll();
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c);
    }
}

