/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.date.DateListener;
import com.alee.extended.date.WDateFieldUI;
import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateField;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.button.WebButton;
import com.alee.laf.text.WebFormattedTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebDateFieldUI<C extends WebDateField>
extends WDateFieldUI<C> {
    protected transient PropertyChangeListener propertyChangeListener;
    protected transient FocusAdapter focusListener;
    protected WebFormattedTextField field;
    protected WebButton button;
    protected WebPopOver popup;
    protected WebCalendar calendar;
    protected boolean updating = false;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebDateFieldUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.dateField);
        this.installComponents();
        this.installActions();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallActions();
        this.uninstallComponents();
        StyleManager.uninstallSkin(this.dateField);
        super.uninstallUI(c);
    }

    protected void installComponents() {
        SwingUtils.setHandlesEnableStateMark(this.dateField);
        this.dateField.setLayout(new BorderLayout(0, 0));
        this.field = new WebFormattedTextField(StyleId.datefieldField.at(this.dateField));
        this.dateField.add((Component)this.field, "Center");
        this.button = new WebButton(StyleId.datefieldButton.at(this.dateField), (Icon)Icons.calendar, (Icon)Icons.calendarHover);
        this.dateField.add((Component)this.button, "After");
    }

    protected void uninstallComponents() {
        this.dateField.removeAll();
        this.dateField.revalidate();
        this.dateField.repaint();
        if (this.calendar != null) {
            this.calendar.resetStyleId();
            this.calendar = null;
        }
        if (this.popup != null) {
            this.popup.resetStyleId();
            this.popup = null;
        }
        this.button.resetStyleId();
        this.button = null;
        this.field.resetStyleId();
        this.field = null;
        SwingUtils.removeHandlesEnableStateMark(this.dateField);
    }

    protected void installActions() {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if (Objects.equals((Object)property, (Object)"allowUserInput")) {
                    WebDateFieldUI.this.field.setEditable((Boolean)evt.getNewValue());
                } else if (Objects.equals((Object)property, (Object)"enabled")) {
                    WebDateFieldUI.this.updateEnabledState();
                } else if (Objects.equals((Object)property, (Object)"font")) {
                    WebDateFieldUI.this.field.setFont(WebDateFieldUI.this.dateField.getFont());
                } else if (Objects.equals((Object)property, (Object)"background")) {
                    WebDateFieldUI.this.field.setBackground(WebDateFieldUI.this.dateField.getBackground());
                } else if (Objects.equals((Object)property, (Object)"foreground")) {
                    WebDateFieldUI.this.field.setForeground(WebDateFieldUI.this.dateField.getForeground());
                } else if (Objects.equals((Object)property, (Object)"dateFormat")) {
                    WebDateFieldUI.this.setDate(WebDateFieldUI.this.dateField.getDate(), UpdateSource.datefield);
                    WebDateFieldUI.this.updateExpectedFieldLength();
                } else if (Objects.equals((Object)property, (Object)"date")) {
                    WebDateFieldUI.this.setDate(WebDateFieldUI.this.dateField.getDate(), UpdateSource.datefield);
                } else if (Objects.equals((Object)property, (Object)"calendarCustomizer")) {
                    WebDateFieldUI.this.customizeCalendar();
                }
            }
        };
        this.dateField.addPropertyChangeListener(this.propertyChangeListener);
        this.updateExpectedFieldLength();
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                WebDateFieldUI.this.field.requestFocusInWindow();
            }
        };
        this.dateField.addFocusListener(this.focusListener);
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebDateFieldUI.this.setDate(WebDateFieldUI.this.getDate(WebDateFieldUI.this.field.getText()), UpdateSource.field);
            }
        });
        this.field.onFocusLoss(new FocusEventRunnable(){

            @Override
            public void run(@NotNull FocusEvent e) {
                Date modelDate;
                String modelDateText;
                Date fieldDate = WebDateFieldUI.this.getDate(WebDateFieldUI.this.field.getText());
                String fieldDateText = WebDateFieldUI.this.getText(fieldDate);
                if (Objects.notEquals((Object)fieldDateText, (Object)(modelDateText = WebDateFieldUI.this.getText(modelDate = WebDateFieldUI.this.dateField.getDate())))) {
                    WebDateFieldUI.this.setDate(fieldDate, UpdateSource.field);
                } else {
                    WebDateFieldUI.this.field.setText(fieldDateText);
                }
            }
        });
        this.field.onKeyPress(Hotkey.DOWN, new KeyEventRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                WebDateFieldUI.this.showDateChooserPopup();
                e.consume();
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebDateFieldUI.this.showDateChooserPopup();
            }
        });
    }

    protected void uninstallActions() {
        this.dateField.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.dateField.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void updateEnabledState() {
        this.field.setEnabled(this.dateField.isEnabled());
        this.button.setEnabled(this.dateField.isEnabled());
    }

    protected void updateExpectedFieldLength() {
        DateFormat dateFormat = this.dateField.getDateFormat();
        String sampleDateText = dateFormat.format(new Date());
        Insets insets = this.field.getInsets();
        FontMetrics fm = this.field.getFontMetrics(this.field.getFont());
        int stringWidth = fm.stringWidth(sampleDateText);
        this.field.setPreferredWidth(insets.left + stringWidth + 5 + insets.right);
    }

    protected void showDateChooserPopup() {
        if (this.popup == null) {
            this.popup = new WebPopOver(StyleId.datefieldPopup.at(this.dateField), this.dateField);
            this.popup.setCloseOnFocusLoss(true);
            this.popup.setMovable(false);
            this.calendar = new WebCalendar(StyleId.datefieldCalendar.at(this.popup), this.dateField.getDate());
            this.calendar.addDateSelectionListener(new DateListener(){

                @Override
                public void dateChanged(@Nullable Date date) {
                    if (!WebDateFieldUI.this.updating) {
                        WebDateFieldUI.this.setDate(date, UpdateSource.calendar);
                        WebDateFieldUI.this.popup.setVisible(false);
                    }
                }
            });
            this.calendar.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    WebDateFieldUI.this.popup.setVisible(false);
                }
            }, Hotkey.ESCAPE.getKeyStroke(), 2);
            this.popup.add(this.calendar);
            this.customizeCalendar();
        }
        this.popup.show((Component)this.dateField, PopOverDirection.down, PopOverAlignment.centered);
        this.popup.requestFocusInWindow();
    }

    protected void customizeCalendar() {
        if (this.calendar != null && this.dateField.getCalendarCustomizer() != null) {
            this.dateField.getCalendarCustomizer().customize((Object)this.calendar);
        }
    }

    protected void setDate(@Nullable Date date, @NotNull UpdateSource source) {
        if (!this.updating) {
            this.updating = true;
            if (source != UpdateSource.datefield) {
                this.dateField.setDate(date);
            }
            if (source != UpdateSource.field) {
                this.field.setText(this.getText(date));
                this.field.setCaretPosition(0);
            } else {
                int pos = this.field.getCaretPosition();
                String text = this.getText(date);
                this.field.setText(text);
                this.field.setCaretPosition(pos <= text.length() ? pos : text.length());
            }
            if (source != UpdateSource.calendar && this.calendar != null) {
                this.calendar.setDate(date);
            }
            if (source == UpdateSource.calendar) {
                this.field.setCaretPosition(this.field.getText().length());
                this.field.requestFocusInWindow();
            }
            this.updating = false;
        }
    }

    @Nullable
    protected Date getDate(@Nullable String text) {
        Date date;
        try {
            date = text != null && !text.trim().equals("") ? this.dateField.getDateFormat().parse(text) : null;
        }
        catch (Exception ex) {
            date = this.dateField.getDate();
        }
        return date;
    }

    @NotNull
    protected String getText(@Nullable Date date) {
        return date != null ? this.dateField.getDateFormat().format(date) : "";
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c);
    }

    protected static enum UpdateSource {
        datefield,
        field,
        calendar;

    }
}

