/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.data.Orientation;
import com.alee.api.jdk.Objects;
import com.alee.extended.dock.DockablePaneModel;
import com.alee.extended.dock.SidebarButton;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.dock.data.DockableContainer;
import com.alee.extended.dock.data.DockableContentElement;
import com.alee.extended.dock.data.DockableElement;
import com.alee.extended.dock.data.DockableFrameElement;
import com.alee.extended.dock.data.DockableListContainer;
import com.alee.extended.dock.data.ResizeData;
import com.alee.extended.dock.drag.FrameDragData;
import com.alee.extended.dock.drag.FrameDropData;
import com.alee.extended.dock.drag.FrameTransferable;
import com.alee.laf.grouping.AbstractGroupingLayout;
import com.alee.laf.window.WebDialog;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.general.Pair;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

@XStreamAlias(value="DockablePaneModel")
public class WebDockablePaneModel
extends AbstractGroupingLayout
implements DockablePaneModel {
    protected static final int dropSide = 40;
    @NotNull
    protected DockableContainer root;
    @NotNull
    protected DockableContentElement content;
    @NotNull
    protected final transient Map<CompassDirection, Integer> sidebarSizes;
    @NotNull
    protected final transient List<ResizeData> resizableAreas;
    @Nullable
    protected transient Rectangle previewBounds;

    public WebDockablePaneModel() {
        this(new DockableListContainer(Orientation.horizontal, new DockableContentElement()));
    }

    public WebDockablePaneModel(@NotNull DockableContainer root) {
        this.groupButtons = false;
        this.sidebarSizes = new HashMap<CompassDirection, Integer>();
        this.resizableAreas = new ArrayList<ResizeData>();
        this.previewBounds = null;
        this.setRoot(root);
    }

    @Override
    @NotNull
    public DockableContainer getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(@NotNull DockableContainer root) {
        this.root = root;
        this.content = (DockableContentElement)root.get("dockablepane.content");
        this.root.added(null);
    }

    @Override
    @NotNull
    public <T extends DockableElement> T getElement(@NotNull String id) {
        return (T)this.root.get(id);
    }

    @Override
    public void updateFrame(@NotNull WebDockablePane dockablePane, @NotNull WebDockableFrame frame) {
        DockableFrameElement element;
        if (this.root.contains(frame.getId())) {
            element = (DockableFrameElement)this.root.get(frame.getId());
            frame.setState(element.getState());
            frame.setRestoreState(element.getRestoreState());
        } else {
            element = new DockableFrameElement(frame);
            this.addStructureElement(this.content, element, frame.getPosition());
        }
        CompassDirection position = this.getFramePosition(frame);
        frame.setPosition(position);
        this.resetDescriptors();
    }

    @Override
    public void removeFrame(@NotNull WebDockablePane dockablePane, @NotNull WebDockableFrame frame) {
        if (this.root.contains(frame.getId())) {
            DockableFrameElement element = (DockableFrameElement)this.root.get(frame.getId());
            this.removeStructureElement(element);
            this.resetDescriptors();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addStructureElement(@NotNull DockableElement element, @NotNull DockableElement newElement, @NotNull CompassDirection direction) {
        Orientation orientation = direction == CompassDirection.north || direction == CompassDirection.south ? Orientation.vertical : Orientation.horizontal;
        DockableContainer parent = element.getParent();
        if (parent == null) {
            if (orientation == this.root.getOrientation() || this.root.getElementCount() <= 1) {
                if (direction == CompassDirection.north || direction == CompassDirection.west) {
                    this.addStructureElement(this.root.get(0), newElement, direction);
                    return;
                } else {
                    if (direction != CompassDirection.south && direction != CompassDirection.east) throw new RuntimeException("Unknown element position specified");
                    this.addStructureElement(this.root.get(this.root.getElementCount() - 1), newElement, direction);
                }
                return;
            } else {
                this.root = new DockableListContainer(orientation, element);
                this.addStructureElement(element, newElement, direction);
            }
            return;
        } else {
            int index = parent.indexOf(element);
            if (orientation == parent.getOrientation() || parent.getElementCount() <= 1) {
                parent.setOrientation(orientation);
                if (orientation.isHorizontal() && direction == CompassDirection.west || orientation.isVertical() && direction == CompassDirection.north) {
                    parent.add(index, newElement);
                    return;
                } else {
                    if ((!orientation.isHorizontal() || direction != CompassDirection.east) && (!orientation.isVertical() || direction != CompassDirection.south)) throw new RuntimeException("Unknown element position specified");
                    parent.add(index + 1, newElement);
                }
                return;
            } else {
                Dimension size = element.getSize();
                parent.remove(element);
                DockableListContainer list = new DockableListContainer(orientation, element);
                if (!list.isContent()) {
                    list.setSize(size);
                }
                parent.add(index, list);
                this.addStructureElement(element, newElement, direction);
            }
        }
    }

    protected void removeStructureElement(@NotNull DockableElement element) {
        if (element.getParent() == null) {
            throw new RuntimeException("Structure element cannot be removed");
        }
        if (element == this.content) {
            throw new RuntimeException("Content element cannot be removed");
        }
        DockableContainer container = element.getParent();
        container.remove(element);
        if (container.getParent() != null && container.getElementCount() <= 1) {
            if (container.getElementCount() == 1) {
                DockableContainer containerParent = container.getParent();
                int index = containerParent.indexOf(container);
                DockableElement lastChild = container.get(0);
                if (!(lastChild instanceof DockableContentElement)) {
                    Dimension oldChildSize = lastChild.getSize();
                    Dimension containerSize = container.getSize();
                    boolean horizontal = containerParent.getOrientation().isHorizontal();
                    lastChild.setSize(new Dimension(horizontal ? containerSize.width : oldChildSize.width, horizontal ? oldChildSize.height : containerSize.height));
                }
                containerParent.add(index, lastChild);
            }
            this.removeStructureElement(container);
        }
    }

    @Override
    @Nullable
    public FrameDropData dropData(@NotNull WebDockablePane dockablePane, @NotNull TransferHandler.TransferSupport support) {
        FrameDropData dropData;
        block6: {
            dropData = null;
            if (support.getTransferable().isDataFlavorSupported(FrameTransferable.dataFlavor)) {
                try {
                    Point paneLocation;
                    FrameDragData drag = (FrameDragData)support.getTransferable().getTransferData(FrameTransferable.dataFlavor);
                    if (dockablePane.findFrame(drag.getId()) == null) break block6;
                    String id = drag.getId();
                    Point dropPoint = support.getDropLocation().getDropPoint();
                    Rectangle innerBounds = this.getInnerBounds(dockablePane);
                    FrameDropData globalDropData = this.createDropData(id, this.root, innerBounds, dropPoint, 40);
                    if (globalDropData != null) {
                        dropData = globalDropData;
                        break block6;
                    }
                    JComponent paneContent = dockablePane.getContent();
                    Point point = paneLocation = paneContent != null ? paneContent.getLocation() : null;
                    if (paneContent != null && paneContent.contains(dropPoint.x - paneLocation.x, dropPoint.y - paneLocation.y)) {
                        Rectangle dropBounds = this.getDropBounds(paneContent);
                        dropData = this.createDropData(id, this.content, dropBounds, dropPoint, 80);
                        break block6;
                    }
                    for (WebDockableFrame paneFrame : dockablePane.getFrames()) {
                        if (!paneFrame.isDocked() || !Objects.notEquals((Object)paneFrame.getId(), (Object)id)) continue;
                        Point location = paneFrame.getLocation();
                        if (!paneFrame.contains(dropPoint.x - location.x, dropPoint.y - location.y)) continue;
                        Object element = this.root.get(paneFrame.getId());
                        Rectangle dropBounds = this.getDropBounds(paneFrame);
                        dropData = this.createDropData(id, (DockableElement)element, dropBounds, dropPoint, 80);
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unknown frame drop exception occurred", e);
                }
            }
        }
        return dropData;
    }

    @NotNull
    protected Rectangle getDropBounds(@NotNull JComponent component) {
        Rectangle bounds = component.getBounds();
        Insets i = component.getInsets();
        bounds.x += i.left - 1;
        bounds.y += i.top - 1;
        bounds.width -= i.left + i.right - 1;
        bounds.height -= i.top + i.bottom - 1;
        return bounds;
    }

    @Nullable
    protected FrameDropData createDropData(@NotNull String id, @NotNull DockableElement element, @NotNull Rectangle bounds, @NotNull Point dropPoint, int dropSide) {
        FrameDropData dropData;
        Object direction;
        boolean s;
        boolean wSmall = dropSide > bounds.width / 2;
        boolean hSmall = dropSide > bounds.height / 2;
        int xSide = Math.min(dropSide, bounds.width / 2);
        int ySide = Math.min(dropSide, bounds.height / 2);
        boolean w = dropPoint.x <= bounds.x + xSide;
        boolean e = dropPoint.x >= bounds.x + bounds.width - xSide;
        boolean n = dropPoint.y <= bounds.y + ySide;
        boolean bl = s = dropPoint.y >= bounds.y + bounds.height - ySide;
        if (wSmall || hSmall) {
            direction = wSmall ? (n ? CompassDirection.north : (s ? CompassDirection.south : (w ? CompassDirection.west : (e ? CompassDirection.east : null)))) : (w ? CompassDirection.west : (e ? CompassDirection.east : (n ? CompassDirection.north : (s ? CompassDirection.south : null))));
        } else if (w && n) {
            direction = dropPoint.x - bounds.x > dropPoint.y - bounds.y ? CompassDirection.north : CompassDirection.west;
        } else if (w && s) {
            direction = dropPoint.x - bounds.x > bounds.y + bounds.height - dropPoint.y ? CompassDirection.south : CompassDirection.west;
        } else if (e && n) {
            direction = bounds.x + bounds.width - dropPoint.x > dropPoint.y - bounds.y ? CompassDirection.north : CompassDirection.east;
        } else if (e && s) {
            direction = bounds.x + bounds.width - dropPoint.x > bounds.y + bounds.height - dropPoint.y ? CompassDirection.south : CompassDirection.east;
        } else {
            Object object = n ? CompassDirection.north : (s ? CompassDirection.south : (w ? CompassDirection.west : (direction = e ? CompassDirection.east : null)));
        }
        if (direction != null) {
            switch (direction) {
                case west: {
                    bounds.width = xSide;
                    break;
                }
                case east: {
                    bounds.x = bounds.x + bounds.width - xSide;
                    bounds.width = xSide;
                    break;
                }
                case north: {
                    bounds.height = ySide;
                    break;
                }
                case south: {
                    bounds.y = bounds.y + bounds.height - ySide;
                    bounds.height = ySide;
                }
            }
            dropData = new FrameDropData(id, bounds, element, (CompassDirection)direction);
        } else {
            dropData = null;
        }
        return dropData;
    }

    @Override
    public boolean drop(@NotNull WebDockablePane dockablePane, @NotNull TransferHandler.TransferSupport support) {
        FrameDropData dropData = this.dropData(dockablePane, support);
        if (dropData != null) {
            Object element = this.root.get(dropData.getId());
            this.removeStructureElement((DockableElement)element);
            this.addStructureElement(dropData.getElement(), (DockableElement)element, dropData.getDirection());
            WebDockableFrame frame = dockablePane.getFrame(element.getId());
            CompassDirection position = this.getFramePosition(frame);
            frame.setPosition(position);
            this.resetDescriptors();
            dockablePane.revalidate();
            dockablePane.repaint();
            frame.fireFrameMoved(position);
        }
        return false;
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        JComponent glassLayer;
        WebDockablePane dockablePane = (WebDockablePane)container;
        int w = dockablePane.getWidth();
        int h = dockablePane.getHeight();
        boolean ltr = dockablePane.getComponentOrientation().isLeftToRight();
        Rectangle outer = this.getOuterBounds(dockablePane);
        ArrayList locations = CollectionUtils.asList((Object[])new CompassDirection[]{CompassDirection.north, CompassDirection.west, CompassDirection.south, CompassDirection.east});
        HashMap<CompassDirection, List<SidebarButton>> allButtons = new HashMap<CompassDirection, List<SidebarButton>>();
        for (CompassDirection location : locations) {
            List<SidebarButton> barButtons = this.getVisibleButtons(dockablePane, location);
            allButtons.put(location, barButtons);
            this.sidebarSizes.put(location, this.calculateBarSize(location, barButtons));
        }
        for (CompassDirection location : locations) {
            Rectangle bounds;
            List buttons = (List)allButtons.get(location);
            if (buttons.size() <= 0) continue;
            int barWidth = this.sidebarSizes.get(location);
            switch (location) {
                case north: {
                    int fw = this.sidebarSizes.get(CompassDirection.west);
                    int lw = this.sidebarSizes.get(CompassDirection.east);
                    bounds = new Rectangle(outer.x + fw, outer.y, outer.width - fw - lw, barWidth);
                    break;
                }
                case west: {
                    int fw = this.sidebarSizes.get(CompassDirection.north);
                    int lw = this.sidebarSizes.get(CompassDirection.south);
                    if (ltr) {
                        bounds = new Rectangle(outer.x, outer.y + fw, barWidth, outer.height - fw - lw);
                        break;
                    }
                    bounds = new Rectangle(outer.x + outer.width - barWidth, outer.y + fw, barWidth, outer.height - fw - lw);
                    break;
                }
                case south: {
                    int fw = this.sidebarSizes.get(CompassDirection.west);
                    int lw = this.sidebarSizes.get(CompassDirection.east);
                    bounds = new Rectangle(outer.x + fw, outer.y + outer.height - barWidth, outer.width - fw - lw, barWidth);
                    break;
                }
                case east: {
                    int fw = this.sidebarSizes.get(CompassDirection.north);
                    int lw = this.sidebarSizes.get(CompassDirection.south);
                    if (ltr) {
                        bounds = new Rectangle(outer.x + outer.width - barWidth, outer.y + fw, barWidth, outer.height - fw - lw);
                        break;
                    }
                    bounds = new Rectangle(outer.x, outer.y + fw, barWidth, outer.height - fw - lw);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown location specified: " + location);
                }
            }
            int x = bounds.x;
            int y = bounds.y;
            for (JComponent button : buttons) {
                Dimension bps = button.getPreferredSize();
                if (location == CompassDirection.north || location == CompassDirection.south) {
                    button.setBounds(x, y, bps.width, barWidth);
                    x += button.getWidth();
                    continue;
                }
                button.setBounds(x, y, barWidth, bps.height);
                y += button.getHeight();
            }
        }
        Rectangle inner = this.getInnerBounds(dockablePane);
        WebDockableFrame preview = null;
        WebDockableFrame maximized = null;
        for (WebDockableFrame frame : dockablePane.frames) {
            if (frame.isPreview()) {
                preview = frame;
                continue;
            }
            if (!frame.isDocked() || !frame.isMaximized()) continue;
            maximized = frame;
        }
        this.resizableAreas.clear();
        if (maximized == null) {
            this.root.setSize(inner.getSize());
            this.root.layout(dockablePane, inner, this.resizableAreas);
        } else {
            for (WebDockableFrame frame : dockablePane.frames) {
                if (frame == preview || frame == maximized || !frame.isDocked()) continue;
                frame.setBounds(0, 0, 0, 0);
            }
        }
        if (preview != null) {
            this.previewBounds = this.getPreviewBounds(dockablePane, preview);
            preview.setBounds(this.previewBounds);
            this.root.get(preview.getId()).setBounds(this.previewBounds);
            dockablePane.setComponentZOrder(preview, 1);
        } else {
            this.previewBounds = null;
        }
        if (maximized != null) {
            maximized.setBounds(outer);
            this.root.get(maximized.getId()).setBounds(outer);
            dockablePane.setComponentZOrder(maximized, preview != null ? 2 : 1);
        }
        if ((glassLayer = dockablePane.getGlassLayer()) != null) {
            glassLayer.setBounds(0, 0, w, h);
        }
    }

    @Override
    @NotNull
    public Rectangle getOuterBounds(@NotNull WebDockablePane dockablePane) {
        int w = dockablePane.getWidth();
        int h = dockablePane.getHeight();
        Insets bi = dockablePane.getInsets();
        return new Rectangle(bi.left, bi.top, w - bi.left - bi.right, h - bi.top - bi.bottom);
    }

    @Override
    @NotNull
    public Rectangle getInnerBounds(@NotNull WebDockablePane dockablePane) {
        Rectangle bounds = this.getOuterBounds(dockablePane);
        if (this.sidebarSizes.size() > 0) {
            int eastSide;
            int southSide;
            int westSide;
            boolean ltr = dockablePane.getComponentOrientation().isLeftToRight();
            int northSide = this.sidebarSizes.get(CompassDirection.north);
            if (northSide > 0) {
                northSide += dockablePane.getSidebarSpacing();
            }
            if ((westSide = (ltr ? this.sidebarSizes.get(CompassDirection.west) : this.sidebarSizes.get(CompassDirection.east)).intValue()) > 0) {
                westSide += dockablePane.getSidebarSpacing();
            }
            if ((southSide = this.sidebarSizes.get(CompassDirection.south).intValue()) > 0) {
                southSide += dockablePane.getSidebarSpacing();
            }
            if ((eastSide = (ltr ? this.sidebarSizes.get(CompassDirection.east) : this.sidebarSizes.get(CompassDirection.west)).intValue()) > 0) {
                eastSide += dockablePane.getSidebarSpacing();
            }
            bounds.x += westSide;
            bounds.width -= westSide + eastSide;
            bounds.y += northSide;
            bounds.height -= northSide + southSide;
        }
        return bounds;
    }

    @NotNull
    protected Rectangle getPreviewBounds(@NotNull WebDockablePane dockablePane, @NotNull WebDockableFrame frame) {
        Rectangle pb;
        Object element = this.root.get(frame.getId());
        Rectangle inner = this.getInnerBounds(dockablePane);
        switch (frame.getPosition()) {
            case north: {
                int height = Math.min(element.getSize().height, inner.height);
                pb = new Rectangle(inner.x, inner.y, inner.width, height);
                break;
            }
            case west: {
                int width = Math.min(element.getSize().width, inner.width);
                pb = new Rectangle(inner.x, inner.y, width, inner.height);
                break;
            }
            case south: {
                int height = Math.min(element.getSize().height, inner.height);
                pb = new Rectangle(inner.x, inner.y + inner.height - height, inner.width, height);
                break;
            }
            case east: {
                int width = Math.min(element.getSize().width, inner.width);
                pb = new Rectangle(inner.x + inner.width - width, inner.y, width, inner.height);
                break;
            }
            default: {
                throw new RuntimeException("Unknown frame position: " + frame.getPosition());
            }
        }
        return pb;
    }

    @NotNull
    protected CompassDirection getFramePosition(@NotNull WebDockableFrame frame) {
        CompassDirection position = null;
        DockableElement previous = this.content;
        for (DockableContainer parent = this.content.getParent(); parent != null; parent = parent.getParent()) {
            DockableElement element;
            int i;
            int divider = parent.indexOf(previous);
            for (i = 0; i < divider; ++i) {
                element = parent.get(i);
                if (!Objects.equals((Object)element.getId(), (Object)frame.getId()) && (!(element instanceof DockableContainer) || !((DockableContainer)element).contains(frame.getId()))) continue;
                position = parent.getOrientation().isHorizontal() ? CompassDirection.west : CompassDirection.north;
                break;
            }
            if (position != null) break;
            for (i = divider + 1; i < parent.getElementCount(); ++i) {
                element = parent.get(i);
                if (!Objects.equals((Object)element.getId(), (Object)frame.getId()) && (!(element instanceof DockableContainer) || !((DockableContainer)element).contains(frame.getId()))) continue;
                position = parent.getOrientation().isHorizontal() ? CompassDirection.east : CompassDirection.south;
                break;
            }
            if (position != null) break;
            previous = parent;
        }
        if (position == null) {
            throw new RuntimeException("Specified frame cannot be found in model: " + frame.getId());
        }
        return position;
    }

    @NotNull
    protected List<SidebarButton> getVisibleButtons(@NotNull WebDockablePane dockablePane, @NotNull CompassDirection side) {
        ArrayList<SidebarButton> buttons = new ArrayList<SidebarButton>(3);
        DockableElement previous = this.content;
        for (DockableContainer parent = this.content.getParent(); parent != null; parent = parent.getParent()) {
            int i;
            int divider = parent.indexOf(previous);
            if (parent.getOrientation().isHorizontal() ? side == CompassDirection.west : side == CompassDirection.north) {
                for (i = 0; i < divider; ++i) {
                    this.collectVisibleButtons(dockablePane, parent.get(i), buttons);
                }
            } else if (parent.getOrientation().isHorizontal() ? side == CompassDirection.east : side == CompassDirection.south) {
                for (i = divider + 1; i < parent.getElementCount(); ++i) {
                    this.collectVisibleButtons(dockablePane, parent.get(i), buttons);
                }
            }
            previous = parent;
        }
        return buttons;
    }

    protected void collectVisibleButtons(@NotNull WebDockablePane dockablePane, @NotNull DockableElement element, @NotNull List<SidebarButton> buttons) {
        if (element instanceof DockableFrameElement) {
            WebDockableFrame frame = dockablePane.findFrame(element.getId());
            if (frame != null && frame.isSidebarButtonVisible()) {
                buttons.add(frame.getSidebarButton());
            }
        } else if (element instanceof DockableContainer) {
            DockableContainer container = (DockableContainer)element;
            for (int i = 0; i < container.getElementCount(); ++i) {
                this.collectVisibleButtons(dockablePane, container.get(i), buttons);
            }
        }
    }

    protected int calculateBarSize(@NotNull CompassDirection side, @NotNull List<? extends JComponent> barButtons) {
        int width = 0;
        for (JComponent jComponent : barButtons) {
            Dimension ps = jComponent.getPreferredSize();
            width = Math.max(width, side == CompassDirection.north || side == CompassDirection.south ? ps.height : ps.width);
        }
        return width;
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        return new Dimension(0, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Pair<String, String> getDescriptors(@NotNull Container container, @NotNull Component component, int index) {
        WebDockablePane dockablePane = (WebDockablePane)container;
        if (!dockablePane.isGroupElements()) return new Pair();
        if (dockablePane.getContentSpacing() != 0) return new Pair();
        if (component == dockablePane.getContent()) {
            return new Pair();
        }
        if (component instanceof SidebarButton) {
            return new Pair((Object)DecorationUtils.toString(false, false, false, false), (Object)DecorationUtils.toString(false, false, false, false));
        }
        if (!(component instanceof WebDockableFrame)) throw new RuntimeException("Unknown layout element: " + component);
        WebDockableFrame frame = (WebDockableFrame)component;
        if (frame.isMaximized()) {
            return new Pair((Object)DecorationUtils.toString(false, false, false, false), (Object)DecorationUtils.toString(false, false, false, false));
        }
        Object frameElement = this.root.get(frame.getId());
        DockableContainer frameContainer = frameElement.getParent();
        if (frameContainer == null) throw new RuntimeException("Frame doesn't have container: " + frame);
        String sides = DecorationUtils.toString(false, false, false, false);
        String lines = DecorationUtils.toString(this.isStartLineNeeded(dockablePane, (DockableElement)frameElement, frameContainer, Orientation.vertical), this.isStartLineNeeded(dockablePane, (DockableElement)frameElement, frameContainer, Orientation.horizontal), this.isEndLineNeeded(dockablePane, (DockableElement)frameElement, frameContainer, Orientation.vertical), this.isEndLineNeeded(dockablePane, (DockableElement)frameElement, frameContainer, Orientation.horizontal));
        return new Pair((Object)sides, (Object)lines);
    }

    protected boolean isStartLineNeeded(@NotNull WebDockablePane dockablePane, @NotNull DockableElement element, @NotNull DockableContainer container, @NotNull Orientation orientation) {
        DockableContainer containerParent;
        DockableContainer containerParent2;
        DockableElement previous;
        Orientation containerOrientation = container.getOrientation();
        boolean needed = containerOrientation == orientation ? ((previous = this.getPreviousVisible(dockablePane, container, element)) != null ? this.isContentAtTheEnd(dockablePane, previous, orientation) : (containerParent2 = container.getParent()) != null && this.isStartLineNeeded(dockablePane, container, containerParent2, orientation)) : (containerParent = container.getParent()) != null && this.isStartLineNeeded(dockablePane, container, containerParent, orientation);
        return needed;
    }

    protected boolean isEndLineNeeded(@NotNull WebDockablePane dockablePane, @NotNull DockableElement element, @NotNull DockableContainer container, @NotNull Orientation orientation) {
        boolean needed;
        Orientation containerOrientation = container.getOrientation();
        if (containerOrientation == orientation) {
            DockableContainer containerParent;
            DockableElement next = this.getNextVisible(dockablePane, container, element);
            needed = next != null ? true : (containerParent = container.getParent()) != null && this.isEndLineNeeded(dockablePane, container, containerParent, orientation);
        } else {
            DockableContainer containerParent;
            boolean contentAtEndOfNearbyElement = false;
            for (int index = 0; index < container.getElementCount(); ++index) {
                DockableElement other = container.get(index);
                if (other == element || !this.isContentAtTheEnd(dockablePane, other, orientation)) continue;
                contentAtEndOfNearbyElement = true;
                break;
            }
            needed = contentAtEndOfNearbyElement ? false : (containerParent = container.getParent()) != null && this.isEndLineNeeded(dockablePane, container, containerParent, orientation);
        }
        return needed;
    }

    protected boolean isContentAtTheStart(@NotNull WebDockablePane dockablePane, @NotNull DockableElement element, @NotNull Orientation orientation) {
        boolean contentAtTheStart;
        if (element instanceof DockableContentElement) {
            contentAtTheStart = true;
        } else if (element instanceof DockableContainer) {
            DockableContainer container = (DockableContainer)element;
            if (container.getOrientation() == orientation) {
                DockableElement firstElement = this.getFirstVisible(dockablePane, container);
                contentAtTheStart = firstElement != null && this.isContentAtTheStart(dockablePane, firstElement, orientation);
            } else {
                boolean contentAtTheStartOfOne = false;
                for (int index = 0; index < container.getElementCount(); ++index) {
                    if (!this.isContentAtTheStart(dockablePane, container.get(index), orientation)) continue;
                    contentAtTheStartOfOne = true;
                    break;
                }
                contentAtTheStart = contentAtTheStartOfOne;
            }
        } else {
            contentAtTheStart = false;
        }
        return contentAtTheStart;
    }

    protected boolean isContentAtTheEnd(@NotNull WebDockablePane dockablePane, @NotNull DockableElement element, @NotNull Orientation orientation) {
        boolean contentAtTheEnd;
        if (element instanceof DockableContentElement) {
            contentAtTheEnd = true;
        } else if (element instanceof DockableContainer) {
            DockableContainer container = (DockableContainer)element;
            if (container.getOrientation() == orientation) {
                DockableElement lastElement = this.getLastVisible(dockablePane, container);
                contentAtTheEnd = lastElement != null && this.isContentAtTheEnd(dockablePane, lastElement, orientation);
            } else {
                boolean contentAtTheEndOfOne = false;
                for (int index = 0; index < container.getElementCount(); ++index) {
                    if (!this.isContentAtTheEnd(dockablePane, container.get(index), orientation)) continue;
                    contentAtTheEndOfOne = true;
                    break;
                }
                contentAtTheEnd = contentAtTheEndOfOne;
            }
        } else {
            contentAtTheEnd = false;
        }
        return contentAtTheEnd;
    }

    @Nullable
    protected DockableElement getPreviousVisible(@NotNull WebDockablePane dockablePane, @NotNull DockableContainer container, @NotNull DockableElement element) {
        DockableElement previousVisible = null;
        for (int i = container.indexOf(element) - 1; i >= 0; --i) {
            DockableElement sibling = container.get(i);
            if (!sibling.isVisible(dockablePane)) continue;
            previousVisible = sibling;
            break;
        }
        return previousVisible;
    }

    @Nullable
    protected DockableElement getNextVisible(@NotNull WebDockablePane dockablePane, @NotNull DockableContainer container, @NotNull DockableElement element) {
        DockableElement nextVisible = null;
        for (int i = container.indexOf(element) + 1; i < container.getElementCount(); ++i) {
            DockableElement sibling = container.get(i);
            if (!sibling.isVisible(dockablePane)) continue;
            nextVisible = sibling;
            break;
        }
        return nextVisible;
    }

    @Nullable
    protected DockableElement getFirstVisible(@NotNull WebDockablePane dockablePane, @NotNull DockableContainer container) {
        DockableElement lastVisible = null;
        for (int i = 0; i < container.getElementCount(); ++i) {
            DockableElement element = container.get(i);
            if (!element.isVisible(dockablePane)) continue;
            lastVisible = element;
            break;
        }
        return lastVisible;
    }

    @Nullable
    protected DockableElement getLastVisible(@NotNull WebDockablePane dockablePane, @NotNull DockableContainer container) {
        DockableElement lastVisible = null;
        for (int i = container.getElementCount() - 1; i >= 0; --i) {
            DockableElement element = container.get(i);
            if (!element.isVisible(dockablePane)) continue;
            lastVisible = element;
            break;
        }
        return lastVisible;
    }

    @Override
    @NotNull
    public Rectangle getFloatingBounds(@NotNull WebDockablePane dockablePane, @NotNull WebDockableFrame frame, @NotNull WebDialog dialog) {
        Rectangle previewBounds;
        DockableFrameElement element = (DockableFrameElement)this.root.get(frame.getId());
        if (element.getFloatingBounds() == null) {
            Rectangle lastBounds = element.getBounds();
            previewBounds = lastBounds != null ? lastBounds : this.getPreviewBounds(dockablePane, frame);
            Point los = CoreSwingUtils.locationOnScreen((Component)dockablePane);
            previewBounds.x += los.x;
            previewBounds.y += los.y;
        } else {
            previewBounds = new Rectangle(element.getFloatingBounds());
        }
        Insets rpi = dialog.getRootPane().getInsets();
        Insets ci = dialog.getContentPane().getInsets();
        previewBounds.x -= rpi.left + ci.left;
        previewBounds.y -= rpi.top + ci.top;
        previewBounds.width += rpi.left + ci.left + ci.right + rpi.right;
        previewBounds.height += rpi.top + ci.top + ci.bottom + rpi.bottom;
        return previewBounds;
    }

    @Override
    @Nullable
    public ResizeData getResizeData(int x, int y) {
        ResizeData resizeData = null;
        if (this.previewBounds == null || !this.previewBounds.contains(x, y)) {
            for (ResizeData area : this.resizableAreas) {
                if (!area.bounds().contains(x, y)) continue;
                resizeData = area;
                break;
            }
        }
        return resizeData;
    }
}

