/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.image.IImagePainter;
import com.alee.extended.image.WImageUI;
import com.alee.extended.image.WebImage;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ImagePainter<C extends WebImage, U extends WImageUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements IImagePainter<C, U> {
    protected transient Dimension lastDimension = null;
    protected transient BufferedImage disabledImage;
    protected transient BufferedImage lastPreviewImage = null;

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallRuntimeVariables();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"enabled")) {
            if (!this.isEnabled()) {
                this.calculateDisabledImage();
            } else {
                this.clearDisabledImage();
            }
            this.revalidate();
            this.repaint();
        } else if (Objects.equals((Object)property, (Object)"image")) {
            this.disabledImage = null;
            this.lastPreviewImage = null;
            if (!this.isEnabled()) {
                this.calculateDisabledImage();
            }
            this.revalidate();
            this.repaint();
        } else if (Objects.equals((Object)property, (Object[])new Object[]{"displayType", "horizontalAlignment", "verticalAlignment", "opacity"})) {
            this.repaint();
        }
    }

    protected void uninstallRuntimeVariables() {
        this.lastPreviewImage = null;
        this.disabledImage = null;
        this.lastDimension = null;
    }

    protected void calculateDisabledImage() {
        BufferedImage image = ((WebImage)this.component).getImage();
        this.disabledImage = image != null ? ImageUtils.createDisabledCopy((BufferedImage)image) : null;
        this.lastPreviewImage = null;
    }

    protected void clearDisabledImage() {
        if (this.disabledImage != null) {
            this.disabledImage.flush();
            this.disabledImage = null;
        }
        this.lastPreviewImage = null;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        BufferedImage currentImage;
        float opacity = ((WebImage)this.component).getOpacity();
        if (opacity > 0.0f && (currentImage = this.getCurrentImage()) != null) {
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
            Insets i = ((WebImage)this.component).getInsets();
            Dimension size = ((WebImage)this.component).getSize();
            Rectangle clip = new Rectangle(i.left, i.top, size.width - i.left - i.right, size.height - i.top - i.bottom);
            Shape ocl = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)clip);
            if (((Component)c).getSize().equals(this.getPreferredSize())) {
                g2d.drawImage((Image)currentImage, i.left, i.top, null);
            } else {
                int horizontalAlignment = ((WebImage)this.component).getHorizontalAlignment();
                int verticalAlignment = ((WebImage)this.component).getVerticalAlignment();
                switch (((WebImage)this.component).getDisplayType()) {
                    case preferred: {
                        int x;
                        int n = horizontalAlignment == 2 ? i.left : (x = horizontalAlignment == 4 ? size.width - currentImage.getWidth() - i.right : this.getCenterX(i) - currentImage.getWidth() / 2);
                        int y = verticalAlignment == 1 ? i.top : (verticalAlignment == 3 ? size.height - currentImage.getHeight() - i.bottom : this.getCenterY(i) - currentImage.getHeight() / 2);
                        g2d.drawImage((Image)currentImage, x, y, null);
                        break;
                    }
                    case fitComponent: {
                        BufferedImage preview = this.getPreviewImage(currentImage, i);
                        g2d.drawImage((Image)preview, this.getCenterX(i) - preview.getWidth() / 2, this.getCenterY(i) - preview.getHeight() / 2, null);
                        break;
                    }
                    case repeat: {
                        int x;
                        int n = horizontalAlignment == 2 ? i.left : (x = horizontalAlignment == 4 ? size.width - currentImage.getWidth() - i.right : this.getCenterX(i) - currentImage.getWidth() / 2);
                        int y = verticalAlignment == 1 ? i.top : (verticalAlignment == 3 ? size.height - currentImage.getHeight() - i.bottom : this.getCenterY(i) - currentImage.getHeight() / 2);
                        g2d.setPaint(new TexturePaint(currentImage, new Rectangle2D.Double(x, y, currentImage.getWidth(), currentImage.getHeight())));
                        g2d.fillRect(i.left, i.top, size.width - i.left - i.right, size.height - i.top - i.bottom);
                        break;
                    }
                }
            }
            GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)ocl);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        }
    }

    protected int getCenterX(@NotNull Insets insets) {
        return insets.left + (((WebImage)this.component).getWidth() - insets.left - insets.right) / 2;
    }

    protected int getCenterY(@NotNull Insets insets) {
        return insets.top + (((WebImage)this.component).getHeight() - insets.top - insets.bottom) / 2;
    }

    @NotNull
    protected BufferedImage getPreviewImage(@NotNull BufferedImage image, @NotNull Insets insets) {
        BufferedImage preview;
        Dimension size = SwingUtils.shrink(((WebImage)this.component).getSize(), insets);
        if (image.getWidth() > size.width || image.getHeight() > size.height) {
            if (this.lastPreviewImage == null || this.lastDimension != null && !this.lastDimension.equals(size)) {
                if (this.lastPreviewImage != null) {
                    this.lastPreviewImage.flush();
                    this.lastPreviewImage = null;
                }
                this.lastPreviewImage = ImageUtils.createImageThumbnail((BufferedImage)image, (Dimension)size);
                this.lastDimension = size;
            }
            preview = this.lastPreviewImage;
        } else {
            preview = image;
        }
        return preview;
    }

    @Nullable
    protected BufferedImage getCurrentImage() {
        return !this.isEnabled() && this.disabledImage != null ? this.disabledImage : ((WebImage)this.component).getImage();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Insets insets = ((WebImage)this.component).getInsets();
        BufferedImage image = this.getCurrentImage();
        return new Dimension(insets.left + (image != null ? image.getWidth() : 0) + insets.right, insets.top + (image != null ? image.getHeight() : 0) + insets.bottom);
    }
}

