/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.Resource;
import com.alee.extended.WebComponent;
import com.alee.extended.image.DisplayType;
import com.alee.extended.image.WImageUI;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;

public class WebImage
extends WebComponent<WebImage, WImageUI>
implements SwingConstants {
    public static final String IMAGE_PROPERTY = "image";
    public static final String DISPLAY_TYPE_PROPERTY = "displayType";
    public static final String HORIZONTAL_ALIGNMENT_PROPERTY = "horizontalAlignment";
    public static final String VERTICAL_ALIGNMENT_PROPERTY = "verticalAlignment";
    public static final String OPACITY_PROPERTY = "opacity";
    @Nullable
    protected BufferedImage image;
    @NotNull
    protected DisplayType displayType = DisplayType.preferred;
    protected int horizontalAlignment = 0;
    protected int verticalAlignment = 0;
    protected float opacity;

    public WebImage() {
        this(StyleId.auto);
    }

    public WebImage(@NotNull Resource resource) {
        this(StyleId.auto, resource);
    }

    public WebImage(@Nullable Icon icon) {
        this(StyleId.auto, icon);
    }

    public WebImage(@Nullable Image image) {
        this(StyleId.auto, image);
    }

    public WebImage(@Nullable RenderedImage image) {
        this(StyleId.auto, image);
    }

    public WebImage(@Nullable BufferedImage image) {
        this(StyleId.auto, image);
    }

    public WebImage(@NotNull StyleId id) {
        this(id, (BufferedImage)null);
    }

    public WebImage(@NotNull StyleId id, @NotNull Resource resource) {
        this(id, ImageUtils.loadBufferedImage((Resource)resource));
    }

    public WebImage(@NotNull StyleId id, @Nullable Icon icon) {
        this(id, ImageUtils.toBufferedImage((Icon)icon));
    }

    public WebImage(@NotNull StyleId id, @Nullable Image image) {
        this(id, ImageUtils.toBufferedImage((Image)image));
    }

    public WebImage(@NotNull StyleId id, @Nullable RenderedImage image) {
        this(id, ImageUtils.toBufferedImage((RenderedImage)image));
    }

    public WebImage(@NotNull StyleId id, @Nullable BufferedImage image) {
        this.image = image;
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.image;
    }

    @Nullable
    public BufferedImage getImage() {
        return this.image;
    }

    @Nullable
    public WebImage setImage(@Nullable Icon icon) {
        return this.setImage(ImageUtils.toBufferedImage((Icon)icon));
    }

    @Nullable
    public WebImage setImage(@Nullable ImageIcon icon) {
        return this.setImage(ImageUtils.toBufferedImage((Icon)icon));
    }

    @Nullable
    public WebImage setImage(@Nullable Image image) {
        return this.setImage(ImageUtils.toBufferedImage((Image)image));
    }

    @Nullable
    public WebImage setImage(@Nullable RenderedImage image) {
        return this.setImage(ImageUtils.toBufferedImage((RenderedImage)image));
    }

    @Nullable
    public WebImage setImage(@Nullable BufferedImage image) {
        BufferedImage old = this.image;
        this.image = image;
        this.firePropertyChange(IMAGE_PROPERTY, old, image);
        return this;
    }

    @NotNull
    public DisplayType getDisplayType() {
        return this.displayType;
    }

    @NotNull
    public WebImage setDisplayType(@NotNull DisplayType displayType) {
        DisplayType old = this.displayType;
        this.displayType = displayType;
        this.firePropertyChange(DISPLAY_TYPE_PROPERTY, (Object)old, (Object)displayType);
        return this;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @NotNull
    public WebImage setHorizontalAlignment(int horizontalAlignment) {
        int old = this.horizontalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_PROPERTY, old, horizontalAlignment);
        return this;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @NotNull
    public WebImage setVerticalAlignment(int verticalAlignment) {
        int old = this.verticalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.firePropertyChange(VERTICAL_ALIGNMENT_PROPERTY, old, verticalAlignment);
        return this;
    }

    public float getOpacity() {
        return this.opacity;
    }

    @NotNull
    public WebImage setOpacity(float opacity) {
        float old = this.opacity;
        this.opacity = opacity;
        this.firePropertyChange(OPACITY_PROPERTY, old, opacity);
        return this;
    }

    @Override
    public WImageUI getUI() {
        return (WImageUI)this.ui;
    }

    public void setUI(WImageUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

