/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.extended.inspector.ComponentInspectBehavior;
import com.alee.extended.inspector.InspectionListener;
import com.alee.extended.inspector.InterfaceTree;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.panel.GroupingType;
import com.alee.extended.tree.WebTreeFilterField;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.window.WebDialog;
import com.alee.laf.window.WebFrame;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import com.alee.utils.ProprietaryUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;

public class InterfaceInspector
extends WebPanel {
    @NotNull
    protected final InterfaceTree tree;
    @Nullable
    protected transient ComponentInspectBehavior inspectBehavior;

    public InterfaceInspector() {
        this(StyleId.inspector, null);
    }

    public InterfaceInspector(@Nullable Component inspected) {
        this(StyleId.inspector, inspected);
    }

    public InterfaceInspector(@NotNull StyleId id) {
        this(id, null);
    }

    public InterfaceInspector(@NotNull StyleId id, final @Nullable Component inspected) {
        super(id);
        WebScrollPane scrollPane = new WebScrollPane(StyleId.inspectorScroll.at(this));
        scrollPane.setPreferredWidth(300);
        this.tree = new InterfaceTree(StyleId.inspectorTree.at(scrollPane), inspected);
        scrollPane.getViewport().setView(this.tree);
        WebTreeFilterField filter = new WebTreeFilterField(StyleId.inspectorFilter.at(this), this.tree);
        final WebToggleButton inspectToggle = new WebToggleButton(StyleId.inspectorInspect.at(filter), (Icon)Icons.target);
        inspectToggle.setRolloverIcon(Icons.targetHover);
        inspectToggle.setSelectedIcon(Icons.targetSelected);
        inspectToggle.setCursor(Cursor.getDefaultCursor());
        inspectToggle.addHotkey(Hotkey.CTRL_I);
        inspectToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (inspectToggle.isSelected()) {
                    if (InterfaceInspector.this.inspectBehavior == null) {
                        InterfaceInspector.this.inspectBehavior = new ComponentInspectBehavior();
                    }
                    if (!InterfaceInspector.this.inspectBehavior.isInstalled()) {
                        InterfaceInspector.this.inspectBehavior.install(inspected, new InspectionListener(){

                            @Override
                            public void inspected(@NotNull Component component) {
                                InterfaceInspector.this.tree.navigate(component);
                                inspectToggle.setSelected(false);
                                InterfaceInspector.this.tree.requestFocusInWindow();
                            }

                            @Override
                            public void cancelled() {
                                inspectToggle.setSelected(false);
                            }
                        });
                    }
                } else if (InterfaceInspector.this.inspectBehavior != null && InterfaceInspector.this.inspectBehavior.isInstalled()) {
                    InterfaceInspector.this.inspectBehavior.uninstall();
                }
            }
        });
        filter.setTrailingComponent(inspectToggle);
        WebSeparator separator = new WebSeparator(StyleId.inspectorSeparator.at(this));
        this.add((Component)new GroupPanel(GroupingType.fillLast, 0, false, filter, separator, scrollPane));
        this.tree.expandRoot();
        new VisibilityBehavior<InterfaceInspector>(this, true){

            @Override
            protected void hidden(@NotNull InterfaceInspector inspector) {
                if (InterfaceInspector.this.inspectBehavior != null && InterfaceInspector.this.inspectBehavior.isInstalled()) {
                    InterfaceInspector.this.inspectBehavior.uninstall();
                }
            }
        }.install();
    }

    public void setInspected(@Nullable Component inspected) {
        this.tree.setRootComponent(inspected);
    }

    public void clearHighlights() {
        this.tree.clearSelection();
    }

    @NotNull
    public static WebFrame showFrame() {
        return InterfaceInspector.showFrame(null);
    }

    @NotNull
    public static WebFrame showFrame(@Nullable Component inspected) {
        WebFrame frame = new WebFrame();
        frame.setIconImages(WebLookAndFeel.getImages());
        frame.add(new InterfaceInspector(inspected));
        ProprietaryUtils.setUtilityWindowType(frame);
        frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        frame.pack();
        frame.setLocationRelativeTo(inspected);
        frame.setVisible(true);
        return frame;
    }

    @NotNull
    public static WebDialog showDialog(@Nullable Component parent) {
        return InterfaceInspector.showDialog(parent, null);
    }

    @NotNull
    public static WebDialog showDialog(@Nullable Component parent, @Nullable Component inspected) {
        WebDialog dialog = new WebDialog(parent);
        dialog.setIconImages(WebLookAndFeel.getImages());
        dialog.add(new InterfaceInspector(inspected));
        ProprietaryUtils.setUtilityWindowType(dialog);
        dialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        dialog.setModal(false);
        dialog.pack();
        dialog.setLocationRelativeTo(inspected);
        dialog.setVisible(true);
        return dialog;
    }

    @NotNull
    public static WebPopOver showPopOver(@Nullable Component parent) {
        return InterfaceInspector.showPopOver(parent, null, PopOverDirection.right);
    }

    @NotNull
    public static WebPopOver showPopOver(@Nullable Component parent, @NotNull PopOverDirection direction) {
        return InterfaceInspector.showPopOver(parent, null, direction);
    }

    @NotNull
    public static WebPopOver showPopOver(@Nullable Component parent, @Nullable Component inspected) {
        return InterfaceInspector.showPopOver(parent, inspected, PopOverDirection.right);
    }

    @NotNull
    public static WebPopOver showPopOver(@Nullable Component parent, @Nullable Component inspected, @NotNull PopOverDirection direction) {
        WebPopOver popOver = new WebPopOver(parent);
        popOver.setIconImages(WebLookAndFeel.getImages());
        popOver.add(new InterfaceInspector(StyleId.inspectorPopover, inspected));
        popOver.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        popOver.show(parent, direction);
        return popOver;
    }
}

