/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.extended.inspector.ComponentHighlighter;
import com.alee.extended.inspector.InterfaceTreeDataProvider;
import com.alee.extended.inspector.InterfaceTreeNode;
import com.alee.extended.tree.ExTreeDataProvider;
import com.alee.extended.tree.WebExTree;
import com.alee.laf.tree.TreeState;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.swing.HoverListener;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class InterfaceTree
extends WebExTree<InterfaceTreeNode>
implements HoverListener<InterfaceTreeNode>,
TreeSelectionListener,
Filter<Component> {
    @Nullable
    protected final Component root;
    @NotNull
    protected ComponentHighlighter hoverHighlighter;
    @NotNull
    protected Map<Component, ComponentHighlighter> selectedHighlighters;

    public InterfaceTree(@Nullable Component root) {
        this(StyleId.auto, root);
    }

    public InterfaceTree(@NotNull StyleId id, @Nullable Component root) {
        super(id);
        this.root = root;
        this.setVisibleRowCount(20);
        this.setDataProvider(this.createEmptyProvider());
        this.hoverHighlighter = new ComponentHighlighter();
        this.addHoverListener(this);
        this.selectedHighlighters = new HashMap<Component, ComponentHighlighter>(0);
        this.addTreeSelectionListener(this);
        this.onKeyPress(Hotkey.ESCAPE, new KeyEventRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                InterfaceTree.this.clearSelection();
            }
        });
        new VisibilityBehavior<InterfaceTree>(this, true){
            protected TreeState savedState;
            {
                this.savedState = null;
            }

            @Override
            protected void displayed(final @NotNull InterfaceTree tree) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tree.setDataProvider(InterfaceTree.this.createDataProvider());
                        tree.setTreeState(savedState);
                    }
                });
            }

            @Override
            protected void hidden(final @NotNull InterfaceTree tree) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        savedState = tree.getTreeState();
                        tree.setDataProvider(tree.createEmptyProvider());
                    }
                });
            }
        }.install();
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.interfacetree;
    }

    @Override
    public void setDataProvider(@NotNull ExTreeDataProvider dataProvider) {
        InterfaceTreeNode rootNode = (InterfaceTreeNode)this.getNullableRootNode();
        if (rootNode != null) {
            rootNode.uninstall();
        }
        super.setDataProvider(dataProvider);
    }

    @NotNull
    protected InterfaceTreeDataProvider createEmptyProvider() {
        return new InterfaceTreeDataProvider(this, new JLabel());
    }

    @NotNull
    protected InterfaceTreeDataProvider createDataProvider() {
        return new InterfaceTreeDataProvider(this, this.root);
    }

    public boolean accept(Component component) {
        InterfaceTreeDataProvider provider = (InterfaceTreeDataProvider)super.getDataProvider();
        return provider != null && provider.accept(component);
    }

    public void hoverChanged(@Nullable InterfaceTreeNode previous, final @Nullable InterfaceTreeNode current) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Component currentComponent;
                if (InterfaceTree.this.hoverHighlighter.isShowing()) {
                    InterfaceTree.this.hoverHighlighter.uninstall();
                }
                Component component = currentComponent = current != null ? (Component)current.getUserObject() : null;
                if (currentComponent != null && InterfaceTree.this.canHighlight(currentComponent)) {
                    InterfaceTree.this.hoverHighlighter.install(currentComponent);
                }
            }
        });
    }

    @Override
    public void valueChanged(@NotNull TreeSelectionEvent e) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                List selected = InterfaceTree.this.getSelectedNodes();
                Map<Component, ComponentHighlighter> prevHighlighters = InterfaceTree.this.selectedHighlighters;
                InterfaceTree.this.selectedHighlighters = new HashMap<Component, ComponentHighlighter>(selected.size());
                for (InterfaceTreeNode interfaceTreeNode : selected) {
                    Component component = (Component)interfaceTreeNode.getUserObject();
                    if (component == null) continue;
                    ComponentHighlighter prevHighlighter = prevHighlighters.get(component);
                    if (prevHighlighter != null) {
                        InterfaceTree.this.selectedHighlighters.put(component, prevHighlighter);
                        prevHighlighters.remove(component);
                        continue;
                    }
                    if (!InterfaceTree.this.canHighlight(component)) continue;
                    ComponentHighlighter newHighlighter = new ComponentHighlighter();
                    InterfaceTree.this.selectedHighlighters.put(component, newHighlighter);
                    newHighlighter.install(component);
                }
                for (Map.Entry entry : prevHighlighters.entrySet()) {
                    ((ComponentHighlighter)entry.getValue()).uninstall();
                }
            }
        });
    }

    public boolean canHighlight(@Nullable Component component) {
        return component != null && component.isShowing() && !(component instanceof Window);
    }

    @Nullable
    public Component getRootComponent() {
        ExTreeDataProvider provider = this.getDataProvider();
        return provider != null ? (Component)((InterfaceTreeNode)provider.getRoot()).getUserObject() : null;
    }

    public void setRootComponent(@Nullable Component root) {
        this.setDataProvider(new InterfaceTreeDataProvider(this, root));
    }

    public void navigate(@Nullable Component component) {
        InterfaceTreeNode node;
        InterfaceTreeNode interfaceTreeNode = node = component != null ? (InterfaceTreeNode)this.findNode(Integer.toString(component.hashCode())) : (InterfaceTreeNode)this.getRootNode();
        if (node != null) {
            this.expandNode(node);
            this.setSelectedNode(node);
            this.scrollToNode(node, true);
        }
    }

    public void expand(@Nullable Component component) {
        InterfaceTreeNode node;
        InterfaceTreeNode interfaceTreeNode = node = component != null ? (InterfaceTreeNode)this.findNode(Integer.toString(component.hashCode())) : (InterfaceTreeNode)this.getRootNode();
        if (node != null) {
            this.expandNode(node);
        }
    }
}

