/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.label.WebHotkeyLabel;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

@XStreamAlias(value="HotkeyLabelBackground")
public class HotkeyLabelBackground<C extends WebHotkeyLabel, D extends IDecoration<C, D>, I extends HotkeyLabelBackground<C, D, I>>
extends AbstractBackground<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Integer round;
    @XStreamAsAttribute
    @Nullable
    protected Color border;
    @XStreamAsAttribute
    @Nullable
    protected Color spacing;
    @XStreamAsAttribute
    @Nullable
    protected Color color;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "hotkey-background";
    }

    protected int getRound(@NotNull C c, @NotNull D d) {
        if (this.round == null) {
            throw new DecorationException("Shape round must be specified");
        }
        return this.round;
    }

    @NotNull
    protected Color getBorderColor(@NotNull C c, @NotNull D d) {
        if (this.border == null) {
            throw new DecorationException("Border color must be specified");
        }
        return this.border;
    }

    @NotNull
    protected Color getSpacingColor(@NotNull C c, @NotNull D d) {
        if (this.spacing == null) {
            throw new DecorationException("Spacing color must be specified");
        }
        return this.spacing;
    }

    @NotNull
    protected Color getBackgroundColor(@NotNull C c, @NotNull D d) {
        if (this.color == null) {
            throw new DecorationException("Background color must be specified");
        }
        return this.color;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        int round = this.getRound(c, d);
        g2d.setPaint(this.getSpacingColor(c, d));
        g2d.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height - 1, round, round);
        g2d.setPaint(this.getBackgroundColor(c, d));
        g2d.fillRect(bounds.x + 3, bounds.y + 3, bounds.width - 6, bounds.height - 7);
        g2d.setPaint(this.getBorderColor(c, d));
        g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 2, round, round);
        g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, round, round);
    }
}

