/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.label.CustomStyle;
import com.alee.extended.label.IStyleSettings;
import com.alee.extended.label.StyleRange;
import com.alee.utils.xml.ColorConverter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StyleSettings
implements IStyleSettings {
    protected final int startIndex;
    protected final int length;
    @NotNull
    protected final String settings;

    public StyleSettings(int startIndex, int length, @NotNull String settings) {
        this.startIndex = startIndex;
        this.length = length;
        this.settings = settings;
    }

    @Override
    @Nullable
    public StyleRange getStyleRange() {
        StyleRange styleRange;
        boolean p = false;
        boolean b = false;
        boolean i = false;
        Color fg = null;
        Color bg = null;
        ArrayList<CustomStyle> customStyles = new ArrayList<CustomStyle>();
        StringTokenizer st = new StringTokenizer(this.settings, ";", false);
        while (st.hasMoreTokens()) {
            Color color;
            String token = st.nextToken();
            if (token.equals("p") || token.equals("plain")) {
                p = true;
                continue;
            }
            if (token.equals("b") || token.equals("bold")) {
                b = true;
                continue;
            }
            if (token.equals("i") || token.equals("italic")) {
                i = true;
                continue;
            }
            if (token.equals("u") || token.equals("underlined")) {
                customStyles.add(CustomStyle.underlined);
                continue;
            }
            if (token.equals("w") || token.equals("waved")) {
                customStyles.add(CustomStyle.waved);
                continue;
            }
            if (token.equals("s") || token.equals("strike")) {
                customStyles.add(CustomStyle.strikeThrough);
                continue;
            }
            if (token.equals("ds") || token.equals("doublestrike")) {
                customStyles.add(CustomStyle.doubleStrikeThrough);
                continue;
            }
            if (token.equals("sp") || token.equals("sup") || token.equals("superscript")) {
                customStyles.add(CustomStyle.superscript);
                continue;
            }
            if (token.equals("sb") || token.equals("sub") || token.equals("subscript")) {
                customStyles.add(CustomStyle.subscript);
                continue;
            }
            if (token.startsWith("c") || token.startsWith("color") || token.startsWith("fg") || token.startsWith("foreground")) {
                color = this.parseColor(token);
                if (color == null) continue;
                fg = color;
                continue;
            }
            if (!token.startsWith("bg") && !token.startsWith("background") || (color = this.parseColor(token)) == null) continue;
            bg = color;
        }
        if (p || b || i || fg != null || bg != null || customStyles.size() > 0) {
            int style = b && i ? 3 : (b ? 1 : (i ? 2 : (p ? 0 : -1)));
            CustomStyle[] cs = customStyles.toArray(new CustomStyle[customStyles.size()]);
            styleRange = new StyleRange(this.startIndex, this.length, style, fg, bg, cs);
        } else {
            styleRange = null;
        }
        return styleRange;
    }

    @Nullable
    protected Color parseColor(@NotNull String statement) {
        Color color = null;
        int i1 = statement.indexOf("(");
        int i2 = statement.lastIndexOf(")");
        if (i1 != -1 && i2 != -1) {
            try {
                String colorString = statement.substring(i1 + 1, i2);
                color = ColorConverter.colorFromString((String)colorString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return color;
    }
}

