/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.TextRange;
import com.alee.utils.TextUtils;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public class StyledTextRow {
    @NotNull
    public final List<TextRange> fragments = new ArrayList<TextRange>();
    public final boolean leading;
    public int width;
    public int height;
    public int mnemonic;

    public StyledTextRow(int height, boolean leading) {
        this.leading = leading;
        this.width = 0;
        this.height = height;
        this.mnemonic = -1;
    }

    public int append(@NotNull String text, @Nullable StyleRange style, @NotNull FontMetrics fm, int charOffset, int mnemonicIndex) {
        int sWidth = 0;
        if (mnemonicIndex >= 0 && text.length() > mnemonicIndex - charOffset) {
            this.mnemonic = mnemonicIndex - charOffset;
            for (TextRange fragment : this.fragments) {
                this.mnemonic += fragment.text.length();
            }
        }
        if (this.fragments.isEmpty() && !this.leading) {
            int fw = TextUtils.findFirstWordFromIndex((String)text, (int)0);
            if (fw >= 0) {
                String trimmed = text.substring(fw);
                this.fragments.add(new TextRange(trimmed, style));
                if (this.mnemonic > 0) {
                    this.mnemonic -= fw;
                }
                sWidth += fm.stringWidth(trimmed);
            } else {
                if (this.mnemonic > 0) {
                    this.mnemonic -= text.length();
                }
                this.fragments.add(new TextRange("", style));
            }
        } else {
            this.fragments.add(new TextRange(text, style));
            sWidth += fm.stringWidth(text);
        }
        this.width += sWidth;
        return sWidth;
    }

    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    public boolean isLeading() {
        return this.leading;
    }
}

