/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.label.IStyleRanges;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyleRanges;
import com.alee.extended.label.TextWrap;
import com.alee.extended.label.WStyledLabelUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LM;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.tooltip.ToolTipMethods;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.EventMethods;
import com.alee.utils.swing.extensions.EventMethodsImpl;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.FontMethods;
import com.alee.utils.swing.extensions.FontMethodsImpl;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class WebStyledLabel
extends JLabel
implements Styleable,
EventMethods,
ToolTipMethods,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
FontMethods<WebStyledLabel>,
SizeMethods<WebStyledLabel> {
    public static final String STYLE_RANGES_PROPERTY = "styleRanges";
    public static final String WRAP_PROPERTY = "wrap";
    public static final String ROWS_PROPERTY = "rows";
    public static final String MAXIMUM_ROWS_PROPERTY = "maximumRows";
    public static final String MINIMUM_ROWS_PROPERTY = "minimumRows";
    public static final String MAXIMUM_TEXT_WIDTH_PROPERTY = "maximumTextWidth";
    public static final String HORIZONTAL_TEXT_ALIGNMENT_PROPERTY = "horizontalTextAlignment";
    public static final String VERTICAL_TEXT_ALIGNMENT_PROPERTY = "verticalTextAlignment";
    protected List<StyleRange> styleRanges;
    protected TextWrap wrap;
    protected int horizontalTextAlignment;
    protected int verticalTextAlignment;
    protected int rows;
    protected int maximumRows;
    protected int minimumRows;
    protected int maximumTextWidth;

    public WebStyledLabel() {
        this(StyleId.auto);
    }

    public WebStyledLabel(int horizontalAlignment) {
        this(StyleId.auto, horizontalAlignment);
    }

    public WebStyledLabel(Icon icon) {
        this(StyleId.auto, icon);
    }

    public WebStyledLabel(Icon icon, int horizontalAlignment) {
        this(StyleId.auto, icon, horizontalAlignment);
    }

    public WebStyledLabel(String text) {
        this(StyleId.auto, text);
    }

    public WebStyledLabel(String text, int horizontalAlignment, Object ... data) {
        this(StyleId.auto, text, horizontalAlignment, data);
    }

    public WebStyledLabel(String text, Icon icon) {
        this(StyleId.auto, text, icon);
    }

    public WebStyledLabel(String text, Icon icon, int horizontalAlignment, Object ... data) {
        this(StyleId.auto, text, icon, horizontalAlignment, data);
    }

    public WebStyledLabel(StyleId id) {
        this(id, null, null, 10, LM.emptyData);
    }

    public WebStyledLabel(StyleId id, int horizontalAlignment) {
        this(id, null, null, horizontalAlignment, LM.emptyData);
    }

    public WebStyledLabel(StyleId id, Icon icon) {
        this(id, null, icon, 10, LM.emptyData);
    }

    public WebStyledLabel(StyleId id, Icon icon, int horizontalAlignment) {
        this(id, null, icon, horizontalAlignment, LM.emptyData);
    }

    public WebStyledLabel(StyleId id, String text) {
        this(id, text, null, 10, new Object[0]);
    }

    public WebStyledLabel(StyleId id, String text, int horizontalAlignment, Object ... data) {
        this(id, text, null, horizontalAlignment, data);
    }

    public WebStyledLabel(StyleId id, String text, Icon icon) {
        this(id, text, icon, 10, new Object[0]);
    }

    public WebStyledLabel(StyleId id, String text, Icon icon, int horizontalAlignment, Object ... data) {
        super(UILanguageManager.getInitialText(text, data), icon, horizontalAlignment);
        UILanguageManager.registerInitialLanguage(this, text, data);
        this.setWrap(TextWrap.mixed);
        this.setHorizontalTextAlignment(-1);
        this.setVerticalTextAlignment(0);
        this.setRows(0);
        this.setMinimumRows(0);
        this.setMaximumRows(0);
        this.setMaximumTextWidth(Short.MAX_VALUE);
        this.setStyleId(id);
    }

    @Override
    public void setText(@Nullable String text) {
        IStyleRanges styleRanges = this.getStyleRanges(text);
        super.setText(styleRanges.getPlainText());
        this.setStyleRanges(styleRanges.getStyleRanges());
    }

    @NotNull
    protected IStyleRanges getStyleRanges(@Nullable String text) {
        return new StyleRanges(text);
    }

    @NotNull
    public List<StyleRange> getStyleRanges() {
        return CollectionUtils.copy(this.getStyleRangesImpl());
    }

    public void addStyleRange(@NotNull StyleRange styleRange) {
        this.addStyleRangeImpl(styleRange);
        this.firePropertyChange(STYLE_RANGES_PROPERTY, null, styleRange);
    }

    public void addStyleRanges(@Nullable List<StyleRange> styleRanges) {
        this.addStyleRangesImpl(styleRanges);
        this.firePropertyChange(STYLE_RANGES_PROPERTY, null, styleRanges);
    }

    public void removeStyleRange(@NotNull StyleRange styleRange) {
        this.removeStyleRangeImpl(styleRange);
        this.firePropertyChange(STYLE_RANGES_PROPERTY, styleRange, null);
    }

    public void removeStyleRanges(@Nullable List<StyleRange> styleRanges) {
        this.removeStyleRangesImpl(styleRanges);
        this.firePropertyChange(STYLE_RANGES_PROPERTY, styleRanges, null);
    }

    public void setStyleRanges(@Nullable List<StyleRange> styleRanges) {
        this.clearStyleRangesImpl();
        this.addStyleRangesImpl(styleRanges);
        this.firePropertyChange(STYLE_RANGES_PROPERTY, null, styleRanges);
    }

    public void clearStyleRanges() {
        this.clearStyleRangesImpl();
        this.firePropertyChange(STYLE_RANGES_PROPERTY, null, null);
    }

    @NotNull
    protected List<StyleRange> getStyleRangesImpl() {
        if (this.styleRanges == null) {
            this.styleRanges = new ArrayList<StyleRange>(3);
        }
        return this.styleRanges;
    }

    protected void addStyleRangeImpl(@NotNull StyleRange styleRange) {
        this.getStyleRangesImpl().add(styleRange);
    }

    protected void addStyleRangesImpl(@Nullable List<StyleRange> styleRanges) {
        if (CollectionUtils.notEmpty(styleRanges)) {
            for (StyleRange styleRange : styleRanges) {
                this.addStyleRangeImpl(styleRange);
            }
        }
    }

    protected void removeStyleRangeImpl(@NotNull StyleRange styleRange) {
        if (!this.getStyleRangesImpl().remove(styleRange)) {
            Iterator<StyleRange> iterator = this.getStyleRangesImpl().iterator();
            while (iterator.hasNext()) {
                StyleRange range = iterator.next();
                if (range.getStartIndex() != styleRange.getStartIndex() || range.getLength() != styleRange.getLength()) continue;
                iterator.remove();
            }
        }
    }

    protected void removeStyleRangesImpl(@Nullable List<StyleRange> styleRanges) {
        if (CollectionUtils.notEmpty(styleRanges)) {
            for (StyleRange styleRange : styleRanges) {
                this.removeStyleRangeImpl(styleRange);
            }
        }
    }

    protected void clearStyleRangesImpl() {
        this.getStyleRangesImpl().clear();
    }

    @NotNull
    public TextWrap getWrap() {
        return this.wrap != null ? this.wrap : TextWrap.none;
    }

    public void setWrap(@Nullable TextWrap wrap) {
        TextWrap old = this.wrap;
        this.wrap = wrap;
        this.firePropertyChange(WRAP_PROPERTY, (Object)old, (Object)wrap);
    }

    public int getHorizontalTextAlignment() {
        return this.horizontalTextAlignment != -1 ? this.horizontalTextAlignment : this.getHorizontalAlignment();
    }

    public void setHorizontalTextAlignment(int alignment) {
        int old = this.horizontalTextAlignment;
        this.horizontalTextAlignment = alignment;
        this.firePropertyChange(HORIZONTAL_TEXT_ALIGNMENT_PROPERTY, old, alignment);
    }

    public int getVerticalTextAlignment() {
        return this.verticalTextAlignment != -1 ? this.verticalTextAlignment : this.getVerticalAlignment();
    }

    public void setVerticalTextAlignment(int alignment) {
        int old = this.verticalTextAlignment;
        this.verticalTextAlignment = alignment;
        this.firePropertyChange(VERTICAL_TEXT_ALIGNMENT_PROPERTY, old, alignment);
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        int old = this.rows;
        this.rows = rows;
        this.firePropertyChange(ROWS_PROPERTY, old, rows);
    }

    public int getMaximumRows() {
        return this.maximumRows;
    }

    public void setMaximumRows(int maximumRows) {
        int old = this.maximumRows;
        this.maximumRows = maximumRows;
        this.firePropertyChange(MAXIMUM_ROWS_PROPERTY, old, maximumRows);
    }

    public int getMinimumRows() {
        return this.minimumRows;
    }

    public void setMinimumRows(int minimumRows) {
        int old = this.minimumRows;
        this.minimumRows = minimumRows;
        this.firePropertyChange(MINIMUM_ROWS_PROPERTY, old, minimumRows);
    }

    public int getMaximumTextWidth() {
        return this.maximumTextWidth;
    }

    public void setMaximumTextWidth(int maximumTextWidth) {
        int old = this.maximumTextWidth;
        this.maximumTextWidth = maximumTextWidth;
        this.firePropertyChange(MAXIMUM_TEXT_WIDTH_PROPERTY, old, maximumTextWidth);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.styledlabel;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this);
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this, id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this);
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this);
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this);
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this);
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this);
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this, enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this);
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this, top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this);
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this, top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseEnter(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseEnter(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseExit(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseExit(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDoubleClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDoubleClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMenuTrigger(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMenuTrigger(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusGain(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusGain(this, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusLoss(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusLoss(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, mouseButton, runnable);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip) {
        return TooltipManager.setTooltip((JComponent)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip) {
        return TooltipManager.setTooltip((JComponent)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((JComponent)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip) {
        return TooltipManager.setTooltip((JComponent)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, int delay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip) {
        return TooltipManager.addTooltip((JComponent)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip) {
        return TooltipManager.addTooltip((JComponent)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((JComponent)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((JComponent)this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip) {
        return TooltipManager.addTooltip((JComponent)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, int delay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, tooltipWay, delay);
    }

    @Override
    public void removeToolTip(WebCustomTooltip tooltip) {
        TooltipManager.removeTooltip(this, tooltip);
    }

    @Override
    public void removeToolTips() {
        TooltipManager.removeTooltips(this);
    }

    @Override
    public void removeToolTips(WebCustomTooltip ... tooltips) {
        TooltipManager.removeTooltips((JComponent)this, tooltips);
    }

    @Override
    public void removeToolTips(List<WebCustomTooltip> tooltips) {
        TooltipManager.removeTooltips((JComponent)this, tooltips);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this);
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this.getRootPane());
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this.getRootPane());
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    @Override
    public WebStyledLabel setPlainFont() {
        return (WebStyledLabel)FontMethodsImpl.setPlainFont(this);
    }

    @Override
    public WebStyledLabel setPlainFont(boolean apply) {
        return (WebStyledLabel)FontMethodsImpl.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return FontMethodsImpl.isPlainFont(this);
    }

    @Override
    public WebStyledLabel setBoldFont() {
        return (WebStyledLabel)FontMethodsImpl.setBoldFont(this);
    }

    @Override
    public WebStyledLabel setBoldFont(boolean apply) {
        return (WebStyledLabel)FontMethodsImpl.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return FontMethodsImpl.isBoldFont(this);
    }

    @Override
    public WebStyledLabel setItalicFont() {
        return (WebStyledLabel)FontMethodsImpl.setItalicFont(this);
    }

    @Override
    public WebStyledLabel setItalicFont(boolean apply) {
        return (WebStyledLabel)FontMethodsImpl.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return FontMethodsImpl.isItalicFont(this);
    }

    @Override
    public WebStyledLabel setFontStyle(boolean bold, boolean italic) {
        return (WebStyledLabel)FontMethodsImpl.setFontStyle(this, bold, italic);
    }

    @Override
    public WebStyledLabel setFontStyle(int style) {
        return (WebStyledLabel)FontMethodsImpl.setFontStyle(this, style);
    }

    @Override
    public WebStyledLabel setFontSize(int fontSize) {
        return (WebStyledLabel)FontMethodsImpl.setFontSize(this, fontSize);
    }

    @Override
    public WebStyledLabel changeFontSize(int change) {
        return (WebStyledLabel)FontMethodsImpl.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return FontMethodsImpl.getFontSize(this);
    }

    @Override
    public WebStyledLabel setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return (WebStyledLabel)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebStyledLabel setFontSizeAndStyle(int fontSize, int style) {
        return (WebStyledLabel)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebStyledLabel setFontName(String fontName) {
        return (WebStyledLabel)FontMethodsImpl.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return FontMethodsImpl.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebStyledLabel setPreferredWidth(int preferredWidth) {
        return (WebStyledLabel)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebStyledLabel setPreferredHeight(int preferredHeight) {
        return (WebStyledLabel)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public WebStyledLabel setPreferredSize(int width, int height) {
        return (WebStyledLabel)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebStyledLabel setMaximumWidth(int maximumWidth) {
        return (WebStyledLabel)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebStyledLabel setMaximumHeight(int maximumHeight) {
        return (WebStyledLabel)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, this.getWrap() != TextWrap.none ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, this.getWrap() != TextWrap.none ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebStyledLabel setMaximumSize(int width, int height) {
        return (WebStyledLabel)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebStyledLabel setMinimumWidth(int minimumWidth) {
        return (WebStyledLabel)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebStyledLabel setMinimumHeight(int minimumHeight) {
        return (WebStyledLabel)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, this.getWrap() != TextWrap.none ? new Dimension(1, 1) : super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, this.getWrap() != TextWrap.none ? new Dimension(1, 1) : super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebStyledLabel setMinimumSize(int width, int height) {
        return (WebStyledLabel)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    @Override
    public WStyledLabelUI getUI() {
        return (WStyledLabelUI)super.getUI();
    }

    public void setUI(WStyledLabelUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

