/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.api.annotations.NotNull;
import com.alee.extended.language.DictionariesTree;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Value;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DictionariesTransferHandler
extends TransferHandler {
    private final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};
    private final DictionariesTree tree;

    public static void install(DictionariesTree tree) {
        tree.setTransferHandler(new DictionariesTransferHandler(tree));
    }

    public DictionariesTransferHandler(DictionariesTree tree) {
        this.tree = tree;
        tree.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    DictionariesTransferHandler.this.exportAsDrag(DictionariesTransferHandler.this.tree, e, SwingUtils.isCtrl(e) ? 1 : 2);
                }
            }
        });
    }

    public DictionariesTree getTree() {
        return this.tree;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        Transferable transferable;
        Object object = this.tree.getSelectedValue();
        if (object != null) {
            final String xml = XmlUtils.toXML((Object)object);
            transferable = new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return DictionariesTransferHandler.this.flavors;
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.equals(DataFlavor.stringFlavor);
                }

                @Override
                @NotNull
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                    if (this.isDataFlavorSupported(flavor)) {
                        return xml;
                    }
                    throw new UnsupportedFlavorException(flavor);
                }
            };
        } else {
            transferable = null;
        }
        return transferable;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        try {
            Point dp = info.getDropLocation().getDropPoint();
            TreePath dropPath = this.tree.getPathForLocation(dp.x, dp.y);
            DefaultMutableTreeNode dropLocation = (DefaultMutableTreeNode)dropPath.getLastPathComponent();
            Object dlo = dropLocation.getUserObject();
            String xml = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
            Object droppedObject = XmlUtils.fromXML((String)xml);
            if (dlo == null && droppedObject instanceof Dictionary) {
                return true;
            }
            if (dlo instanceof Dictionary && (droppedObject instanceof Dictionary || droppedObject instanceof Record)) {
                return true;
            }
            if (dlo instanceof Record && droppedObject instanceof Value) {
                return true;
            }
            return dlo instanceof Value && droppedObject instanceof Text;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        try {
            Point dp = info.getDropLocation().getDropPoint();
            TreePath dropPath = this.tree.getPathForLocation(dp.x, dp.y);
            DefaultMutableTreeNode dropLocation = (DefaultMutableTreeNode)dropPath.getLastPathComponent();
            Object dlo = dropLocation.getUserObject();
            String xml = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
            Object droppedObject = XmlUtils.fromXML((String)xml);
            if (dlo == null) {
                if (droppedObject instanceof Dictionary) {
                    Dictionary dictionary = (Dictionary)droppedObject;
                    DefaultMutableTreeNode dn = this.tree.createDictionaryNode(dictionary);
                    this.tree.getActualModel().insertNodeInto(dn, dropLocation, dropLocation.getChildCount());
                    this.tree.selectAndShow(dn);
                    return true;
                }
                return false;
            }
            if (dlo instanceof Dictionary) {
                Dictionary dropTo = (Dictionary)dlo;
                if (droppedObject instanceof Dictionary) {
                    Dictionary dictionary = (Dictionary)droppedObject;
                    dropTo.addDictionary(dictionary);
                    DefaultMutableTreeNode dn = this.tree.createDictionaryNode(dictionary);
                    this.tree.getActualModel().insertNodeInto(dn, dropLocation, dropLocation.getChildCount());
                    this.tree.selectAndShow(dn);
                    return true;
                }
                if (droppedObject instanceof Record) {
                    Record record = (Record)droppedObject;
                    dropTo.addRecord(record);
                    DefaultMutableTreeNode rn = this.tree.createRecordNode(record);
                    this.tree.getActualModel().insertNodeInto(rn, dropLocation, dropLocation.getChildCount());
                    this.tree.selectAndShow(rn);
                    return true;
                }
                return false;
            }
            if (dlo instanceof Record) {
                if (droppedObject instanceof Value) {
                    Value value = (Value)droppedObject;
                    ((Record)dlo).addValue(value);
                    DefaultMutableTreeNode vn = this.tree.createValueNode(value);
                    this.tree.getActualModel().insertNodeInto(vn, dropLocation, dropLocation.getChildCount());
                    this.tree.selectAndShow(vn);
                    return true;
                }
                return false;
            }
            if (dlo instanceof Value) {
                Value dropTo = (Value)dlo;
                if (droppedObject instanceof Text) {
                    Text text = (Text)droppedObject;
                    dropTo.addText(text);
                    DefaultMutableTreeNode tn = this.tree.createTextNode(text);
                    this.tree.getActualModel().insertNodeInto(tn, dropLocation, dropLocation.getChildCount());
                    this.tree.selectAndShow(tn);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

