/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.api.annotations.NotNull;
import com.alee.extended.language.LanguageChooserModel;
import com.alee.extended.language.LanguageChooserRenderer;
import com.alee.laf.combobox.WebComboBox;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.collection.ImmutableList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.ComboBoxModel;

public class LanguageChooser
extends WebComboBox {
    public LanguageChooser() {
        this(StyleId.auto);
    }

    public LanguageChooser(Locale ... locales) {
        this(StyleId.auto, locales);
    }

    public LanguageChooser(Collection<Locale> locales) {
        this(StyleId.auto, locales);
    }

    public LanguageChooser(LanguageChooserModel model) {
        this(StyleId.auto, model);
    }

    public LanguageChooser(StyleId id) {
        this(id, new LanguageChooserModel());
    }

    public LanguageChooser(StyleId id, Locale ... locales) {
        this(id, new LanguageChooserModel(locales));
    }

    public LanguageChooser(StyleId id, Collection<Locale> locales) {
        this(id, new LanguageChooserModel(locales));
    }

    public LanguageChooser(StyleId id, LanguageChooserModel model) {
        super(id, model);
        this.setRenderer(new LanguageChooserRenderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoreSwingUtils.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Locale locale = (Locale)LanguageChooser.this.getSelectedItem();
                        if (locale != null) {
                            LanguageManager.setLocale((Locale)locale);
                        }
                    }
                });
            }
        });
    }

    public LanguageChooserModel getModel() {
        return (LanguageChooserModel)super.getModel();
    }

    public void setModel(ComboBoxModel model) {
        if (!(model instanceof LanguageChooserModel)) {
            throw new IllegalArgumentException("Only LanguageChooserModel instances are allowed");
        }
        if (this.dataModel != null) {
            this.removeLanguageListener((LanguageChooserModel)this.dataModel);
            this.removeDictionaryListener((LanguageChooserModel)this.dataModel);
        }
        super.setModel(model);
        this.addLanguageListener((LanguageChooserModel)model);
        this.addDictionaryListener((LanguageChooserModel)model);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.languagechooser;
    }

    public List<Locale> getLocales() {
        return this.getModel().getLocales();
    }

    public void setLocales(Locale ... locales) {
        this.setLocales((Collection<Locale>)new ImmutableList((Object[])locales));
    }

    public void setLocales(Collection<Locale> locales) {
        this.getModel().setLocales(locales);
    }
}

