/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class CompactFlowLayout
extends FlowLayout {
    public CompactFlowLayout() {
    }

    public CompactFlowLayout(int align) {
        super(align);
    }

    public CompactFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension ps = super.preferredLayoutSize(container);
            ps.width -= this.getHgap() * 2;
            ps.height -= this.getVgap() * 2;
            return ps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension ms = super.minimumLayoutSize(container);
            ms.width -= this.getHgap() * 2;
            ms.height -= this.getVgap() * 2;
            return ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int maxwidth = container.getWidth() - (insets.left + insets.right);
            int nmembers = container.getComponentCount();
            int x = 0;
            int y = insets.top;
            int rowh = 0;
            int start = 0;
            boolean ltr = container.getComponentOrientation().isLeftToRight();
            boolean useBaseline = this.getAlignOnBaseline();
            int[] ascent = null;
            int[] descent = null;
            if (useBaseline) {
                ascent = new int[nmembers];
                descent = new int[nmembers];
            }
            for (int i = 0; i < nmembers; ++i) {
                Component m = container.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (useBaseline) {
                    int baseline = m.getBaseline(d.width, d.height);
                    if (baseline >= 0) {
                        ascent[i] = baseline;
                        descent[i] = d.height - baseline;
                    } else {
                        ascent[i] = -1;
                    }
                }
                if (x == 0 || x + d.width + (x > 0 ? this.getHgap() : 0) <= maxwidth) {
                    if (x > 0) {
                        x += this.getHgap();
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                rowh = this.moveComponents(container, insets.left, y, maxwidth - x, rowh, start, i, ltr, useBaseline, ascent, descent);
                x = d.width;
                y += this.getVgap() + rowh;
                rowh = d.height;
                start = i;
            }
            this.moveComponents(container, insets.left, y, maxwidth - x, rowh, start, nmembers, ltr, useBaseline, ascent, descent);
        }
    }

    protected int moveComponents(Container container, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr, boolean useBaseline, int[] ascent, int[] descent) {
        switch (this.getAlignment()) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        int maxAscent = 0;
        int nonbaselineHeight = 0;
        int baselineOffset = 0;
        if (useBaseline) {
            int maxDescent = 0;
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = container.getComponent(i);
                if (!m.isVisible()) continue;
                if (ascent[i] >= 0) {
                    maxAscent = Math.max(maxAscent, ascent[i]);
                    maxDescent = Math.max(maxDescent, descent[i]);
                    continue;
                }
                nonbaselineHeight = Math.max(m.getHeight(), nonbaselineHeight);
            }
            height = Math.max(maxAscent + maxDescent, nonbaselineHeight);
            baselineOffset = (height - maxAscent - maxDescent) / 2;
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = container.getComponent(i);
            if (!m.isVisible()) continue;
            int cy = useBaseline && ascent[i] >= 0 ? y + baselineOffset + maxAscent - ascent[i] : y + (height - m.getHeight()) / 2;
            if (ltr) {
                m.setLocation(x, cy);
            } else {
                m.setLocation(container.getWidth() - x - m.getWidth(), cy);
            }
            x += m.getWidth() + this.getHgap();
        }
        return height;
    }
}

