/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.Orientation;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class GroupLayout
extends AbstractLayoutManager {
    public static final String PREFERRED = "PREFERRED";
    public static final String FILL = "FILL";
    protected Orientation orientation;
    protected int gap;
    protected final Map<Component, String> constraints;

    public GroupLayout() {
        this(Orientation.horizontal, 0);
    }

    public GroupLayout(Orientation orientation) {
        this(orientation, 0);
    }

    public GroupLayout(Orientation orientation, int gap) {
        this.orientation = orientation;
        this.gap = gap;
        this.constraints = new HashMap<Component, String>();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        this.constraints.put(component, (String)constraints);
    }

    @Override
    public void removeComponent(@NotNull Component component) {
        this.constraints.remove(component);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        int fillCount = 0;
        int preferred = 0;
        for (Component component : container.getComponents()) {
            boolean fill = this.isFill(component);
            if (fill) {
                ++fillCount;
            }
            if (this.orientation.isHorizontal()) {
                preferred += fill ? 0 : component.getPreferredSize().width;
                continue;
            }
            preferred += fill ? 0 : component.getPreferredSize().height;
        }
        if (container.getComponentCount() > 0) {
            preferred += this.gap * (container.getComponentCount() - 1);
        }
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        Insets insets = container.getInsets();
        Dimension size = container.getSize();
        int width = size.width - insets.left - insets.right;
        int height = size.height - insets.top - insets.bottom;
        int fillSize = this.orientation.isHorizontal() ? (fillCount > 0 && width > preferred ? (width - preferred) / fillCount : 0) : (fillCount > 0 && height > preferred ? (height - preferred) / fillCount : 0);
        int x = ltr || this.orientation.isVertical() ? insets.left : size.width - insets.right;
        int y = insets.top;
        for (Component component : container.getComponents()) {
            Dimension cps = component.getPreferredSize();
            boolean fill = this.isFill(component);
            if (this.orientation.isHorizontal()) {
                int w = fill ? fillSize : cps.width;
                component.setBounds(x - (ltr ? 0 : w), y, w, height);
                x += (ltr ? 1 : -1) * (w + this.gap);
                continue;
            }
            int h = fill ? fillSize : cps.height;
            component.setBounds(x, y, width, h);
            y += h + this.gap;
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        return this.getLayoutSize(container, false);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        return this.getLayoutSize(container, true);
    }

    protected Dimension getLayoutSize(Container container, boolean minimum) {
        Insets insets = container.getInsets();
        Dimension ps = new Dimension();
        for (Component component : container.getComponents()) {
            boolean ignoreSize;
            Dimension cps = minimum ? component.getMinimumSize() : component.getPreferredSize();
            boolean bl = ignoreSize = minimum && this.isFill(component);
            if (this.orientation.isHorizontal()) {
                ps.width = ps.width + (ignoreSize ? 1 : cps.width);
                ps.height = Math.max(ps.height, cps.height);
                continue;
            }
            ps.width = Math.max(ps.width, cps.width);
            ps.height = ps.height + (ignoreSize ? 1 : cps.height);
        }
        if (container.getComponentCount() > 0) {
            if (this.orientation.isHorizontal()) {
                ps.width += this.gap * (container.getComponentCount() - 1);
            } else {
                ps.height += this.gap * (container.getComponentCount() - 1);
            }
        }
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    protected boolean isFill(Component component) {
        String constraint;
        boolean fill = this.constraints.containsKey(component) ? (constraint = this.constraints.get(component)) != null && constraint.equals(FILL) : false;
        return fill;
    }
}

