/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class HorizontalFlowLayout
extends AbstractLayoutManager {
    protected int hgap;
    protected boolean fillLast;

    public HorizontalFlowLayout() {
        this(2);
    }

    public HorizontalFlowLayout(int hgap) {
        this(hgap, false);
    }

    public HorizontalFlowLayout(int hgap, boolean fillLast) {
        this.hgap = hgap;
        this.fillLast = fillLast;
    }

    public int getHorizontalGap() {
        return this.hgap;
    }

    public void setHorizontalGap(int hgap) {
        this.hgap = hgap;
    }

    public boolean isFillLast() {
        return this.fillLast;
    }

    public void setFillLast(boolean fill) {
        this.fillLast = fill;
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Dimension required = this.preferredLayoutSize(container);
        Dimension available = new Dimension(required.width, container.getSize().height);
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        Insets insets = container.getInsets();
        int ls = ltr ? insets.left : insets.right;
        int rs = ltr ? insets.right : insets.left;
        boolean min = required.width < available.width;
        int x = ls;
        int y = insets.top;
        int height = Math.max(available.height, required.height) - insets.top - insets.bottom;
        int xsWidth = available.width - required.width;
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            int width;
            int w;
            Component c = container.getComponent(i);
            if (!c.isVisible()) continue;
            int n = w = min ? c.getMinimumSize().width : c.getPreferredSize().width;
            if (xsWidth > 0) {
                w += w * xsWidth / required.width;
            }
            int n2 = width = this.fillLast && i == count - 1 && container.getWidth() - x - rs > 0 ? container.getWidth() - x - rs : w;
            if (ltr) {
                c.setBounds(x, y, width, height);
            } else {
                c.setBounds(container.getWidth() - x - width, y, width, height);
            }
            x += w + this.getHorizontalGap();
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        return this.getLayoutSize(container, false);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        return this.getLayoutSize(container, true);
    }

    protected Dimension getLayoutSize(Container container, boolean minimum) {
        Dimension size = new Dimension(0, 0);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component c = container.getComponent(i);
            if (!c.isVisible()) continue;
            Dimension tmp = minimum ? c.getMinimumSize() : c.getPreferredSize();
            size.width += tmp.width;
            if (i > 0) {
                size.width += this.getHorizontalGap();
            }
            size.height = Math.max(tmp.height, size.height);
        }
        Insets border = container.getInsets();
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }
}

