/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.lazy;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.extended.lazy.DataLoadProgress;
import com.alee.extended.lazy.LazyContentListener;
import com.alee.extended.lazy.LazyDataLoadProgress;
import com.alee.extended.lazy.LazyLoadTrigger;
import com.alee.extended.lazy.LazyProgressOverlay;
import com.alee.extended.lazy.LazyState;
import com.alee.extended.lazy.LazyStateListener;
import com.alee.extended.lazy.ProgressCallback;
import com.alee.extended.syntax.SyntaxPreset;
import com.alee.extended.syntax.WebSyntaxArea;
import com.alee.extended.syntax.WebSyntaxScrollPane;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.label.WebLabel;
import com.alee.managers.style.StyleId;
import com.alee.managers.task.TaskManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ExceptionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public abstract class LazyContent<D, C extends JComponent> {
    @NotNull
    protected final JComponent container;
    @Nullable
    protected final Object constraints;
    @NotNull
    protected final LazyLoadTrigger dataTrigger;
    @NotNull
    protected final LazyLoadTrigger uiTrigger;
    @NotNull
    protected final EventListenerList listeners;
    @Nullable
    protected VisibilityBehavior<JComponent> onDisplayBehavior;
    @NotNull
    protected LazyState dataState;
    @NotNull
    protected LazyState uiState;
    @Nullable
    protected D data;
    @Nullable
    protected Throwable dataCause;
    @Nullable
    protected JComponent content;
    protected int contentIndex;
    @Nullable
    protected Throwable contentCause;

    public LazyContent(@NotNull JComponent container, @Nullable Object constraints, @NotNull LazyLoadTrigger trigger) {
        this(container, constraints, trigger, trigger);
    }

    public LazyContent(@NotNull JComponent container, @Nullable Object constraints, @NotNull LazyLoadTrigger dataTrigger, @NotNull LazyLoadTrigger uiTrigger) {
        WebLookAndFeel.checkEventDispatchThread();
        this.container = container;
        this.constraints = constraints;
        this.dataTrigger = dataTrigger;
        this.uiTrigger = uiTrigger;
        this.listeners = new EventListenerList();
        this.dataState = LazyState.awaiting;
        this.uiState = LazyState.awaiting;
        JComponent initialComponent = this.createInitialComponent();
        if (initialComponent != null) {
            this.content = initialComponent;
            this.container.add((Component)initialComponent, constraints);
            this.contentIndex = this.container.getComponentZOrder(initialComponent);
        } else {
            this.content = null;
            this.contentIndex = -1;
        }
        if (this.dataTrigger == LazyLoadTrigger.onInit) {
            this.queueDataLoading(false);
        } else if (this.dataTrigger == LazyLoadTrigger.onDisplay) {
            this.onDisplayBehavior = new VisibilityBehavior<JComponent>(this.container, true){

                @Override
                protected void displayed(@NotNull JComponent component) {
                    LazyContent.this.queueDataLoading(false);
                }
            };
            this.onDisplayBehavior.install();
        }
    }

    @NotNull
    public LazyState getDataState() {
        return this.dataState;
    }

    protected void setDataState(@NotNull LazyState state) {
        WebLookAndFeel.checkEventDispatchThread();
        LazyState old = this.dataState;
        this.dataState = state;
        this.fireDataStateChanged(old, state);
    }

    @NotNull
    public LazyState getUIState() {
        return this.uiState;
    }

    protected void setUIState(@NotNull LazyState state) {
        WebLookAndFeel.checkEventDispatchThread();
        LazyState old = this.uiState;
        this.uiState = state;
        this.fireUIStateChanged(old, state);
    }

    public void reload() {
        CoreSwingUtils.invokeOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (LazyContent.this.dataState != LazyState.queued && LazyContent.this.dataState != LazyState.loading && LazyContent.this.uiState != LazyState.queued && LazyContent.this.uiState != LazyState.loading) {
                    if (LazyContent.this.dataState == LazyState.awaiting || LazyContent.this.dataState == LazyState.failed || LazyContent.this.dataState == LazyState.loaded && LazyContent.this.uiState == LazyState.loaded) {
                        LazyContent.this.queueDataLoading(true);
                    } else if (LazyContent.this.dataState == LazyState.loaded && (LazyContent.this.uiState == LazyState.awaiting || LazyContent.this.uiState == LazyState.failed)) {
                        LazyContent.this.queueUILoading(true);
                    }
                }
            }
        });
    }

    protected void queueDataLoading(final boolean forced) {
        WebLookAndFeel.checkEventDispatchThread();
        LazyState dataState = this.getDataState();
        if (dataState == LazyState.awaiting || forced && (dataState == LazyState.loaded || dataState == LazyState.failed)) {
            if (this.onDisplayBehavior != null) {
                this.onDisplayBehavior.uninstall();
                this.onDisplayBehavior = null;
            }
            this.setDataState(LazyState.queued);
            this.setUIState(forced || this.uiTrigger == LazyLoadTrigger.onInit || this.uiTrigger == LazyLoadTrigger.onDisplay && this.container.isShowing() ? LazyState.queued : LazyState.awaiting);
            final LazyDataLoadProgress<D> progress = this.createDataLoadProgress();
            this.setCurrentContent(this.createProgressComponent(progress));
            TaskManager.execute((String)this.getTaskGroupId(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LazyContent.this.setDataState(LazyState.loading);
                                progress.fireLoadingStarted();
                            }
                        });
                        final Object data = LazyContent.this.loadData(progress);
                        LazyContent.this.data = data;
                        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LazyContent.this.setDataState(LazyState.loaded);
                                progress.fireLoaded(data);
                                LazyContent.this.fireDataLoaded(data);
                                if (forced || LazyContent.this.uiState == LazyState.queued) {
                                    LazyContent.this.queueUILoading(forced);
                                } else if (LazyContent.this.uiTrigger == LazyLoadTrigger.onDisplay) {
                                    LazyContent.this.onDisplayBehavior = new VisibilityBehavior<JComponent>(LazyContent.this.container, true){

                                        @Override
                                        protected void displayed(@NotNull JComponent component) {
                                            LazyContent.this.queueUILoading(false);
                                        }
                                    };
                                    LazyContent.this.onDisplayBehavior.install();
                                }
                            }
                        });
                    }
                    catch (Throwable cause) {
                        LazyContent.this.dataCause = cause;
                        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LazyContent.this.setDataState(LazyState.failed);
                                LazyContent.this.setUIState(LazyState.awaiting);
                                progress.fireFailed(cause);
                                LazyContent.this.setCurrentContent(LazyContent.this.createExceptionComponent(LazyContent.this.dataCause));
                                LazyContent.this.fireDataFailed(LazyContent.this.dataCause);
                            }
                        });
                    }
                }
            });
        }
    }

    protected void queueUILoading(boolean forced) {
        WebLookAndFeel.checkEventDispatchThread();
        LazyState dataState = this.getDataState();
        if (dataState == LazyState.loaded) {
            LazyState uiState;
            if (this.onDisplayBehavior != null) {
                this.onDisplayBehavior.uninstall();
                this.onDisplayBehavior = null;
            }
            if ((uiState = this.getUIState()) == LazyState.awaiting || uiState == LazyState.queued || forced && (uiState == LazyState.loaded || uiState == LazyState.failed)) {
                this.setUIState(LazyState.loading);
                CoreSwingUtils.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object content = LazyContent.this.loadUI(LazyContent.this.data);
                            LazyContent.this.setCurrentContent((JComponent)content);
                            LazyContent.this.setUIState(LazyState.loaded);
                            LazyContent.this.fireUILoaded(LazyContent.this.data, content);
                        }
                        catch (Throwable cause) {
                            LazyContent.this.contentCause = cause;
                            LazyContent.this.setUIState(LazyState.failed);
                            LazyContent.this.setCurrentContent(LazyContent.this.createExceptionComponent(LazyContent.this.contentCause));
                            LazyContent.this.fireUIFailed(LazyContent.this.data, LazyContent.this.contentCause);
                        }
                        finally {
                            LazyContent.this.data = null;
                        }
                    }
                });
            }
        } else {
            this.queueDataLoading(forced);
        }
    }

    protected void setCurrentContent(@NotNull JComponent content) {
        this.removeCurrentContent();
        this.content = content;
        this.container.add(content, this.constraints, this.contentIndex);
        SwingUtils.update(this.container);
    }

    protected void removeCurrentContent() {
        WebLookAndFeel.checkEventDispatchThread();
        if (this.content != null && this.content.getParent() == this.container) {
            this.contentIndex = this.container.getComponentZOrder(this.content);
            this.container.remove(this.content);
        }
    }

    @NotNull
    protected abstract String getTaskGroupId();

    @Nullable
    protected JComponent createInitialComponent() {
        return null;
    }

    @NotNull
    protected LazyDataLoadProgress<D> createDataLoadProgress() {
        return new LazyDataLoadProgress();
    }

    @NotNull
    protected JComponent createProgressComponent(@NotNull DataLoadProgress<D> progress) {
        return new LazyProgressOverlay<D>(progress);
    }

    @NotNull
    protected JComponent createExceptionComponent(final @NotNull Throwable cause) {
        String message = TextUtils.shortenText((String)cause.getMessage(), (int)100, (boolean)true);
        final WebLabel component = new WebLabel(message, 0, new Object[0]);
        component.onMousePress(MouseButton.left, new MouseEventRunnable(){

            @Override
            public void run(@NotNull MouseEvent event) {
                WebPopOver info = new WebPopOver(component);
                info.setCloseOnFocusLoss(true);
                WebSyntaxArea area = new WebSyntaxArea(ExceptionUtils.getStackTrace((Throwable)cause), 12, 60, new SyntaxPreset[0]);
                area.applyPresets(SyntaxPreset.base, SyntaxPreset.viewable, SyntaxPreset.hideMenu, SyntaxPreset.ideaTheme, SyntaxPreset.nonOpaque);
                info.add((Component)((Object)new WebSyntaxScrollPane(StyleId.syntaxareaScrollUndecorated, area, false)));
                info.show((Component)component, PopOverDirection.down, PopOverAlignment.centered);
            }
        });
        return component;
    }

    @Nullable
    protected abstract D loadData(@NotNull ProgressCallback var1);

    @NotNull
    protected abstract C loadUI(@Nullable D var1);

    public void addLazyContentStateListener(@NotNull LazyStateListener listener) {
        this.listeners.add(LazyStateListener.class, listener);
    }

    public void removeLazyContentStateListener(@NotNull LazyStateListener listener) {
        this.listeners.remove(LazyStateListener.class, listener);
    }

    public void fireDataStateChanged(@NotNull LazyState oldState, @NotNull LazyState newState) {
        for (LazyStateListener listener : (LazyStateListener[])this.listeners.getListeners(LazyStateListener.class)) {
            listener.dataStateChanged(oldState, newState);
        }
    }

    public void fireUIStateChanged(@NotNull LazyState oldState, @NotNull LazyState newState) {
        for (LazyStateListener listener : (LazyStateListener[])this.listeners.getListeners(LazyStateListener.class)) {
            listener.uiStateChanged(oldState, newState);
        }
    }

    public void addLazyContentListener(@NotNull LazyContentListener<D, C> listener) {
        this.listeners.add(LazyContentListener.class, listener);
    }

    public void removeLazyContentListener(@NotNull LazyContentListener<D, C> listener) {
        this.listeners.remove(LazyContentListener.class, listener);
    }

    public void fireDataLoaded(@Nullable D data) {
        for (LazyContentListener listener : (LazyContentListener[])this.listeners.getListeners(LazyContentListener.class)) {
            listener.dataLoaded(data);
        }
    }

    public void fireDataFailed(@NotNull Throwable cause) {
        for (LazyContentListener listener : (LazyContentListener[])this.listeners.getListeners(LazyContentListener.class)) {
            listener.dataFailed(cause);
        }
    }

    public void fireUILoaded(@Nullable D data, @NotNull C component) {
        for (LazyContentListener listener : (LazyContentListener[])this.listeners.getListeners(LazyContentListener.class)) {
            listener.uiLoaded(data, component);
        }
    }

    public void fireUIFailed(@Nullable D data, @NotNull Throwable cause) {
        for (LazyContentListener listener : (LazyContentListener[])this.listeners.getListeners(LazyContentListener.class)) {
            listener.uiFailed(data, cause);
        }
    }
}

