/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.overlay;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.WebContainer;
import com.alee.extended.overlay.Overlay;
import com.alee.extended.overlay.OverlayLayout;
import com.alee.extended.overlay.WOverlayUI;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ProprietaryUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class WebOverlay
extends WebContainer<WebOverlay, WOverlayUI> {
    public static final String CONTENT_PROPERTY = "content";
    @Nullable
    protected JComponent content;
    @NotNull
    protected List<Overlay> overlays = new ArrayList<Overlay>();

    public WebOverlay() {
        this(StyleId.auto);
    }

    public WebOverlay(@Nullable JComponent content) {
        this(StyleId.auto, content);
    }

    public WebOverlay(@NotNull StyleId id) {
        this(id, null);
    }

    public WebOverlay(@NotNull StyleId id, @Nullable JComponent content) {
        ProprietaryUtils.enableMixingCutoutShape(this);
        this.updateUI();
        this.setStyleId(id);
        this.setContent(content);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.overlay;
    }

    @Override
    @Nullable
    public OverlayLayout getLayout() {
        return (OverlayLayout)super.getLayout();
    }

    @Override
    public void setLayout(@Nullable LayoutManager layout) {
        if (layout != null && !(layout instanceof OverlayLayout)) {
            throw new IllegalArgumentException("Only OverlayLayout instances are supported");
        }
        super.setLayout(layout);
    }

    @Override
    @NotNull
    public JComponent getComponent(int index) {
        return (JComponent)super.getComponent(index);
    }

    @Nullable
    public JComponent getContent() {
        return this.content;
    }

    public void setContent(@Nullable JComponent content) {
        this.add((Component)content);
    }

    @Override
    protected void addImpl(@Nullable Component component, @Nullable Object constraints, int index) {
        if (component == null || component instanceof JComponent) {
            boolean contentBeingAdded = component == null || this.findOverlay((JComponent)component) == null;
            JComponent oldContent = this.content;
            if (contentBeingAdded && oldContent != null) {
                int contentIndex = this.getComponentZOrder(oldContent);
                super.remove(contentIndex);
            }
            if (component != null) {
                super.addImpl(component, constraints, index);
            }
            if (contentBeingAdded) {
                this.content = (JComponent)component;
                this.firePropertyChange(CONTENT_PROPERTY, oldContent, component);
            }
        } else {
            throw new RuntimeException("WebOverlay doesn't support AWT components");
        }
    }

    @Override
    public void remove(int index) {
        JComponent component = this.getComponent(index);
        Overlay overlay = this.findOverlay(component);
        if (overlay != null) {
            this.overlays.remove(overlay);
        }
        super.remove(index);
        if (overlay == null) {
            this.content = null;
            this.firePropertyChange(CONTENT_PROPERTY, component, null);
        }
    }

    public int getOverlayCount() {
        return this.overlays.size();
    }

    @NotNull
    public List<Overlay> getOverlays() {
        return CollectionUtils.copy(this.overlays);
    }

    public void addOverlay(@NotNull Overlay overlay) {
        this.removeOverlay(overlay);
        this.overlays.add(overlay);
        this.add((Component)overlay.component());
        this.revalidate();
        this.repaint();
    }

    public void removeOverlay(@NotNull JComponent component) {
        this.remove((Component)component);
        this.revalidate();
        this.repaint();
    }

    public void removeOverlay(@NotNull Overlay overlay) {
        this.remove((Component)overlay.component());
        this.revalidate();
        this.repaint();
    }

    @Nullable
    public Overlay findOverlay(@NotNull JComponent component) {
        Overlay result = null;
        for (Overlay overlay : this.overlays) {
            if (overlay.component() != component) continue;
            result = overlay;
            break;
        }
        return result;
    }

    @Override
    public WOverlayUI getUI() {
        return (WOverlayUI)this.ui;
    }

    public void setUI(WOverlayUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

