/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.progress;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.progress.StepData;
import com.alee.extended.progress.StepSelectionMode;
import com.alee.extended.progress.WebStepProgressStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebStepProgress
extends JComponent
implements SwingConstants,
SizeMethods<WebStepProgress> {
    protected Insets margin = WebStepProgressStyle.margin;
    protected int shadeWidth = WebStepProgressStyle.shadeWidth;
    protected int stepControlWidth = WebStepProgressStyle.stepControlWidth;
    protected int stepControlRound = WebStepProgressStyle.stepControlRound;
    protected int stepControlFillWidth = WebStepProgressStyle.stepControlFillWidth;
    protected int stepControlFillRound = WebStepProgressStyle.stepControlFillRound;
    protected int pathWidth = WebStepProgressStyle.pathWidth;
    protected int pathFillWidth = WebStepProgressStyle.pathFillWidth;
    protected Color progressColor = WebStepProgressStyle.progressColor;
    protected Color disabledProgressColor = WebStepProgressStyle.disabledProgressColor;
    protected boolean displayLabels = WebStepProgressStyle.displayLabels;
    protected int orientation = WebStepProgressStyle.orientation;
    protected int labelsPosition = WebStepProgressStyle.labelsPosition;
    protected int spacing = WebStepProgressStyle.spacing;
    protected int stepsSpacing = WebStepProgressStyle.stepsSpacing;
    protected boolean selectionEnabled = WebStepProgressStyle.selectionEnabled;
    protected StepSelectionMode selectionMode = WebStepProgressStyle.selectionMode;
    protected final List<StepData> steps = new ArrayList<StepData>();
    protected int selectedStep = 0;
    protected float progress = 0.0f;
    protected boolean selecting = false;
    protected int sideWidth = 0;
    protected Shape borderShape;
    protected LinearGradientPaint fillPaint;
    protected Shape fillShape;

    public WebStepProgress() {
        this(Collections.EMPTY_LIST);
    }

    public WebStepProgress(int amount) {
        this(WebStepProgress.createDefaultData(amount));
    }

    public WebStepProgress(String ... names) {
        this(WebStepProgress.createSteps(names));
    }

    public WebStepProgress(Component ... labels) {
        this(WebStepProgress.createSteps(labels));
    }

    public WebStepProgress(StepData ... steps) {
        this(CollectionUtils.asList((Object[])steps));
    }

    public WebStepProgress(List<StepData> steps) {
        this.setSteps(steps);
        this.setLayout(new ProgressLayout());
        ProgressMouseAdapter pma = new ProgressMouseAdapter();
        this.addMouseListener(pma);
        this.addMouseMotionListener(pma);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WebStepProgress.this.updateShapes();
            }
        });
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.revalidate();
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int spacing) {
        this.setMargin(spacing, spacing, spacing, spacing);
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.revalidate();
    }

    public int getStepControlWidth() {
        return this.stepControlWidth;
    }

    public void setStepControlWidth(int width) {
        this.stepControlWidth = width;
        this.revalidate();
    }

    public int getStepControlRound() {
        return this.stepControlRound;
    }

    public void setStepControlRound(int round) {
        this.stepControlRound = round;
        this.repaint();
    }

    public int getStepControlFillWidth() {
        return this.stepControlFillWidth;
    }

    public void setStepControlFillWidth(int width) {
        this.stepControlFillWidth = width;
        this.revalidate();
    }

    public int getStepControlFillRound() {
        return this.stepControlFillRound;
    }

    public void setStepControlFillRound(int round) {
        this.stepControlFillRound = round;
        this.repaint();
    }

    public int getPathWidth() {
        return this.pathWidth;
    }

    public void setPathWidth(int width) {
        this.pathWidth = width;
        this.revalidate();
    }

    public int getPathFillWidth() {
        return this.pathFillWidth;
    }

    public void setPathFillWidth(int width) {
        this.pathFillWidth = width;
        this.revalidate();
    }

    public Color getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(Color color) {
        this.progressColor = color;
        this.repaint();
    }

    public Color getDisabledProgressColor() {
        return this.disabledProgressColor;
    }

    public void setDisabledProgressColor(Color color) {
        this.disabledProgressColor = color;
        this.repaint();
    }

    public boolean isDisplayLabels() {
        return this.displayLabels;
    }

    public void setDisplayLabels(boolean displayLabels) {
        if (this.displayLabels != displayLabels) {
            this.displayLabels = displayLabels;
            if (displayLabels) {
                for (StepData step : this.steps) {
                    if (step.getLabel() == null) continue;
                    this.add(step.getLabel());
                }
            } else {
                for (StepData step : this.steps) {
                    if (step.getLabel() == null) continue;
                    this.remove(step.getLabel());
                }
            }
            this.revalidate();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.revalidate();
    }

    public int getLabelsPosition() {
        return this.labelsPosition;
    }

    public void setLabelsPosition(int position) {
        this.labelsPosition = position;
        this.revalidate();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.revalidate();
    }

    public int getStepsSpacing() {
        return this.stepsSpacing;
    }

    public void setStepsSpacing(int spacing) {
        this.stepsSpacing = spacing;
        this.revalidate();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean enabled) {
        this.selectionEnabled = enabled;
    }

    public StepSelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(StepSelectionMode mode) {
        this.selectionMode = mode;
    }

    public int getStepsAmount() {
        return this.steps.size();
    }

    public List<StepData> getSteps() {
        return CollectionUtils.copy(this.steps);
    }

    public StepData getStep(int index) {
        return this.steps.get(index);
    }

    public void setSteps(String ... names) {
        this.setSteps(WebStepProgress.createSteps(names));
    }

    public void setSteps(Component ... labels) {
        this.setSteps(WebStepProgress.createSteps(labels));
    }

    public void setSteps(List<StepData> steps) {
        this.clearSteps();
        this.addSteps(steps);
    }

    public void addSteps(String ... steps) {
        if (steps != null) {
            this.addSteps(WebStepProgress.createSteps(steps));
        }
    }

    public void addSteps(Component ... steps) {
        if (steps != null) {
            this.addSteps(WebStepProgress.createSteps(steps));
        }
    }

    public void addSteps(List<StepData> steps) {
        if (steps != null) {
            this.steps.addAll(steps);
            if (this.displayLabels) {
                for (StepData step : steps) {
                    if (step.getLabel() == null) continue;
                    this.add(step.getLabel());
                }
                this.revalidate();
            }
            this.validateSelectedStep();
        }
    }

    public void removeStep(int index) {
        this.removeStep(this.getStep(index));
    }

    public void removeStep(StepData stepData) {
        this.clearStep(stepData);
        this.revalidate();
    }

    public void setSteps(int amount) {
        this.clearSteps();
        this.addSteps(WebStepProgress.createDefaultData(amount));
        this.revalidate();
    }

    protected void clearSteps() {
        if (this.steps.size() > 0) {
            for (StepData step : CollectionUtils.copy(this.steps)) {
                this.clearStep(step);
            }
        }
    }

    protected void clearStep(StepData step) {
        Component label;
        if (this.displayLabels && (label = step.getLabel()) != null) {
            label.getParent().remove(label);
        }
        this.steps.remove(step);
        this.validateSelectedStep();
    }

    public StepData getSelectedStep() {
        return this.steps.get(this.getSelectedStepIndex());
    }

    public void setSelectedStep(StepData step) {
        this.setSelectedStepIndex(this.steps.indexOf(step));
    }

    public int getSelectedStepIndex() {
        return this.selectedStep;
    }

    public void setSelectedStepIndex(int index) {
        if (index == this.selectedStep) {
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= this.steps.size()) {
            index = this.steps.size() - 1;
        }
        this.selectedStep = index;
        this.progress = 0.0f;
        this.updateFillShape();
    }

    protected void validateSelectedStep() {
        if (this.selectedStep >= this.getStepsAmount()) {
            this.setSelectedStepIndex(this.getStepsAmount() - 1);
        }
        if (this.selectedStep < 0 && this.getStepsAmount() > 0) {
            this.setSelectedStepIndex(0);
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        if (progress == this.progress) {
            return;
        }
        if (progress < 0.0f) {
            float p = Math.abs(progress);
            int s = this.selectedStep - Math.round(p - p % 1.0f) - 1;
            progress = s < 0 ? 0.0f : 1.0f - p % 1.0f;
            this.setSelectedStepIndex(s);
        } else if (progress >= 1.0f) {
            int s = this.selectedStep + Math.round(progress - progress % 1.0f);
            progress = s >= this.steps.size() ? 0.0f : progress % 1.0f;
            this.setSelectedStepIndex(s);
        }
        this.progress = progress;
        this.updateFillShape();
    }

    public float getTotalProgress() {
        return ((float)this.selectedStep + this.progress) / (float)(this.steps.size() - 1);
    }

    public float getTotalProgressAt(Point point) {
        boolean hor = this.orientation == 0;
        Point p1 = this.getPathStart();
        Point p2 = this.getPathEnd();
        float pw = this.getPathLength();
        if (hor) {
            if (this.getComponentOrientation().isLeftToRight()) {
                if (point.x < p1.x) {
                    return 0.0f;
                }
                if (point.x > p2.x) {
                    return this.steps.size() - 1;
                }
                return (float)((this.steps.size() - 1) * (point.x - p1.x)) / pw;
            }
            if (point.x > p1.x) {
                return 0.0f;
            }
            if (point.x < p2.x) {
                return this.steps.size() - 1;
            }
            return (float)(this.steps.size() - 1) * (pw - (float)(point.x - p2.x)) / pw;
        }
        if (point.y < p1.y) {
            return 0.0f;
        }
        if (point.y > p2.y) {
            return this.steps.size() - 1;
        }
        return (float)((this.steps.size() - 1) * (point.y - p1.y)) / pw;
    }

    public void setTotalProgress(float progress) {
        progress = (float)(this.steps.size() - 1) * progress;
        this.setSelectedStepIndex(Math.round(progress - progress % 1.0f));
        this.setProgress(progress % 1.0f);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Shape shape = this.getBorderShape();
        if (this.isEnabled()) {
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)shape, (Color)new Color(210, 210, 210), (int)this.shadeWidth);
        }
        Rectangle shapeBounds = shape.getBounds();
        g2d.setPaint(new GradientPaint(0.0f, shapeBounds.y, Color.WHITE, 0.0f, shapeBounds.y + shapeBounds.height, new Color(223, 223, 223)));
        g2d.fill(shape);
        g2d.setPaint(this.isEnabled() ? Color.GRAY : Color.LIGHT_GRAY);
        g2d.draw(shape);
        g2d.setPaint(this.getFillPaint());
        g2d.fill(this.getProgressShape());
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected void updateBorderShape() {
        this.borderShape = null;
        this.repaint();
    }

    protected void updateFillShape() {
        this.fillPaint = null;
        this.fillShape = null;
        this.repaint();
    }

    protected void updateShapes() {
        this.borderShape = null;
        this.fillPaint = null;
        this.fillShape = null;
        this.repaint();
    }

    protected Shape getBorderShape() {
        if (this.borderShape == null) {
            this.borderShape = this.createBorderShape();
        }
        return this.borderShape;
    }

    protected Shape createBorderShape() {
        Area border = new Area(this.getPathShape());
        for (int i = 0; i < this.steps.size(); ++i) {
            border.add(new Area(this.getStepBorderShape(i)));
        }
        return border;
    }

    protected Shape getStepBorderShape(int step) {
        Point center = this.getStepCenter(step);
        if (this.stepControlRound * 2 >= this.stepControlWidth) {
            return new Ellipse2D.Double(center.x - this.stepControlWidth / 2, center.y - this.stepControlWidth / 2, this.stepControlWidth, this.stepControlWidth);
        }
        return new RoundRectangle2D.Double(center.x - this.stepControlWidth / 2, center.y - this.stepControlWidth / 2, this.stepControlWidth, this.stepControlWidth, this.stepControlRound * 2, this.stepControlRound * 2);
    }

    protected LinearGradientPaint getFillPaint() {
        if (this.fillPaint == null) {
            this.fillPaint = this.createFillPaint();
        }
        return this.fillPaint;
    }

    protected LinearGradientPaint createFillPaint() {
        Color color;
        Point p1 = this.getPathStart();
        float tss = (float)this.selectedStep + this.progress;
        int midSteps = this.steps.size() - 1;
        int sw = midSteps > 0 ? this.getPathLength() / midSteps : 0;
        float pw = (float)this.stepControlFillWidth * 1.5f + (float)sw * tss;
        Color color2 = color = this.isEnabled() ? this.progressColor : this.disabledProgressColor;
        if (this.orientation == 0) {
            Color[] colorArray;
            float[] fArray;
            float px;
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            float f = px = ltr ? (float)(p1.x - this.stepControlFillWidth / 2) : (float)(p1.x + this.stepControlFillWidth / 2) - pw;
            if (ltr) {
                float[] fArray2 = new float[3];
                fArray2[0] = 0.0f;
                fArray2[1] = ((float)this.stepControlFillWidth + (float)sw * tss) / pw;
                fArray = fArray2;
                fArray2[2] = 1.0f;
            } else {
                float[] fArray3 = new float[3];
                fArray3[0] = 0.0f;
                fArray3[1] = 1.0f - ((float)this.stepControlFillWidth + (float)sw * tss) / pw;
                fArray = fArray3;
                fArray3[2] = 1.0f;
            }
            float[] fractions = fArray;
            if (ltr) {
                Color[] colorArray2 = new Color[3];
                colorArray2[0] = color;
                colorArray2[1] = color;
                colorArray = colorArray2;
                colorArray2[2] = ColorUtils.transparent();
            } else {
                Color[] colorArray3 = new Color[3];
                colorArray3[0] = ColorUtils.transparent();
                colorArray3[1] = color;
                colorArray = colorArray3;
                colorArray3[2] = color;
            }
            Color[] colors = colorArray;
            return new LinearGradientPaint(px, 0.0f, px + pw, 0.0f, fractions, colors);
        }
        float py = p1.y - this.stepControlFillWidth / 2;
        return new LinearGradientPaint(0.0f, py, 0.0f, py + pw, new float[]{0.0f, ((float)this.stepControlFillWidth + (float)sw * tss) / pw, 1.0f}, new Color[]{color, color, ColorUtils.transparent()});
    }

    protected Shape getProgressShape() {
        if (this.fillShape == null) {
            this.fillShape = this.createFillShape();
        }
        return this.fillShape;
    }

    protected Shape createFillShape() {
        Area border = new Area(this.getPathFillShape());
        for (int i = 0; i < this.steps.size(); ++i) {
            border.add(new Area(this.getStepFillShape(i)));
        }
        return border;
    }

    protected Shape getStepFillShape(int step) {
        Point center = this.getStepCenter(step);
        if (this.stepControlFillRound * 2 >= this.stepControlFillWidth) {
            return new Ellipse2D.Double(center.x - this.stepControlFillWidth / 2, center.y - this.stepControlFillWidth / 2, this.stepControlFillWidth, this.stepControlFillWidth);
        }
        return new RoundRectangle2D.Double(center.x - this.stepControlFillWidth / 2, center.y - this.stepControlFillWidth / 2, this.stepControlFillWidth, this.stepControlFillWidth, this.stepControlFillRound * 2, this.stepControlFillRound * 2);
    }

    protected Shape getPathShape() {
        Point p1 = this.getPathStart();
        Point p2 = this.getPathEnd();
        if (this.orientation == 0) {
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            return new Rectangle2D.Double(ltr ? (double)p1.x : (double)p2.x, (float)p1.y - (float)this.pathWidth / 2.0f, ltr ? (double)(p2.x - p1.x) : (double)(p1.x - p2.x), this.pathWidth);
        }
        return new Rectangle2D.Double((float)p1.x - (float)this.pathWidth / 2.0f, p1.y, this.pathWidth, p2.y - p1.y);
    }

    protected Shape getPathFillShape() {
        Point p1 = this.getPathStart();
        Point p2 = this.getPathEnd();
        if (this.orientation == 0) {
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            return new Rectangle2D.Double(ltr ? (double)p1.x : (double)p2.x, (float)p1.y + 0.5f - (float)this.pathFillWidth / 2.0f, ltr ? (double)(p2.x - p1.x) : (double)(p1.x - p2.x), this.pathFillWidth);
        }
        return new Rectangle2D.Double((float)p1.x + 0.5f - (float)this.pathFillWidth / 2.0f, p1.y, this.pathFillWidth, p2.y - p1.y);
    }

    protected Point getPathStart() {
        return this.getStepCenter(0);
    }

    protected Point getPathEnd() {
        return this.getStepCenter(this.steps.size() - 1);
    }

    protected Point getStepCenter(int step) {
        Dimension max = this.getActualLayout().getMaximumComponentSize();
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        int midSteps = this.steps.size() - 1;
        if (this.orientation == 0) {
            int pathPart = midSteps > 0 ? this.getPathLength() * (ltr ? step : midSteps - step) / midSteps : 0;
            int x = this.margin.left + this.sideWidth + pathPart;
            int wh = this.getHeight() - this.margin.top - this.margin.bottom;
            int sh = max.height + (max.height > 0 ? this.spacing : 0);
            int ch = sh + this.stepControlWidth + this.shadeWidth * 2;
            boolean lead = this.labelsPosition == 10;
            int y = this.margin.top + wh / 2 - ch / 2 + (lead ? sh : 0) + this.shadeWidth + this.stepControlWidth / 2;
            return new Point(x, y);
        }
        int pathPart = midSteps > 0 ? this.getPathLength() * step / midSteps : 0;
        int y = this.margin.top + this.sideWidth + pathPart;
        int ww = this.getWidth() - this.margin.left - this.margin.right;
        int sw = max.width + (max.width > 0 ? this.spacing : 0);
        int cw = sw + this.stepControlWidth + this.shadeWidth * 2;
        boolean lead = ltr ? this.labelsPosition == 10 : this.labelsPosition == 11;
        int x = this.margin.left + ww / 2 - cw / 2 + (lead ? sw : 0) + this.shadeWidth + this.stepControlWidth / 2;
        return new Point(x, y);
    }

    protected int getPathLength() {
        return this.orientation == 0 ? this.getWidth() - this.sideWidth * 2 - this.margin.left - this.margin.right - 1 : this.getHeight() - this.sideWidth * 2 - this.margin.top - this.margin.bottom - 1;
    }

    public int getStepShapeIndexAt(Point point) {
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!this.getStepBorderShape(i).contains(point)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebStepProgress setPreferredWidth(int preferredWidth) {
        return (WebStepProgress)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebStepProgress setPreferredHeight(int preferredHeight) {
        return (WebStepProgress)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public WebStepProgress setPreferredSize(int width, int height) {
        return (WebStepProgress)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebStepProgress setMaximumWidth(int maximumWidth) {
        return (WebStepProgress)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebStepProgress setMaximumHeight(int maximumHeight) {
        return (WebStepProgress)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebStepProgress setMaximumSize(int width, int height) {
        return (WebStepProgress)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebStepProgress setMinimumWidth(int minimumWidth) {
        return (WebStepProgress)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebStepProgress setMinimumHeight(int minimumHeight) {
        return (WebStepProgress)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebStepProgress setMinimumSize(int width, int height) {
        return (WebStepProgress)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    public ProgressLayout getActualLayout() {
        return (ProgressLayout)this.getLayout();
    }

    public static List<StepData> createSteps(String ... names) {
        ArrayList<StepData> s = new ArrayList<StepData>();
        for (String step : names) {
            s.add(new StepData(step));
        }
        return s;
    }

    public static List<StepData> createSteps(Component ... labels) {
        ArrayList<StepData> s = new ArrayList<StepData>();
        for (Component step : labels) {
            s.add(new StepData(step));
        }
        return s;
    }

    public static List<StepData> createDefaultData(int amount) {
        ArrayList<StepData> s = new ArrayList<StepData>(amount);
        for (int i = 0; i < amount; ++i) {
            s.add(new StepData());
        }
        return s;
    }

    protected class ProgressLayout
    extends AbstractLayoutManager {
        protected ProgressLayout() {
        }

        @Override
        public void layoutContainer(@NotNull Container container) {
            boolean ltr = WebStepProgress.this.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < WebStepProgress.this.steps.size(); ++i) {
                int x;
                Component label = WebStepProgress.this.getStep(i).getLabel();
                if (label == null) continue;
                Point sc = WebStepProgress.this.getStepCenter(i);
                Dimension ps = label.getPreferredSize();
                if (WebStepProgress.this.orientation == 0) {
                    int y;
                    int x2 = sc.x - ps.width / 2;
                    if (WebStepProgress.this.labelsPosition == 1 || WebStepProgress.this.labelsPosition == 10) {
                        y = sc.y - WebStepProgress.this.stepControlWidth / 2 - WebStepProgress.this.shadeWidth - WebStepProgress.this.spacing - ps.height;
                        label.setBounds(x2, y, ps.width, ps.height);
                        continue;
                    }
                    y = sc.y + WebStepProgress.this.stepControlWidth / 2 + WebStepProgress.this.shadeWidth + WebStepProgress.this.spacing;
                    label.setBounds(x2, y, ps.width, ps.height);
                    continue;
                }
                int y = sc.y - ps.height / 2;
                if (WebStepProgress.this.labelsPosition == 2 || ltr && WebStepProgress.this.labelsPosition == 10 || !ltr && WebStepProgress.this.labelsPosition == 11) {
                    x = sc.x - WebStepProgress.this.stepControlWidth / 2 - WebStepProgress.this.shadeWidth - WebStepProgress.this.spacing - ps.width;
                    label.setBounds(x, y, ps.width, ps.height);
                    continue;
                }
                x = sc.x + WebStepProgress.this.stepControlWidth / 2 + WebStepProgress.this.shadeWidth + WebStepProgress.this.spacing;
                label.setBounds(x, y, ps.width, ps.height);
            }
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container container) {
            Dimension ps;
            Dimension max = this.getMaximumComponentSize();
            Dimension maxSide = this.getMaximumSideComponentSize();
            int midSteps = WebStepProgress.this.steps.size() - 1;
            if (WebStepProgress.this.orientation == 0) {
                WebStepProgress.this.sideWidth = Math.max(maxSide.width / 2, WebStepProgress.this.stepControlWidth / 2 + WebStepProgress.this.shadeWidth);
                int maxSpacing = 0;
                for (int i = 0; i < midSteps; ++i) {
                    Component label1 = WebStepProgress.this.steps.get(i).getLabel();
                    Dimension ps1 = label1 != null ? label1.getPreferredSize() : new Dimension(0, 0);
                    Component label2 = WebStepProgress.this.steps.get(i + 1).getLabel();
                    Dimension ps2 = label2 != null ? label2.getPreferredSize() : new Dimension(0, 0);
                    maxSpacing = Math.max(maxSpacing, ps1.width / 2 + ps2.width / 2);
                }
                int w = (Math.max(WebStepProgress.this.shadeWidth * 2 + WebStepProgress.this.stepControlWidth, maxSpacing) + WebStepProgress.this.stepsSpacing) * midSteps;
                int h = WebStepProgress.this.shadeWidth * 2 + WebStepProgress.this.stepControlWidth + max.height + (max.height > 0 ? WebStepProgress.this.spacing : 0);
                ps = new Dimension(WebStepProgress.this.margin.left + w + WebStepProgress.this.sideWidth * 2 + WebStepProgress.this.margin.right + 1, WebStepProgress.this.margin.top + h + WebStepProgress.this.margin.bottom + 1);
            } else {
                WebStepProgress.this.sideWidth = Math.max(maxSide.height / 2, WebStepProgress.this.stepControlWidth / 2 + WebStepProgress.this.shadeWidth);
                int maxSpacing = 0;
                for (int i = 0; i < midSteps; ++i) {
                    Component label1 = WebStepProgress.this.steps.get(i).getLabel();
                    Dimension ps1 = label1 != null ? label1.getPreferredSize() : new Dimension(0, 0);
                    Component label2 = WebStepProgress.this.steps.get(i + 1).getLabel();
                    Dimension ps2 = label2 != null ? label2.getPreferredSize() : new Dimension(0, 0);
                    maxSpacing = Math.max(maxSpacing, ps1.height / 2 + ps2.height / 2);
                }
                int h = (Math.max(WebStepProgress.this.shadeWidth * 2 + WebStepProgress.this.stepControlWidth, maxSpacing) + midSteps) * midSteps;
                int w = WebStepProgress.this.shadeWidth * 2 + WebStepProgress.this.stepControlWidth + max.width + (max.width > 0 ? WebStepProgress.this.spacing : 0);
                ps = new Dimension(WebStepProgress.this.margin.left + w + WebStepProgress.this.margin.right + 1, WebStepProgress.this.margin.top + h + WebStepProgress.this.sideWidth * 2 + WebStepProgress.this.margin.bottom + 1);
            }
            return ps;
        }

        public Dimension getMaximumComponentSize() {
            Dimension max = new Dimension(0, 0);
            if (WebStepProgress.this.displayLabels && WebStepProgress.this.steps.size() > 0) {
                for (StepData step : WebStepProgress.this.steps) {
                    if (step.getLabel() == null) continue;
                    max = SwingUtils.max(max, step.getLabel().getPreferredSize());
                }
            }
            return max;
        }

        public Dimension getMaximumSideComponentSize() {
            if (WebStepProgress.this.displayLabels && WebStepProgress.this.steps.size() > 0) {
                Component l1 = WebStepProgress.this.steps.get(0).getLabel();
                Component l2 = WebStepProgress.this.steps.get(WebStepProgress.this.steps.size() - 1).getLabel();
                if (l1 != null && l2 != null) {
                    return SwingUtils.max(l1.getPreferredSize(), l2.getPreferredSize());
                }
                if (l1 != null) {
                    return l1.getPreferredSize();
                }
                if (l2 != null) {
                    return l2.getPreferredSize();
                }
                return new Dimension(0, 0);
            }
            return new Dimension(0, 0);
        }
    }

    protected class ProgressMouseAdapter
    extends MouseAdapter {
        protected ProgressMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (WebStepProgress.this.isEnabled() && WebStepProgress.this.isSelectionEnabled() && SwingUtils.isLeftMouseButton(e)) {
                WebStepProgress.this.selecting = true;
                this.updateProgress(e.getPoint());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (WebStepProgress.this.selecting && SwingUtils.isLeftMouseButton(e)) {
                this.updateProgress(e.getPoint());
            }
        }

        protected void updateProgress(Point p) {
            float tp = WebStepProgress.this.getTotalProgressAt(p);
            switch (WebStepProgress.this.selectionMode) {
                case step: {
                    WebStepProgress.this.setSelectedStepIndex(Math.round(tp));
                    break;
                }
                case progress: {
                    WebStepProgress.this.setSelectedStepIndex(Math.round(tp - tp % 1.0f));
                    WebStepProgress.this.setProgress(tp % 1.0f);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (WebStepProgress.this.selecting && SwingUtils.isLeftMouseButton(e)) {
                WebStepProgress.this.selecting = false;
            }
        }
    }
}

