/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.extended.split.MultiSplitConstraints;
import com.alee.extended.split.MultiSplitView;
import com.alee.extended.split.MultiSplitViewState;
import com.alee.extended.split.WebMultiSplitPane;
import com.alee.utils.swing.SizeType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiSplitLayoutHelper {
    protected Map<Component, Dimension> preferredSizes;
    protected Map<Component, Dimension> minimumSizes;
    protected Map<Component, Dimension> maximumSizes;

    public Dimension size(Component component, SizeType sizeType) {
        Dimension size;
        switch (sizeType) {
            case minimum: {
                if (this.minimumSizes == null) {
                    this.minimumSizes = new HashMap<Component, Dimension>(1);
                }
                if (!this.minimumSizes.containsKey(component)) {
                    this.minimumSizes.put(component, component.getMinimumSize());
                }
                size = this.minimumSizes.get(component);
                break;
            }
            case maximum: {
                if (this.maximumSizes == null) {
                    this.maximumSizes = new HashMap<Component, Dimension>(1);
                }
                if (!this.maximumSizes.containsKey(component)) {
                    this.maximumSizes.put(component, component.getMaximumSize());
                }
                size = this.maximumSizes.get(component);
                break;
            }
            default: {
                if (this.preferredSizes == null) {
                    this.preferredSizes = new HashMap<Component, Dimension>(1);
                }
                if (!this.preferredSizes.containsKey(component)) {
                    this.preferredSizes.put(component, component.getPreferredSize());
                }
                size = this.preferredSizes.get(component);
            }
        }
        return size;
    }

    public static class Runtime {
        public final int space;
        public final int totalSizes;
        public final double totalWeights;
        public final int nonZeroViews;
        public final double nonZeroViewsWeights;

        public Runtime(WebMultiSplitPane multiSplitPane, List<MultiSplitView> views) {
            Insets insets = multiSplitPane.getInsets();
            int dividersCount = views.size() - 1;
            int dividersSpace = multiSplitPane.getDividerSize() * dividersCount;
            this.space = Math.max(0, multiSplitPane.getOrientation().isHorizontal() ? multiSplitPane.getWidth() - insets.left - insets.right - dividersSpace : multiSplitPane.getHeight() - insets.top - insets.bottom - dividersSpace);
            int totalSizes = 0;
            double totalWeights = 0.0;
            int nonZeroViews = 0;
            double nonZeroWeights = 0.0;
            for (MultiSplitView view : views) {
                MultiSplitViewState viewState = view.state();
                int size = viewState.size();
                totalSizes += size;
                totalWeights += view.constraints().weight();
                if (size <= 0) continue;
                ++nonZeroViews;
                nonZeroWeights += view.constraints().weight();
            }
            this.totalSizes = totalSizes;
            this.totalWeights = totalWeights;
            this.nonZeroViews = nonZeroViews;
            this.nonZeroViewsWeights = nonZeroWeights;
        }
    }

    public static class Static
    extends MultiSplitLayoutHelper {
        public final boolean horizontal;
        public final int space;
        public final int spaceForPercentViews;
        public final double totalPercentViews;
        public final double totalWeights;
        public final double fillViewSize;

        public Static(WebMultiSplitPane multiSplitPane, List<MultiSplitView> views, SizeType sizeType) {
            this.horizontal = multiSplitPane.getOrientation().isHorizontal();
            Insets insets = multiSplitPane.getInsets();
            int dividersCount = views.size() - 1;
            int dividersSpace = multiSplitPane.getDividerSize() * dividersCount;
            this.space = Math.max(0, this.horizontal ? multiSplitPane.getWidth() - insets.left - insets.right - dividersSpace : multiSplitPane.getHeight() - insets.top - insets.bottom - dividersSpace);
            int totalPixelViews = 0;
            double totalPercentViews = 0.0;
            int fillViewsCount = 0;
            double totalWeights = 0.0;
            for (MultiSplitView view : views) {
                Component component = view.component();
                MultiSplitConstraints constraints = view.constraints();
                if (constraints.isPixels()) {
                    totalPixelViews += constraints.pixels();
                } else if (constraints.isPercents()) {
                    totalPercentViews += constraints.percents();
                } else if (constraints.isFill()) {
                    ++fillViewsCount;
                } else if (constraints.isPreferred()) {
                    Dimension ps = this.size(component, SizeType.preferred);
                    totalPixelViews += this.horizontal ? ps.width : ps.height;
                } else if (constraints.isMinimum()) {
                    Dimension ms = this.size(component, SizeType.minimum);
                    totalPixelViews += this.horizontal ? ms.width : ms.height;
                } else {
                    throw new IllegalArgumentException("Unknown view size value: " + constraints.size());
                }
                totalWeights += constraints.weight();
            }
            this.totalWeights = totalWeights;
            this.fillViewSize = totalPercentViews > 0.0 ? totalPercentViews : 1.0;
            this.totalPercentViews = totalPercentViews + this.fillViewSize * (double)fillViewsCount;
            this.spaceForPercentViews = Math.max(0, this.space - totalPixelViews);
        }
    }
}

