/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.Orientation;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.extended.split.MultiSplitExpansionListener;
import com.alee.extended.split.MultiSplitPaneDividerLayout;
import com.alee.extended.split.MultiSplitPaneModel;
import com.alee.extended.split.WMultiSplitPaneDividerUI;
import com.alee.extended.split.WebMultiSplitPane;
import com.alee.extended.split.WebMultiSplitPaneDivider;
import com.alee.laf.button.WebButton;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebMultiSplitPaneDividerUI<C extends WebMultiSplitPaneDivider>
extends WMultiSplitPaneDividerUI<C> {
    protected WebButton leftOneTouchButton;
    protected WebButton rightOneTouchButton;
    protected transient PropertyChangeListener multiSplitPanePropertyListener;
    protected transient MultiSplitExpansionListener multiSplitExpansionListener;
    protected transient VisibilityBehavior<WebMultiSplitPaneDivider> visibilityBehavior;
    protected transient MouseAdapter dragListener;
    protected transient boolean dragged = false;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebMultiSplitPaneDividerUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        this.divider.setLayout(new MultiSplitPaneDividerLayout());
        StyleManager.installSkin(this.divider);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.divider);
        this.divider.setLayout(null);
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateCursor();
        this.updateOneTouchButtons();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.multiSplitPanePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent event) {
                if (event.getPropertyName().equals("orientation")) {
                    WebMultiSplitPaneDividerUI.this.updateCursor();
                    WebMultiSplitPaneDividerUI.this.updateOneTouchButtons();
                } else if (event.getPropertyName().equals("oneTouchExpandable")) {
                    WebMultiSplitPaneDividerUI.this.updateOneTouchButtons();
                }
            }
        };
        this.divider.getMultiSplitPane().addPropertyChangeListener(this.multiSplitPanePropertyListener);
        this.multiSplitExpansionListener = new MultiSplitExpansionListener(){

            @Override
            public void viewExpanded(@NotNull WebMultiSplitPane multiSplitPane, @NotNull Component view) {
                WebMultiSplitPaneDividerUI.this.updateCursor();
            }

            @Override
            public void viewCollapsed(@NotNull WebMultiSplitPane multiSplitPane, @NotNull Component view) {
                WebMultiSplitPaneDividerUI.this.updateCursor();
            }
        };
        this.divider.getMultiSplitPane().addExpansionListener(this.multiSplitExpansionListener);
        this.visibilityBehavior = new VisibilityBehavior<WebMultiSplitPaneDivider>(this.divider){

            @Override
            protected void displayed(@NotNull WebMultiSplitPaneDivider component) {
                WebMultiSplitPaneDividerUI.this.updateCursor();
            }

            @Override
            protected void hidden(@NotNull WebMultiSplitPaneDivider component) {
                WebMultiSplitPaneDividerUI.this.updateCursor();
            }
        };
        this.visibilityBehavior.install();
        this.dragListener = new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                WebMultiSplitPane multiSplitPane;
                if (e.getClickCount() == 2 && (multiSplitPane = WebMultiSplitPaneDividerUI.this.divider.getMultiSplitPane()).isOneTouchExpandable() && multiSplitPane.isAnyViewExpanded()) {
                    multiSplitPane.collapseExpandedView();
                }
            }

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (SwingUtils.isLeftMouseButton(e) && WebMultiSplitPaneDividerUI.this.divider.isDragAvailable()) {
                    WebMultiSplitPaneDividerUI.this.dragged = true;
                    MultiSplitPaneModel model = WebMultiSplitPaneDividerUI.this.divider.getMultiSplitPane().getModel();
                    if (model != null) {
                        model.dividerDragStarted(WebMultiSplitPaneDividerUI.this.divider, e);
                    }
                    e.consume();
                }
            }

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                if (WebMultiSplitPaneDividerUI.this.dragged) {
                    MultiSplitPaneModel model = WebMultiSplitPaneDividerUI.this.divider.getMultiSplitPane().getModel();
                    if (model != null) {
                        model.dividerDragged(WebMultiSplitPaneDividerUI.this.divider, e);
                    }
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (WebMultiSplitPaneDividerUI.this.dragged) {
                    MultiSplitPaneModel model = WebMultiSplitPaneDividerUI.this.divider.getMultiSplitPane().getModel();
                    if (model != null) {
                        model.dividerDragEnded(WebMultiSplitPaneDividerUI.this.divider, e);
                    }
                    WebMultiSplitPaneDividerUI.this.dragged = false;
                    e.consume();
                }
            }
        };
        this.divider.addMouseListener(this.dragListener);
        this.divider.addMouseMotionListener(this.dragListener);
    }

    @Override
    protected void uninstallListeners() {
        this.divider.removeMouseMotionListener(this.dragListener);
        this.divider.removeMouseListener(this.dragListener);
        this.dragListener = null;
        this.visibilityBehavior.uninstall();
        this.visibilityBehavior = null;
        this.divider.getMultiSplitPane().removeExpansionListener(this.multiSplitExpansionListener);
        this.multiSplitExpansionListener = null;
        this.divider.getMultiSplitPane().removePropertyChangeListener(this.multiSplitPanePropertyListener);
        this.multiSplitPanePropertyListener = null;
        super.uninstallListeners();
    }

    @Override
    public WebButton getLeftOneTouchButton() {
        return this.leftOneTouchButton;
    }

    @Override
    public WebButton getRightOneTouchButton() {
        return this.rightOneTouchButton;
    }

    protected void updateCursor() {
        Orientation orientation = this.divider.getOrientation();
        int cursorType = this.divider.isDragAvailable() ? (orientation.isVertical() ? 11 : 9) : 12;
        this.divider.setCursor(Cursor.getPredefinedCursor(cursorType));
    }

    protected void updateOneTouchButtons() {
        if (this.divider.getMultiSplitPane().isOneTouchExpandable()) {
            if (this.leftOneTouchButton == null && this.rightOneTouchButton == null) {
                this.leftOneTouchButton = this.divider.createLeftOneTouchButton();
                this.rightOneTouchButton = this.divider.createRightOneTouchButton();
                if (this.leftOneTouchButton != null && this.rightOneTouchButton != null) {
                    this.divider.add((Component)this.leftOneTouchButton);
                    this.divider.add((Component)this.rightOneTouchButton);
                }
            }
            DecorationUtils.fireStatesChanged(this.leftOneTouchButton);
            DecorationUtils.fireStatesChanged(this.rightOneTouchButton);
        }
        this.divider.revalidate();
        this.divider.repaint();
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c);
    }
}

