/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.WebContainer;
import com.alee.extended.statusbar.WStatusBarUI;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.toolbar.WhiteSpace;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import java.awt.Component;

public class WebStatusBar
extends WebContainer<WebStatusBar, WStatusBarUI> {
    public WebStatusBar() {
        this(StyleId.auto);
    }

    public WebStatusBar(@NotNull StyleId id) {
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.statusbar;
    }

    public void addToMiddle(@NotNull Component component) {
        this.add(component, (Object)"MIDDLE");
    }

    public void addFill(@NotNull Component component) {
        this.add(component, (Object)"FILL");
    }

    public void addToEnd(@NotNull Component component) {
        this.add(component, (Object)"END");
    }

    public void addSeparator() {
        this.addSeparator("START");
    }

    public void addSeparatorToEnd() {
        this.addSeparator("END");
    }

    public void addSeparator(@Nullable String constraints) {
        this.add((Component)this.createSeparator(), (Object)constraints);
    }

    @NotNull
    protected WebSeparator createSeparator() {
        return new WebSeparator(1);
    }

    public void addSpacing() {
        this.addSpacing(2);
    }

    public void addSpacing(int spacing) {
        this.addSpacing(spacing, "START");
    }

    public void addSpacingToEnd() {
        this.addSpacingToEnd(2);
    }

    public void addSpacingToEnd(int spacing) {
        this.addSpacing(spacing, "END");
    }

    public void addSpacing(int spacing, @Nullable String constraints) {
        this.add((Component)new WhiteSpace(spacing), (Object)constraints);
    }

    @Override
    public WStatusBarUI getUI() {
        return (WStatusBarUI)this.ui;
    }

    public void setUI(WStatusBarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

