/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.svg;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.extended.svg.SvgElements;
import com.alee.extended.svg.SvgIcon;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.collection.ImmutableSet;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class SvgSelector
implements Serializable {
    protected static final String OPEN_BRACE = "[";
    protected static final String CLOSE_BRACE = "]";
    protected static final String ATTRIBUTE_SEPARATOR = ",";
    @NotNull
    protected final String element;
    @NotNull
    protected final Set<String> attributes;

    public SvgSelector(@NotNull String selector) {
        if (TextUtils.isEmpty((String)selector)) {
            String msg = "SVG element selector cannot be empty";
            throw new RuntimeException("SVG element selector cannot be empty");
        }
        int openBrace = selector.indexOf(OPEN_BRACE);
        int closeBrace = selector.indexOf(CLOSE_BRACE);
        if (openBrace != -1 && closeBrace == -1 || openBrace == -1 && closeBrace != -1) {
            String msg = "Incorrect attributes selector syntax";
            throw new RuntimeException("Incorrect attributes selector syntax");
        }
        String rawElement = openBrace != -1 ? selector.substring(0, openBrace) : selector;
        this.element = rawElement.trim().toLowerCase(Locale.ROOT);
        String bracedText = openBrace != -1 ? selector.substring(openBrace + OPEN_BRACE.length(), closeBrace) : null;
        List conditions = TextUtils.stringToList(bracedText, (String)ATTRIBUTE_SEPARATOR);
        this.attributes = new ImmutableSet((Collection)conditions);
    }

    public boolean isApplicable(@NotNull SvgIcon icon, @NotNull SVGElement element) {
        return this.checkSelector(icon, element) && this.checkAttributes(icon, element);
    }

    protected boolean checkSelector(@NotNull SvgIcon icon, @NotNull SVGElement element) {
        boolean match;
        if (TextUtils.isEmpty((String)this.element) || this.element.equals("*")) {
            match = true;
        } else if (this.element.startsWith("#")) {
            String id = this.element.substring(1);
            StyleAttribute attribute = icon.getAttribute(element, "id");
            match = attribute != null && Objects.equals((Object)id, (Object)attribute.getStringValue());
        } else if (this.element.startsWith(".")) {
            String style = this.element.substring(1);
            StyleAttribute attribute = icon.getAttribute(element, "class");
            match = attribute != null && Objects.equals((Object)style, (Object)attribute.getStringValue());
        } else {
            match = element.getClass() == SvgElements.CLASSES.get(this.element);
        }
        return match;
    }

    protected boolean checkAttributes(@NotNull SvgIcon icon, @NotNull SVGElement element) {
        boolean hasAttributes;
        if (CollectionUtils.notEmpty(this.attributes)) {
            hasAttributes = false;
            for (String attribute : this.attributes) {
                if (!icon.hasAttribute(element, attribute)) continue;
                hasAttributes = true;
                break;
            }
        } else {
            hasAttributes = true;
        }
        return hasAttributes;
    }
}

