/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentPaneTransferInfo;
import com.alee.extended.tab.DocumentTransferable;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.slf4j.LoggerFactory;

public class DocumentTransferHandler
extends TransferHandler {
    protected static final int dropSize = 40;
    protected final PaneData paneData;
    protected final WebTabbedPane tabbedPane;
    protected int documentIndex = -1;
    protected DocumentData document = null;

    public DocumentTransferHandler(PaneData paneData) {
        this.paneData = paneData;
        this.tabbedPane = paneData.getTabbedPane();
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        Object documentData;
        MouseEvent me;
        int index;
        if (e instanceof MouseEvent && action == 2 && (index = this.tabbedPane.indexAtLocation((me = (MouseEvent)e).getX(), me.getY())) != -1 && ((DocumentData)(documentData = this.paneData.get(index))).isDraggable()) {
            this.documentIndex = index;
            this.document = documentData;
            super.exportAsDrag(comp, e, action);
            this.paneData.getDocumentPane().checkSelection();
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (this.document != null) {
            this.paneData.remove(this.document);
            WebDocumentPane webDocumentPane = this.paneData.getDocumentPane();
            DocumentPaneTransferInfo transferInfo = new DocumentPaneTransferInfo(webDocumentPane);
            return new DocumentTransferable(this.document, transferInfo);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        WebDocumentPane documentPane = this.paneData.getDocumentPane();
        if (action == 0 && documentPane.getDocument(this.document.getId()) == null) {
            this.paneData.add(this.document, this.documentIndex);
            this.paneData.setSelected(this.document);
        }
        if (this.paneData.count() == 0) {
            this.paneData.getDocumentPane().merge(this.paneData);
        }
        this.documentIndex = -1;
        this.document = null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        try {
            Transferable t = support.getTransferable();
            if (t.isDataFlavorSupported(DocumentTransferable.dataFlavor)) {
                Object transferData = t.getTransferData(DocumentTransferable.transferFlavor);
                if (transferData instanceof DocumentPaneTransferInfo) {
                    DocumentPaneTransferInfo info = (DocumentPaneTransferInfo)transferData;
                    WebDocumentPane dp = this.paneData.getDocumentPane();
                    boolean allowed = dp.isDragBetweenPanesEnabled() && info.isDragBetweenPanesEnabled();
                    return allowed || dp.getId().equals(info.getDocumentPaneId());
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DocumentTransferHandler.class).error(e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            Object data = support.getTransferable().getTransferData(DocumentTransferable.dataFlavor);
            DocumentData document = (DocumentData)data;
            Point dp = support.getDropLocation().getDropPoint();
            WebTabbedPane pane = (WebTabbedPane)support.getComponent();
            int index = pane.getTabAt(dp);
            if (index != -1) {
                Rectangle tb = pane.getBoundsAt(index);
                int di = dp.x < tb.x + tb.width / 2 ? index : index + 1;
                this.paneData.add(document, di);
                this.paneData.setSelected(document);
                this.checkFocusState(this.paneData);
            } else {
                int dropSide = -1;
                if (this.paneData.getDocumentPane().isSplitEnabled() && pane.getTabCount() > 0) {
                    int tabPlacement = pane.getTabPlacement();
                    int w = pane.getWidth();
                    int h = pane.getHeight();
                    if (tabPlacement != 1 && new Rectangle(0, 0, w, 40).contains(dp)) {
                        dropSide = 1;
                    } else if (tabPlacement != 3 && new Rectangle(0, h - 40, w, 40).contains(dp)) {
                        dropSide = 3;
                    } else if (tabPlacement != 2 && new Rectangle(0, 0, 40, h).contains(dp)) {
                        dropSide = 2;
                    } else if (tabPlacement != 4 && new Rectangle(w - 40, 0, 40, h).contains(dp)) {
                        dropSide = 4;
                    }
                }
                if (dropSide != -1) {
                    PaneData<DocumentData> otherPane = this.paneData.getDocumentPane().split(this.paneData, document, dropSide);
                    otherPane.setSelected(document);
                    this.checkFocusState(otherPane);
                } else {
                    this.paneData.add(document);
                    this.paneData.setSelected(document);
                    this.checkFocusState(this.paneData);
                }
            }
            return true;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DocumentTransferHandler.class).error(e.toString(), (Throwable)e);
            return false;
        }
    }

    protected void checkFocusState(final PaneData paneData) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebTabbedPane pane = paneData.getTabbedPane();
                if (!SwingUtils.hasFocusOwner(pane)) {
                    Component c = pane.getSelectedComponent();
                    if (c.isFocusable() || c instanceof Container && SwingUtils.hasFocusableComponent((Container)c)) {
                        pane.transferFocus();
                    } else {
                        pane.requestFocusInWindow();
                    }
                }
            }
        });
    }

    public static void install(final PaneData paneData) {
        final WebTabbedPane tabbedPane = paneData.getTabbedPane();
        MouseAdapter dragAdapter = new MouseAdapter(){
            protected boolean readyToDrag = false;
            protected Point startingPoint = null;

            @Override
            public void mousePressed(MouseEvent e) {
                if (paneData.getDocumentPane().isDragEnabled() && SwingUtils.isLeftMouseButton(e)) {
                    this.readyToDrag = true;
                    this.startingPoint = e.getPoint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.readyToDrag) {
                    Point point = e.getPoint();
                    if (Math.abs(this.startingPoint.x - point.x) > 5 || Math.abs(this.startingPoint.y - point.y) > 5) {
                        this.readyToDrag = false;
                        this.startingPoint = null;
                        tabbedPane.getTransferHandler().exportAsDrag(tabbedPane, e, 2);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtils.isLeftMouseButton(e)) {
                    this.readyToDrag = false;
                }
            }
        };
        tabbedPane.addMouseListener(dragAdapter);
        tabbedPane.addMouseMotionListener(dragAdapter);
        tabbedPane.setTransferHandler(new DocumentTransferHandler(paneData));
    }
}

