/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Function;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.extended.tab.DefaultTabTitleComponentProvider;
import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentDataCancellableRunnable;
import com.alee.extended.tab.DocumentDataRunnable;
import com.alee.extended.tab.DocumentDragViewHandler;
import com.alee.extended.tab.DocumentListener;
import com.alee.extended.tab.DocumentPaneEventMethods;
import com.alee.extended.tab.DocumentPaneEventMethodsImpl;
import com.alee.extended.tab.DocumentPaneListener;
import com.alee.extended.tab.DocumentPaneState;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.SplitData;
import com.alee.extended.tab.StructureData;
import com.alee.extended.tab.TabTitleComponentProvider;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.managers.drag.DragManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.Customizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class WebDocumentPane<T extends DocumentData>
extends WebPanel
implements DocumentPaneEventMethods<T> {
    protected static final String DATA_KEY = "document.pane.data";
    protected final String id;
    protected StructureData root;
    protected PaneData<T> activePane;
    protected Customizer<WebTabbedPane> tabbedPaneCustomizer;
    protected TabTitleComponentProvider<T> tabTitleComponentProvider;
    protected Customizer<WebSplitPane> splitPaneCustomizer;
    protected boolean closable = true;
    protected boolean dragEnabled = true;
    protected boolean dragBetweenPanesEnabled = false;
    protected boolean splitEnabled = true;
    protected boolean tabMenuEnabled = true;
    protected WeakReference<T> previouslySelected = new WeakReference<Object>(null);
    protected Function<String, T> documentsProvider = null;
    protected final DocumentDragViewHandler dragViewHandler;

    public WebDocumentPane() {
        this(StyleId.documentpane, (Customizer<WebSplitPane>)null, (Customizer<WebTabbedPane>)null, (TabTitleComponentProvider<T>)null);
    }

    public WebDocumentPane(Customizer<WebTabbedPane> tabbedPaneCustomizer) {
        this(StyleId.documentpane, null, tabbedPaneCustomizer, null);
    }

    public WebDocumentPane(TabTitleComponentProvider<T> tabTitleComponentProvider) {
        this(StyleId.documentpane, null, null, tabTitleComponentProvider);
    }

    public WebDocumentPane(Customizer<WebTabbedPane> tabbedPaneCustomizer, TabTitleComponentProvider<T> tabTitleComponentProvider) {
        this(StyleId.documentpane, null, tabbedPaneCustomizer, tabTitleComponentProvider);
    }

    public WebDocumentPane(Customizer<WebSplitPane> splitPaneCustomizer, Customizer<WebTabbedPane> tabbedPaneCustomizer) {
        this(StyleId.documentpane, splitPaneCustomizer, tabbedPaneCustomizer, null);
    }

    public WebDocumentPane(Customizer<WebSplitPane> splitPaneCustomizer, Customizer<WebTabbedPane> tabbedPaneCustomizer, TabTitleComponentProvider<T> tabTitleComponentProvider) {
        this(StyleId.documentpane, splitPaneCustomizer, tabbedPaneCustomizer, tabTitleComponentProvider);
    }

    public WebDocumentPane(StyleId id) {
        this(id, (Customizer<WebSplitPane>)null, (Customizer<WebTabbedPane>)null, (TabTitleComponentProvider<T>)null);
    }

    public WebDocumentPane(StyleId id, Customizer<WebTabbedPane> tabbedPaneCustomizer) {
        this(id, null, tabbedPaneCustomizer, null);
    }

    public WebDocumentPane(StyleId id, TabTitleComponentProvider<T> tabTitleComponentProvider) {
        this(id, null, null, tabTitleComponentProvider);
    }

    public WebDocumentPane(StyleId id, Customizer<WebTabbedPane> tabbedPaneCustomizer, TabTitleComponentProvider<T> tabTitleComponentProvider) {
        this(id, null, tabbedPaneCustomizer, tabTitleComponentProvider);
    }

    public WebDocumentPane(StyleId id, Customizer<WebSplitPane> splitPaneCustomizer, Customizer<WebTabbedPane> tabbedPaneCustomizer) {
        this(id, splitPaneCustomizer, tabbedPaneCustomizer, null);
    }

    public WebDocumentPane(StyleId id, Customizer<WebSplitPane> splitPaneCustomizer, Customizer<WebTabbedPane> tabbedPaneCustomizer, TabTitleComponentProvider<T> tabTitleComponentProvider) {
        super(id);
        this.tabbedPaneCustomizer = tabbedPaneCustomizer;
        this.splitPaneCustomizer = splitPaneCustomizer;
        this.tabTitleComponentProvider = tabTitleComponentProvider != null ? tabTitleComponentProvider : this.createDefaultTabTitleComponentProvider();
        this.id = TextUtils.generateId((String)"WDP");
        this.dragViewHandler = new DocumentDragViewHandler(this);
        new VisibilityBehavior<WebDocumentPane<T>>(this){

            @Override
            protected void displayed(@NotNull WebDocumentPane<T> component) {
                DragManager.registerViewHandler(WebDocumentPane.this.dragViewHandler);
            }

            @Override
            protected void hidden(@NotNull WebDocumentPane<T> component) {
                DragManager.unregisterViewHandler(WebDocumentPane.this.dragViewHandler);
            }
        }.install();
        this.initialize();
    }

    protected TabTitleComponentProvider<T> createDefaultTabTitleComponentProvider() {
        return new DefaultTabTitleComponentProvider();
    }

    public String getId() {
        return this.id;
    }

    public Customizer<WebTabbedPane> getTabbedPaneCustomizer() {
        return this.tabbedPaneCustomizer;
    }

    public void setTabbedPaneCustomizer(Customizer<WebTabbedPane> customizer) {
        this.tabbedPaneCustomizer = customizer;
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.updateTabbedPaneCustomizer(this);
        }
    }

    public TabTitleComponentProvider<T> getTabTitleComponentProvider() {
        return this.tabTitleComponentProvider;
    }

    public void setTabTitleComponentProvider(TabTitleComponentProvider<T> provider) {
        this.tabTitleComponentProvider = provider != null ? provider : this.createDefaultTabTitleComponentProvider();
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.updateTabTitleComponents();
        }
    }

    public Customizer<WebSplitPane> getSplitPaneCustomizer() {
        return this.splitPaneCustomizer;
    }

    public void setSplitPaneCustomizer(Customizer<WebSplitPane> customizer) {
        this.splitPaneCustomizer = customizer;
        for (SplitData<T> paneData : this.getAllSplitPanes()) {
            paneData.updateSplitPaneCustomizer(this);
        }
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public boolean isDragBetweenPanesEnabled() {
        return this.dragBetweenPanesEnabled;
    }

    public void setDragBetweenPanesEnabled(boolean dragBetweenPanesEnabled) {
        this.dragBetweenPanesEnabled = dragBetweenPanesEnabled;
    }

    public boolean isSplitEnabled() {
        return this.splitEnabled;
    }

    public void setSplitEnabled(boolean splitEnabled) {
        this.splitEnabled = splitEnabled;
    }

    public boolean isTabMenuEnabled() {
        return this.tabMenuEnabled;
    }

    public void setTabMenuEnabled(boolean tabMenuEnabled) {
        this.tabMenuEnabled = tabMenuEnabled;
    }

    public StructureData getStructureRoot() {
        return this.root;
    }

    public void setStructureRoot(StructureData root) {
        if (this.root != null) {
            this.remove(this.root.getComponent());
        }
        if (root != null) {
            this.add(root.getComponent(), (Object)"Center");
            this.root = root;
            this.activePane = root.findClosestPane();
            this.revalidate();
            this.repaint();
        } else {
            this.initialize();
        }
    }

    protected void initialize() {
        PaneData rootPane = new PaneData(this);
        this.add((Component)rootPane.getTabbedPane(), (Object)"Center");
        this.root = rootPane;
        this.activePane = rootPane;
    }

    public void split(T movedDocument, int direction) {
        PaneData<T> pane = this.getPane(movedDocument);
        if (pane != null) {
            this.split(pane, movedDocument, direction);
        }
    }

    protected PaneData<T> split(PaneData<T> splittedPane, T movedDocument, int direction) {
        PaneData otherPane;
        if (splittedPane != null) {
            SplitData<T> splitData;
            int orientation;
            boolean ltr = direction == 4 || direction == 3;
            int n = orientation = direction == 2 || direction == 4 ? 1 : 0;
            if (splittedPane.getTabbedPane().getParent() == this) {
                otherPane = new PaneData(this);
                Dimension size = splittedPane.getTabbedPane().getSize();
                PaneData first = ltr ? splittedPane : otherPane;
                PaneData last = ltr ? otherPane : splittedPane;
                splitData = new SplitData(this, orientation, first, last);
                this.remove((Component)splittedPane.getTabbedPane());
                this.add((Component)splitData.getSplitPane(), (Object)"Center");
                splitData.getSplitPane().setDividerLocation(orientation == 1 ? size.width / 2 : size.height / 2);
                this.root = splitData;
            } else {
                WebSplitPane parentSplit = (WebSplitPane)splittedPane.getTabbedPane().getParent();
                SplitData<T> parentSplitData = WebDocumentPane.getData(parentSplit);
                if (parentSplitData.getOrientation() == orientation && ltr && parentSplitData.getFirst() == splittedPane && parentSplitData.getLast() instanceof PaneData) {
                    splitData = parentSplitData;
                    otherPane = (PaneData)parentSplitData.getLast();
                } else if (parentSplitData.getOrientation() == orientation && !ltr && parentSplitData.getLast() == splittedPane && parentSplitData.getFirst() instanceof PaneData) {
                    splitData = parentSplitData;
                    otherPane = (PaneData)parentSplitData.getFirst();
                } else {
                    otherPane = new PaneData(this);
                    int parentSplitLocation = parentSplitData.getSplitPane().getDividerLocation();
                    Dimension size = splittedPane.getTabbedPane().getSize();
                    PaneData first = ltr ? splittedPane : otherPane;
                    PaneData last = ltr ? otherPane : splittedPane;
                    splitData = new SplitData(this, orientation, first, last);
                    parentSplitData.replace(splittedPane, splitData);
                    int location = orientation == 1 ? size.width / 2 : size.height / 2;
                    splitData.getSplitPane().setDividerLocation(location);
                    parentSplitData.getSplitPane().setDividerLocation(parentSplitLocation);
                }
            }
            if (movedDocument != null) {
                splittedPane.remove(movedDocument);
                otherPane.add(movedDocument);
            }
            this.revalidate();
            this.repaint();
            otherPane.getTabbedPane().requestFocusInWindow();
            otherPane.activate();
            this.fireSplitted(splittedPane, splitData);
        } else {
            otherPane = null;
        }
        return otherPane;
    }

    public void merge(StructureData toMerge) {
        if (toMerge instanceof PaneData) {
            PaneData mergedPane = (PaneData)toMerge;
            Container parent = mergedPane.getTabbedPane().getParent();
            if (parent instanceof WebSplitPane) {
                WebSplitPane splitPane = (WebSplitPane)parent;
                this.mergeImpl(WebDocumentPane.getData(splitPane));
                this.revalidate();
                this.repaint();
            }
        } else {
            this.mergeImpl((SplitData)toMerge);
            this.revalidate();
            this.repaint();
        }
        this.checkSelection();
    }

    protected void mergeImpl(SplitData<T> splitData) {
        WebSplitPane splitPane;
        StructureData result;
        StructureData first = splitData.getFirst();
        StructureData last = splitData.getLast();
        if (WebDocumentPane.isEmptyPane(first) || WebDocumentPane.isEmptyPane(last)) {
            result = WebDocumentPane.isEmptyPane(first) ? last : first;
        } else {
            if (first instanceof SplitData) {
                this.mergeImpl((SplitData)first);
                first = splitData.getFirst();
            }
            if (last instanceof SplitData) {
                this.mergeImpl((SplitData)last);
                last = splitData.getLast();
            }
            PaneData firstPane = (PaneData)first;
            PaneData lastPane = (PaneData)last;
            PaneData toPane = firstPane.count() > lastPane.count() ? firstPane : lastPane;
            PaneData fromPane = firstPane.count() > lastPane.count() ? lastPane : firstPane;
            for (DocumentData document : CollectionUtils.copy(fromPane.getData())) {
                fromPane.remove(document);
                toPane.add(document);
            }
            result = toPane;
        }
        if (this.activePane == first || this.activePane == last) {
            this.activePane = result.findClosestPane();
        }
        if ((splitPane = splitData.getSplitPane()).getParent() == this) {
            this.remove((Component)splitPane);
            this.add(result.getComponent(), (Object)"Center");
            this.root = result;
        } else {
            WebSplitPane parentSplit = (WebSplitPane)splitPane.getParent();
            SplitData<T> parentSplitData = WebDocumentPane.getData(parentSplit);
            int dividerLocation = parentSplit.getDividerLocation();
            if (parentSplit.getLeftComponent() == splitPane) {
                parentSplitData.setFirst(result);
            } else {
                parentSplitData.setLast(result);
            }
            parentSplit.setDividerLocation(dividerLocation);
        }
        this.fireMerged(splitData, result);
    }

    public PaneData<T> getActivePane() {
        return this.activePane;
    }

    protected void activate(PaneData<T> paneData) {
        if (paneData != null && paneData != this.activePane) {
            this.activePane = paneData;
            this.checkSelection();
        }
    }

    protected void activate(T document) {
        this.activate((T)this.getPane(document));
        this.setSelected((DocumentData)document);
    }

    public T getSelectedDocument() {
        return this.activePane != null ? (T)this.activePane.getSelected() : null;
    }

    public T getDocument(int index) {
        return this.activePane != null ? (T)this.activePane.get(index) : null;
    }

    public T getDocument(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            T document = paneData.get(id);
            if (document == null) continue;
            return document;
        }
        return null;
    }

    public List<T> getDocuments() {
        ArrayList<T> documents = new ArrayList<T>();
        for (PaneData<T> paneData : this.getAllPanes()) {
            documents.addAll(paneData.getData());
        }
        return documents;
    }

    public int getDocumentsCount() {
        int count = 0;
        for (PaneData<T> paneData : this.getAllPanes()) {
            count += paneData.count();
        }
        return count;
    }

    public List<PaneData<T>> getAllPanes() {
        ArrayList<PaneData<T>> panes = new ArrayList<PaneData<T>>();
        this.collectPanes(this.root, panes);
        return panes;
    }

    protected void collectPanes(StructureData structureData, List<PaneData<T>> panes) {
        if (structureData instanceof PaneData) {
            panes.add((PaneData)structureData);
        } else if (structureData instanceof SplitData) {
            SplitData splitData = (SplitData)structureData;
            this.collectPanes(splitData.getFirst(), panes);
            this.collectPanes(splitData.getLast(), panes);
        } else {
            throw new RuntimeException("Unknown structure data type: " + structureData.getClass());
        }
    }

    public List<SplitData<T>> getAllSplitPanes() {
        ArrayList<SplitData<T>> panes = new ArrayList<SplitData<T>>();
        this.collectSplitPanes(this.root, panes);
        return panes;
    }

    protected void collectSplitPanes(StructureData structureData, List<SplitData<T>> splits) {
        if (structureData instanceof SplitData) {
            SplitData splitData = (SplitData)structureData;
            splits.add(splitData);
            this.collectSplitPanes(splitData.getFirst(), splits);
            this.collectSplitPanes(splitData.getLast(), splits);
        }
    }

    public PaneData<T> getPane(T document) {
        return document != null ? this.getPane(((DocumentData)document).getId()) : null;
    }

    public PaneData<T> getPane(String documentId) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (!paneData.contains(documentId)) continue;
            return paneData;
        }
        return null;
    }

    public void setSelected(int index) {
        if (this.activePane != null) {
            this.activePane.setSelected(index);
        }
    }

    public void selectPrevious() {
        if (this.activePane != null) {
            this.activePane.selectPrevious();
        }
    }

    public void selectNext() {
        if (this.activePane != null) {
            this.activePane.selectNext();
        }
    }

    public void setSelected(DocumentData document) {
        this.setSelected(document.getId());
    }

    public void setSelected(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            T document = paneData.get(id);
            if (document == null) continue;
            paneData.setSelected(document);
            paneData.activate();
        }
    }

    public boolean isDocumentOpened(T document) {
        return this.isDocumentOpened(((DocumentData)document).getId());
    }

    public boolean isDocumentOpened(String documentId) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (!paneData.contains(documentId)) continue;
            return true;
        }
        return false;
    }

    public void openDocument(String documentId) {
        this.openDocument(documentId, true);
    }

    public void openDocument(String documentId, boolean select) {
        if (this.documentsProvider != null) {
            this.openDocument((DocumentData)this.documentsProvider.apply((Object)documentId), select);
        }
    }

    public void openDocument(T document) {
        this.openDocument(document, true);
    }

    public void openDocument(T document, boolean select) {
        if (document != null) {
            if (this.isDocumentOpened(document)) {
                if (select) {
                    this.setSelected((DocumentData)document);
                }
            } else if (this.activePane != null) {
                this.activePane.open(document);
                if (select) {
                    this.activePane.setSelected(document);
                }
            } else {
                throw new NullPointerException("Something went wrong, active pane is not available");
            }
        }
    }

    public boolean closeDocument(int index) {
        return this.activePane != null && this.activePane.close(index);
    }

    public boolean closeDocument(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (!paneData.close(id)) continue;
            return true;
        }
        return false;
    }

    public boolean closeDocument(T document) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (!paneData.close(document)) continue;
            return true;
        }
        return false;
    }

    public boolean closeAll() {
        boolean success = true;
        for (PaneData<T> paneData : this.getAllPanes()) {
            success &= paneData.closeAll();
        }
        return success;
    }

    protected void checkSelection() {
        T selected = this.getSelectedDocument();
        if (this.previouslySelected.get() != selected) {
            this.previouslySelected = new WeakReference<T>(selected);
            if (selected != null) {
                PaneData<T> pane = this.getPane(selected);
                this.fireDocumentSelected(selected, pane, pane.indexOf(selected));
            }
        }
    }

    public Function<String, T> getDocumentsProvider() {
        return this.documentsProvider;
    }

    public void setDocumentsProvider(Function<String, T> provider) {
        this.documentsProvider = provider;
    }

    @Nullable
    public DocumentPaneState getDocumentPaneState() {
        return this.root != null ? this.root.getDocumentPaneState() : null;
    }

    public void setDocumentPaneState(DocumentPaneState state) {
        List<T> openedDocuments = this.getDocuments();
        HashMap<String, DocumentData> documents = new HashMap<String, DocumentData>(openedDocuments.size());
        for (DocumentData document : openedDocuments) {
            documents.put(document.getId(), document);
        }
        this.closeAll();
        this.setStructureRoot(this.restoreStructureStateImpl(state, documents));
    }

    protected StructureData<T> restoreStructureStateImpl(final DocumentPaneState state, Map<String, T> documents) {
        StructureData<DocumentData<Object>> restored;
        if (state.isSplit().booleanValue()) {
            Pair<DocumentPaneState, DocumentPaneState> splitState = state.getSplitState();
            StructureData<T> first = this.restoreStructureStateImpl((DocumentPaneState)splitState.getKey(), documents);
            StructureData<T> last = this.restoreStructureStateImpl((DocumentPaneState)splitState.getValue(), documents);
            final SplitData splitData = new SplitData(this, state.getSplitOrientation(), first, last);
            splitData.getSplitPane().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    WebSplitPane splitPane = splitData.getSplitPane();
                    if (splitPane.getWidth() > 0 || splitPane.getHeight() > 0) {
                        splitData.setDividerLocation(state.getDividerLocation());
                        splitPane.removeComponentListener(this);
                    }
                }
            });
            restored = splitData;
        } else {
            String selectedId;
            PaneData<DocumentData> paneData = new PaneData<DocumentData>(this);
            if (state.getDocumentIds() != null) {
                for (String id : state.getDocumentIds()) {
                    DocumentData document;
                    if (this.documentsProvider != null && !documents.containsKey(id)) {
                        documents.put(id, this.documentsProvider.apply((Object)id));
                    }
                    if (!documents.containsKey(id) || (document = (DocumentData)documents.get(id)) == null) continue;
                    paneData.open(document);
                }
            }
            if ((selectedId = state.getSelectedId()) != null && documents.containsKey(selectedId)) {
                paneData.setSelected((DocumentData)documents.get(selectedId));
            }
            restored = paneData;
        }
        return restored;
    }

    public void addDocumentPaneListener(DocumentPaneListener<T> listener) {
        this.listenerList.add(DocumentPaneListener.class, listener);
    }

    public void removeDocumentPaneListener(DocumentPaneListener<T> listener) {
        this.listenerList.remove(DocumentPaneListener.class, listener);
    }

    public void fireSplitted(PaneData<T> splittedPane, SplitData<T> newSplitData) {
        for (DocumentPaneListener listener : (DocumentPaneListener[])this.listenerList.getListeners(DocumentPaneListener.class)) {
            listener.splitted(this, splittedPane, newSplitData);
        }
    }

    public void fireMerged(SplitData<T> mergedSplit, StructureData<T> newStructureData) {
        for (DocumentPaneListener listener : (DocumentPaneListener[])this.listenerList.getListeners(DocumentPaneListener.class)) {
            listener.merged(this, mergedSplit, newStructureData);
        }
    }

    public void fireOrientationChanged(SplitData<T> splitData) {
        for (DocumentPaneListener listener : (DocumentPaneListener[])this.listenerList.getListeners(DocumentPaneListener.class)) {
            listener.orientationChanged(this, splitData);
        }
    }

    public void fireSidesSwapped(SplitData<T> splitData) {
        for (DocumentPaneListener listener : (DocumentPaneListener[])this.listenerList.getListeners(DocumentPaneListener.class)) {
            listener.sidesSwapped(this, splitData);
        }
    }

    public void fireDividerLocationChanged(SplitData<T> splitData) {
        for (DocumentPaneListener listener : (DocumentPaneListener[])this.listenerList.getListeners(DocumentPaneListener.class)) {
            listener.dividerLocationChanged(this, splitData);
        }
    }

    public void addDocumentListener(DocumentListener<T> listener) {
        this.listenerList.add(DocumentListener.class, listener);
    }

    public void removeDocumentListener(DocumentListener<T> listener) {
        this.listenerList.remove(DocumentListener.class, listener);
    }

    public void fireDocumentOpened(T document, PaneData<T> pane, int index) {
        for (DocumentListener listener : (DocumentListener[])this.listenerList.getListeners(DocumentListener.class)) {
            listener.opened(document, pane, index);
        }
    }

    public void fireDocumentSelected(T document, PaneData<T> pane, int index) {
        for (DocumentListener listener : (DocumentListener[])this.listenerList.getListeners(DocumentListener.class)) {
            listener.selected(document, pane, index);
        }
    }

    public boolean fireDocumentClosing(T document, PaneData<T> pane, int index) {
        boolean allow = true;
        for (DocumentListener listener : (DocumentListener[])this.listenerList.getListeners(DocumentListener.class)) {
            allow = allow && listener.closing(document, pane, index);
        }
        return allow;
    }

    public void fireDocumentClosed(T document, PaneData<T> pane, int index) {
        for (DocumentListener listener : (DocumentListener[])this.listenerList.getListeners(DocumentListener.class)) {
            listener.closed(document, pane, index);
        }
    }

    @Override
    public DocumentListener<T> onDocumentOpen(DocumentDataRunnable<T> runnable) {
        return DocumentPaneEventMethodsImpl.onDocumentOpen(this, runnable);
    }

    @Override
    public DocumentListener<T> onDocumentSelection(DocumentDataRunnable<T> runnable) {
        return DocumentPaneEventMethodsImpl.onDocumentSelection(this, runnable);
    }

    @Override
    public DocumentListener<T> onDocumentClosing(DocumentDataCancellableRunnable<T> runnable) {
        return DocumentPaneEventMethodsImpl.onDocumentClosing(this, runnable);
    }

    @Override
    public DocumentListener<T> onDocumentClose(DocumentDataRunnable<T> runnable) {
        return DocumentPaneEventMethodsImpl.onDocumentClose(this, runnable);
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    public static <T extends DocumentData> PaneData<T> getData(WebTabbedPane tabbedPane) {
        return (PaneData)tabbedPane.getClientProperty(DATA_KEY);
    }

    public static <T extends DocumentData> SplitData<T> getData(WebSplitPane splitPane) {
        return (SplitData)splitPane.getClientProperty(DATA_KEY);
    }

    public static boolean isEmptyPane(StructureData data) {
        return data instanceof PaneData && ((PaneData)data).count() == 0;
    }
}

